#include "v3.h"
#include "m33.h"


V3::V3(float x, float y, float z) {

  xyz[0] = x;
  xyz[1] = y;
  xyz[2] = z;

}

// cross product
V3 V3::operator^(V3 op1) {

  V3 ret;
  ret.xyz[0] = xyz[1]*op1.xyz[2]-xyz[2]*op1.xyz[1];
  ret.xyz[1] = xyz[2]*op1.xyz[0]-xyz[0]*op1.xyz[2];
  ret.xyz[2] = xyz[0]*op1.xyz[1]-xyz[1]*op1.xyz[0];

  return ret;

}

float& V3::operator[](int i) {

  return xyz[i];

}

float V3::operator*(V3 op1) {

  V3 &op0 = *this;
  return 
    op0[0]*op1[0] + 
    op0[1]*op1[1] + 
    op0[2]*op1[2];

}

float V3::Length() {

  V3 &op0 = *this;
  return sqrtf(op0*op0);

}

ostream& operator<<(ostream &ostr, V3 v) {

  ostr << v[0] << " " << v[1] << " " << v[2];
  return ostr;

}

V3 V3::operator+(V3 op1) {

  V3 ret, &op0 = *this;
  ret[0] = op0[0] + op1[0];
  ret[1] = op0[1] + op1[1];
  ret[2] = op0[2] + op1[2];
  return ret;

}

V3 V3::operator-(V3 op1) {

  V3 ret, &op0 = *this;
  ret[0] = op0[0] - op1[0];
  ret[1] = op0[1] - op1[1];
  ret[2] = op0[2] - op1[2];
  return ret;

}

V3 V3::operator/(float scf) {

  V3 ret, &v = *this;
  ret[0] = v[0] / scf;
  ret[1] = v[1] / scf;
  ret[2] = v[2] / scf;
  return ret;
}

V3 V3::operator*(float scf) {

  V3 ret, &v = *this;
  ret[0] = v[0] * scf;
  ret[1] = v[1] * scf;
  ret[2] = v[2] * scf;
  return ret;

}

unsigned int V3::UIntColor() {

  V3 &v = *this;
  int rgb[3];
  for (int i = 0; i < 3; i++) {
    rgb[i] = (int) (v[i]*255.0f);
    if (rgb[i] < 0)
      rgb[i] = 0;
    if (rgb[i] > 255)
      rgb[i] = 255;
  }
  unsigned int ret = 0xFF000000 + rgb[2]*256*256 + rgb[1]*256 + rgb[0];
  return ret;

}

V3 V3::UnitVector() {

  V3 ret = *this;
  ret = ret / ret.Length();
  return ret;

}

V3 V3::RotateThisPointAboutAxis(V3 Oa, V3 aDir, float theta) {

  V3 aux;
  // choose the auxiliary axis
  if (
    fabsf(aDir * V3(1.0f, 0.0f, 0.0f)) <
    fabsf(aDir * V3(0.0f, 1.0f, 0.0f))) {
      aux = V3(1.0f, 0.0f, 0.0f); // choose x
  }
  else {
      aux = V3(0.0f, 1.0f, 0.0f); // or y
  }

  // build local coordinate system with given axis direction as "y" (i.e. second) axis
  V3 xp = aux ^ aDir; xp = xp.UnitVector();
  V3 yp = aDir; yp = yp.UnitVector();
  V3 zp = xp ^ yp;
  M33 lcs;
  lcs[0] = xp;
  lcs[1] = yp;
  lcs[2] = zp;

  V3 &P = *this;
  V3 P1 = lcs*(P-Oa); // point in local coordinate system
  M33 roty;
  roty.SetRotationAboutY(theta);
  V3 P2 = roty*P1; // rotated point (still in local coordinate system)
  V3 ret = lcs.Inverted()*P2 + Oa; // rotated point now in original (i.e. world) c.s.

  return ret;

}

V3 V3::RotateThisVectorAboutDirection(V3 aDir, float theta) {

  return RotateThisPointAboutAxis(V3(0.0f, 0.0f, 0.0f), aDir, theta);

}

