#pragma once

#include "gui.h"
#include "framebuffer.h"
#include "ppc.h"
#include "tmesh.h"

#include <iostream>

using namespace std;

class Scene {
public:

  FrameBuffer *fb, *fb3; // SW framebuffer, 3rd person SW framebuffer
  GUI * gui; // graphical user interface
  PPC *ppc; // camera used to render the scene from views chosen by user
  PPC *ppc0, *ppc1; // two cameras in between which we interpolate
  PPC *ppc3; // third person camera
  TMesh *tmeshes;
  int tmeshesN;
  Scene();
  void DBG();
  void Render(); // draw scene geometry into fb as seen by ppc
  void RenderFirstPerson();
  void RenderThirdPerson();

};

extern Scene *scene;

