#include "scene.h"
#include "v3.h"
#include "m33.h"
#include <float.h>

#include <iostream>
#include <fstream>

using namespace std;

Scene *scene;

Scene::Scene() {

  // create user interface
  gui = new GUI();
  gui->show();

  // create SW framebuffer
  int u0 = 20;
  int v0 = 50;
  int sci = 1;
  int w = sci*600;
  int h = sci*400;
  fb = new FrameBuffer(u0, v0, w, h);
  fb->label("SW Framebuffer");
  fb3 = new FrameBuffer(u0+w+u0, v0, w, h);
  fb3->label("3rd person");

  // create camera
  float hfov = 55.0f;
  ppc = new PPC(hfov, w, h);
  ppc0 = new PPC(hfov, w, h);
  ppc1 = new PPC(hfov, w, h);
  *ppc0 = *ppc;
  ppc1->C = ppc1->C + V3 (120.0f, 10.0f, 0.0f);
  ppc1->Pan(45.0f);
  ppc1->Roll(150.0f);

  ppc3 = new PPC(90.0f, w, h);
  ppc3->C = ppc3->C + V3(30.0f, 100.0f, 200.0f);

  fb->show();
  fb3->show();
  
  // position UI window
  gui->uiw->position(u0, fb->h+v0+60);

  tmeshesN = 1;
  tmeshes = new TMesh[tmeshesN];
  tmeshes[0].LoadBin("geometry/teapot1K.bin");
  tmeshes[0].Translate(V3(0.0f, -20.0f, -150.0f));

}

void Scene::Render() {

  RenderFirstPerson();
  RenderThirdPerson();


}

void Scene::RenderFirstPerson() {

  fb->Clear(0xFFFFFFFF, 0.0f);
  for (int tmi = 0; tmi < tmeshesN; tmi++) {
    tmeshes[tmi].RenderWireframe(ppc, fb);
  }
  fb->redraw();

}

void Scene::RenderThirdPerson() {

  fb3->Clear(0xFFFFFFFF, 0.0f);
  for (int tmi = 0; tmi < tmeshesN; tmi++) {
    tmeshes[tmi].RenderWireframe(ppc3, fb3);
  }
  float actualFocalLength = 30.0f;
  ppc->Draw(actualFocalLength, fb3, ppc3);
  ppc0->Draw(actualFocalLength, fb3, ppc3);
  ppc1->Draw(actualFocalLength, fb3, ppc3);
  fb3->redraw();

}

// function linked to the DBG GUI button for testing new features
void Scene::DBG() {

  {

    int stepsN = 100;
    for (int si = 0; si < stepsN; si++) {
      ppc->SetByInterpolation(ppc0, ppc1, (float)si / (float)(stepsN-1));
      Render();
      Fl::check();
    }

    Render();
    return;
  }

  {
    float theta = 1.0f;
    for (int i = 0; i < 30; i++) {
      fb->Clear(0xFFFFFFFF, 0.0f);
      Render();
      ppc->Pan(theta);
      fb->redraw();
      Fl::check();
    }
    return;

  }

  {
    V3 P(0.0f, 20.0f, -100.0f);
    V3 red(1.0f, 0.0f, 0.0f);
    V3 aDir(0.0f, 1.0f, 0.0f);
    V3 Oa(0.0f, 0.0f, -80.0f);
    V3 black(0.0f, 0.0f, 0.0f);
    int pointSize = 13;
    fb->Clear(0xFFFFFFFF, 0.0f);
    fb->Draw3DSegment(Oa, Oa + aDir*50.0f, black, red, ppc);
    for (int i = 0; i < 360; i++) {
      P = P.RotateThisPointAboutAxis(Oa, aDir, 1.0f);
      fb->Draw3DPpoint(P, red, pointSize, ppc);
      fb->redraw();
      Fl::check();
    }
    return;
  }

  {
    V3 P(0.0f, 0.0f, -100.0f);
    V3 color(1.0f, 0.0f, 0.0f);
    fb->Clear(0xFFFFFFFF, 0.0f);
    int pointSize = 7;
    fb->Draw3DPpoint(P, color, pointSize, ppc);
    fb->redraw();
    return;
  }


  for (int fi = 0; fi < 100; fi++) {
    Render();
    Fl::check();
    tmeshes[0].Translate(V3(0.0f, 2.0f, 0.0f));
  }
  return;

  fb->Clear(0xFFFFFFFF, 0.0f);
  V3 P0(-20.0f, 0.0f, -100.0f);
  V3 P1(+20.0f, 0.0f, -100.0f);
  V3 C0(1.0f, 0.0f, 0.0f);
  V3 C1(1.0f, 0.0f, 0.0f);
  fb->Draw3DSegment(P0, P1, C0, C1, ppc);
  fb->redraw();
  return;

  V3 v(1.0f, 2.0f, 3.0f);
  v[1] = 13.0f;
  cerr << "v: " << v << endl;
  return;

  unsigned int bgr = 0xFFFFFFFF;
  fb->Clear(bgr, 0.0f);
  fb->redraw();

//  cerr << "INFO: pressed DBG button" << endl;

  return;

}

