#pragma once

#include "v3.h"
#include "framebuffer.h"

class PPC {
public:
  V3 a, b, c, C;
  int w, h;
  PPC(float hfov, int _w, int _h);
  bool Project(V3 P, V3& projP);
  void Draw(float actualFocalLength, FrameBuffer *fb, PPC *ppc);
  float Getf();
  V3 GetVD();
  V3 Unproject(float uf, float vf, float distance);
  void Pan(float theta);
  void Roll(float theta);
  void SetByInterpolation(PPC *ppc0, PPC *ppc1, float frac);
  void SetByInterpolationOLD(PPC *ppc0, PPC *ppc1, float frac);
  void PositionAndOrient(V3 newC, V3 lookAtPoint, V3 vectorInVerticalPlane);
};