#pragma once

#include <FL/Fl.H>
#include <FL/Fl_Gl_Window.H>
#include <GL/glut.h>

#include "m33.h"
class PPC;

// framebuffer + window class

class FrameBuffer : public Fl_Gl_Window {
public:
  unsigned int *pix; // SW color buffer
  float *zb; // SW z buffer
  int w, h; // image resolution
  FrameBuffer(int u0, int v0, int _w, int _h); // constructor, top left coords and resolution

  // function that is always called back by system and never called directly by programmer
  // programmer triggers framebuffer update by calling FrameBuffer::redraw(), which makes
  //            system call draw
  void draw();

  // function called back when event occurs (mouse, keyboard, etc)
  int handle(int event);
  void KeyboardHandle();

  // set all pixels to given color
  void Clear(unsigned int bgr, float z0);
  void Setf(float uf, float vf, unsigned int color);
  void Setv(V3 projP, V3 colorv);
  void Set(int u, int v, unsigned int color);
  void SetZB(int u, int v, float currz);

  // save as tiff image
  void SaveAsTiff(char *fname);
  void LoadTiff(char *fname);

  // drawing
  void Draw3DSegment(V3 P0, V3 P1, V3 C0, V3 C1, PPC *ppc);
  void Draw2DSegment(V3 P0, V3 P1, V3 C0, V3 C1);
  void Draw3DPpoint(V3 P, V3 C, int pointSize, PPC *ppc);

  bool IsFarther(V3 projP);

};


