#pragma once

#include "v3.h"
#include "framebuffer.h"
#include "ppc.h"

class TMesh {
public:
  V3 *verts, *cols, *normals; // vertex coordinates, vertex colors, vertex normals
  int vertsN; // number of vertices

  unsigned int *tris; // connectivity data; triangle i has 
      // vertices verts[tris[3*i+0]], verts[tris[3*i+1]], verts[tris[3*i+2]]
  int trisN; // number of triangles (not number of indices in array)
  TMesh() : verts(0), cols(0), normals(0), vertsN(0), tris(0), trisN(0) {};
  void LoadBin(char *fname); // load from bin file

  // drawing
  void RenderWireframe(PPC *ppc, FrameBuffer *fb);

  // transformations
  void Translate(V3 tv);
};