#include "v3.h"
#include "m3x3.h"
#include <math.h>

V3::V3(float x, float y, float z) {

  xyz[0] = x;
  xyz[1] = y;
  xyz[2] = z;

}

ostream& operator<<(ostream& ostr, V3 v) {

  ostr << v.xyz[0] << " " << v.xyz[1] << " " << v.xyz[2] << " ";
  return ostr;

}

istream& operator>>(istream& istr, V3& v) {

  istr >> v.xyz[0] >> v.xyz[1] >> v.xyz[2];
  return istr;

}

V3 V3::operator+(V3 v1) {

  V3 ret;
  ret[0] = (*this)[0] + v1[0];
  ret[1] = (*this)[1] + v1[1];
  ret[2] = (*this)[2] + v1[2];
  return ret;

}

V3 V3::operator-(V3 v1) {

  V3 ret;
  ret[0] = (*this)[0] - v1[0];
  ret[1] = (*this)[1] - v1[1];
  ret[2] = (*this)[2] - v1[2];
  return ret;

}

float& V3::operator[](int i) {

  return xyz[i];

}

float V3::operator*(V3 v1) {

  V3 &v0 = *this;
  return v0[0]*v1[0]+v0[1]*v1[1]+v0[2]*v1[2];

}


V3 V3::operator^(V3 v1) {

  V3 ret;
  V3 &v0 = *this;
  ret[0] = v0[1]*v1[2]-v0[2]*v1[1];
  ret[1] = v0[2]*v1[0]-v0[0]*v1[2];
  ret[2] = v0[0]*v1[1]-v0[1]*v1[0];
  return ret;

}

V3 V3::operator/(float sc) {

  return V3(xyz[0]/sc, xyz[1]/sc, xyz[2]/sc);

}

V3 V3::operator*(float sc) {

  return V3(xyz[0]*sc, xyz[1]*sc, xyz[2]*sc);

}

V3::V3(unsigned int color) {

  unsigned char* uc = (unsigned char*)&color;
  xyz[0] = (float) uc[0];
  xyz[1] = (float) uc[1];
  xyz[2] = (float) uc[2];

}

float V3::Length() {

  return sqrtf((*this)*(*this));

}

unsigned int V3::Color() {

  unsigned int ret = 0xFF000000;
  unsigned int red = (unsigned int) xyz[0];
  unsigned int green = (unsigned int) xyz[1];
  unsigned int blue = (unsigned int) xyz[2];
  ret += red + green * 256 + blue * 256*256;
  return ret;

}

M3x3 V3::MakeCSThisY() {

  M3x3 cs;
  
  V3 &axis = (*this);
  V3 auxAxis = (fabsf(axis[0])<fabsf(axis[1])) ?
    V3(1.0f, 0.0f, 0.0f) : V3(0.0f, 1.0f, 0.0f);

  V3 xaxis = (axis^auxAxis).Normalized();
  V3 zaxis = xaxis ^ axis.Normalized();
  cs[0] = xaxis;
  cs[1] = axis.Normalized();
  cs[2] = zaxis;
  return cs;

}

V3 V3::RotateThisVectorAboutAxis(V3 axis, 
                                 float rstep) {

  // create coordinate system CS with axis as y axis
  M3x3 cs = axis.MakeCSThisY();
  // transform this to CS
  V3 &v = (*this);
  V3 rv = cs*v;
  // rotate about y rstep degrees
  M3x3 roty;
  roty.SetRotY(rstep);
  V3 rrv = roty*rv;
  // transform back
  V3 ret = cs.Invert()*rrv;
  return ret;

}

V3 V3::Normalized() {

  return (*this)/Length();

}

// normal is "*this", and it is normalized
V3 V3::Reflect(V3 v) {

  V3 &n = *this;
  V3 vn = n*(v*n);
  V3 vt = v - vn;
  V3 ret = v - vt*2.0f;
  return ret;
  
}
