#include "triangle.h"
#include "m3x3.h"
#include "linesegment.h"

Triangle::Triangle(V3 v0, V3 v1, V3 v2) {

  verts[0] = v0;
  verts[1] = v1;
  verts[2] = v2;

}

void Triangle::DrawWireframe(FrameBuffer *fb, unsigned int color) {

  for (int i = 0; i < 3; i++) {
    V3 V0 = verts[i];
    V3 V1 = verts[(i+1)%3];
    LineSegment ls(V0, V1);
    ls.Draw2D(fb, color);
  }

}

void Triangle::Rasterize(FrameBuffer *fb, unsigned int color) {

  float leftf = verts[0][0];
  float rightf = verts[0][0];
  float topf = verts[0][1];
  float bottomf = verts[0][1];

  for (int i = 1; i < 3; i++) {
    if (leftf > verts[i][0])
      leftf = verts[i][0];
    if (rightf < verts[i][0])
      rightf = verts[i][0];
    if (topf > verts[i][1])
      topf = verts[i][1];
    if (bottomf < verts[i][1])
      bottomf = verts[i][1];
  }

  if (bottomf < 0.0f || topf > (float) fb->h || leftf > (float) fb->w ||
    rightf < 0.0f)
    return;

  if (leftf < 0.0f)
    leftf = 0.0f;
  if (rightf > (float)fb->w)
    rightf = (float)fb->w;
  if (topf < 0.0f)
    topf = 0.0f;
  if (bottomf > (float)fb->h)
    bottomf = (float)fb->h;

  V3 edges[3];
  for (int i = 0; i < 3; i++) {
    int _i = (i+1)%3;
    edges[i][0] = verts[_i][1]-verts[i][1];
    edges[i][1] = verts[i][0]-verts[_i][0];
    edges[i][2] = -verts[i][0]*edges[i][0]-
      verts[i][1]*edges[i][1];
    if (edges[i]*V3(verts[(i+2)%3][0],  verts[(i+2)%3][1], 1.0f) < 0)
      edges[i] = edges[i]*-1.0f;
  }

  V3 ABCz;
  M3x3 bary;
  bary[0] = V3(verts[0][0], verts[0][1], 1.0f);
  bary[1] = V3(verts[1][0], verts[1][1], 1.0f);
  bary[2] = V3(verts[2][0], verts[2][1], 1.0f);
  bary = bary.Invert();
  ABCz = bary*V3(verts[0][2], verts[1][2], verts[2][2]);
  V3 ABCred;
  ABCred = bary*V3(colors[0][0], colors[1][0], colors[2][0]);
  V3 ABCgreen;
  ABCgreen = bary*V3(colors[0][1], colors[1][1], colors[2][1]);
  V3 ABCblue;
  ABCblue = bary*V3(colors[0][2], colors[1][2], colors[2][2]);

  for (int v = (int) topf; v <= (int) bottomf; v++) {
    for (int u = (int) leftf; u <= (int) rightf; u++) {
      V3 uvf(.5f+(float)u, .5f+(float)v, 1.0f);
      if (uvf*edges[0] < 0.0f 
        || uvf*edges[1] < 0.0f || 
        uvf*edges[2] < 0.0f)
        continue;
      float z = uvf*ABCz;
      if (!fb->Closer(u, v, z))
        continue;
      V3 currColor(uvf*ABCred, uvf*ABCgreen, uvf*ABCblue);
      fb->SetGuarded(uvf[0], uvf[1], (currColor*255.0f).Color(), z);
    }
  }

}
