#pragma once

#include "v3.h"
#include "framebuffer.h"
#include "ppc.h"

class TMesh {
public:
  V3 *verts;
  int vertsN;
  V3 *normals, *colors;
  unsigned int *tris;
  int trisN;
  TMesh() : verts(0), normals(0), colors(0), tris(0), vertsN(0), trisN(0) {};
  TMesh(V3 C, V3 dims);
  TMesh(FrameBuffer *fb, PPC *ppc, float _1ow = -1.0f);
  void Project(PPC *ppc, V3 *&projVerts);
  void RenderPoints(int ptSize, unsigned int color, 
    PPC *ppc, FrameBuffer *fb);
  void RenderWF(unsigned int color, 
    PPC *ppc, FrameBuffer *fb);
  void RenderFilled(PPC *ppc, FrameBuffer *fb);
  void Load(char *fname);
  void Translate(V3 transv);
  void TranslateTo(V3 newCenter);
  V3 GetCenter();
  void Scale(float toSize);
  void BoundingBox(V3 bb[2]);
  void Light(V3 pointLightSource, V3 Eye);
  void Explode();
};