#include "scene.h"
#include "ppc.h"
#include "linesegment.h"
#include "triangle.h"
#include "tmesh.h"

Scene *scene;

#include <iostream>
#include <fstream>

using namespace std;


Scene::Scene() {

  gui = new GUI();
  gui->show();

  int u0 = 0;
  int v0 = 0;
  int w = 640;
  int h = 480;
  fb = new FrameBuffer(u0, v0, w, h);
  fb->label("Frame Buffer");
  fb->show();

  gui->uiw->position(fb->w+20, 40);

  tmesh = new TMesh();
  tmesh->Load("geometry/teapot57K.bin");
  tmesh->Scale(50.0f);
  tmesh->TranslateTo(V3(0.0f, 0.0f, -50.0f));
  for (int i = 0; i < tmesh->vertsN; i++) {
    tmesh->colors[i] = V3(1.0f, 0.0f, 0.0f);
  }
//  tmesh->Explode();

  tmesh2 = 0;
#if 0
  tmesh2 = new TMesh();
  tmesh2->Load("geometry/teapot1K.bin");
  tmesh2->Scale(20.0f);
  tmesh2->TranslateTo(V3(-10.0f, 0.0f, -75.0f));
#endif

  ppc2 = 0;
  tmesh3 = 0;

  float hfov = 55.0f;
  ppc = new PPC(hfov, w, h);


  V3 pointLightSource = ppc->C;// + V3(0.0f, 50.0f, 0.0f);
  tmesh->Light(pointLightSource, ppc->C);

  Render();

}

void Scene::DBG() {

  V3 v(10.0f, 0.0f, 0.0f);
  V3 n(0.0f, 1.0f, 0.0f);
  V3 r = n.Reflect(v);
  return;

  int w = fb->w;
  int h = fb->h;
  float hfov = 45.0f;

  ppc2 = new PPC(*ppc);

  float desiredFocalLength = 20.0f;
  fb->ClearBuffers();
  tmesh->RenderFilled(ppc2, fb);
  tmesh2 = new TMesh(fb, ppc2);
  tmesh3 = new TMesh(fb, ppc2, ppc2->FocalLength()/desiredFocalLength);
  for (int i = 0; i < tmesh->vertsN; i++) {
    tmesh->colors[i] = tmesh->colors[i] / 4.0f;
    tmesh->colors[i][0] = tmesh->colors[i][0] * 8.0f;
    tmesh->colors[i][0] = (tmesh->colors[i][0] > 1.0f) ? 1.0f : 
      tmesh->colors[i][0];
  }

}

void Scene::Render() {

  fb->ClearBuffers();
 
  if (tmesh)
    tmesh->RenderFilled(ppc, fb);

  if (tmesh2)
    tmesh2->RenderPoints(1, 0xFF000000, ppc, fb);
    
  if (tmesh3)
    tmesh3->RenderPoints(1, 0xFF000000, ppc, fb);

  float desiredFocalLength = 20.0f;
  if (ppc2)
    ppc2->Visualize(ppc, fb, desiredFocalLength, 0xFF000000);

  fb->redraw();


}

void Scene::LoadView() {

  if (ppc) {
    ifstream ifs("mydbg/view.txt");
    ifs >> *ppc;
    ifs.close();
  }

  Render();
  fb->redraw();

}

void Scene::SaveView() {

  if (ppc) {
    ofstream ofs("mydbg/view.txt");
    ofs << *ppc;
    ofs.close();
  }

}