#pragma once

#include "v3.h"
#include "framebuffer.h"

class PPC {
public:
  V3 a, b, c, C;
  int w, h;
  PPC(float hfov, int w, int h);
  bool Project(V3 P, V3 &projP);
  void TranslateFB(float step);
  void TranslateLR(float step);
  void TranslateUD(float step);
  void Pan(float rstep);
  void Tilt(float rstep);
  void Visualize(PPC *ppc, FrameBuffer *fb, float f, 
    unsigned int color);
  float FocalLength();
  void Zoom(float focalLengthScale);
  V3 GetPoint(int u, int v, float _1ow);
  friend ostream& operator<<(ostream &ostr, PPC &ppc);
  friend istream& operator>>(istream &istr, PPC &ppc);
};