#include "m3x3.h"
#include <math.h>

V3& M3x3::operator[](int i) {

  return rows[i];

}

V3 M3x3::operator*(V3 v) {

  V3 ret;
  ret[0] = rows[0]*v;
  ret[1] = rows[1]*v;
  ret[2] = rows[2]*v;
  return ret;

}

M3x3 M3x3::operator*(M3x3 m1) {

  M3x3 ret;
  M3x3 &m0 = (*this);
  ret.SetColumn(0, m0*m1.GetColumn(0));
  ret.SetColumn(1, m0*m1.GetColumn(1));
  ret.SetColumn(2, m0*m1.GetColumn(2));
  return ret;

}


V3 M3x3::GetColumn(int i) {

  V3 ret(rows[0][i], rows[1][i], rows[2][i]);
  return ret;

}

void M3x3::SetColumn(int i, V3 v) {

  rows[0][i] = v[0];
  rows[1][i] = v[1];
  rows[2][i] = v[2];

}

M3x3 M3x3::Invert() {

  M3x3 ret;
  V3 a = GetColumn(0), b = GetColumn(1), c = GetColumn(2);
  V3 _a = b ^ c; _a = _a / (a * _a);
  V3 _b = c ^ a; _b = _b / (b * _b);
  V3 _c = a ^ b; _c = _c / (c * _c);
  ret[0] = _a;
  ret[1] = _b;
  ret[2] = _c;

  return ret;

}

void M3x3::SetRotY(float rstep) {

  float rrstep = rstep/180.0f*3.1415926535f;
  rows[0] = V3(cosf(rrstep), 0.0f, sinf(rrstep));
  rows[1] = V3(0.0f, 1.0f, 0.0f);
  rows[2] = V3(-sinf(rrstep), 0.0f, cosf(rrstep));

}
