
#include "linesegment.h"
#include <math.h>


void LineSegment::Draw2D(FrameBuffer *fb, unsigned int color) {

  int pixN;
  float du = P0[0]-P1[0];
  float dv = P0[1]-P1[1];
  if (fabsf(du) < fabsf(dv)) {
    pixN = (int)ceilf(fabsf(dv));
  }
  else {
    pixN = (int)ceilf(fabsf(du));
  }

  V3 currp = P0;
  V3 d = (P1-P0)/(float)pixN;
  for (int i = 0; i < pixN; i++) {
    fb->SetGuarded(currp[0], currp[1], color);
    currp = currp + d;
  }

}
