#pragma once

#include <FL/Fl.H>
#include <FL/Fl_Gl_Window.H>
#include <GL/glut.h>

#include "v3.h"

class FrameBuffer : public Fl_Gl_Window {
public:
  unsigned int *pix;
  float *zb;
  int w, h;
  FrameBuffer(int u0, int v0, int _w, int _h);
  FrameBuffer();
  void Set(unsigned int color);
  void draw();
  int handle(int event) ;
  void SetChecker(int cw, unsigned int colors[2]);
  void Set(int u, int v, unsigned int color);
  unsigned int Get(int u, int v);
  void SetGuarded(float uf, float vf, unsigned int color, float z = -1.0f);
  void EdgeMap(FrameBuffer *&edgeMap);
  int Load(char *tiffFileName);
  void DrawPoint(V3 pt, int ptSize, unsigned int color);
  void ClearBuffers();
  bool Closer(int u, int v, float z);
  void KeyboardHandle();
};
