#include "GL/glew.h"

#include "scene.h"
#include "v3.h"
#include "m33.h"
#include "ppc.h"
#include "TM.h"

Scene *scene;


#include <iostream>
#include <fstream>
#include <strstream>

using namespace std;


Scene::Scene() {


	int u0 = 20;
	int v0 = 40;
	int h = 400;
	int w = 600;
	fb = new FrameBuffer(u0, v0, w, h);
	fb->position(u0, v0);
	fb->label("First Person View SW");
	fb->show();
	fb->redraw();

	fb3 = new FrameBuffer(u0, v0, w, h);
	fb3->position(u0+w+u0, v0);
	fb3->label("Third Person View");
	fb3->show();
	fb3->redraw();

	fb3->hide();
	hwfb = new FrameBuffer(u0, v0, w, h);
	hwfb->position(u0+w+u0, v0);
	hwfb->label("First Person View HW");
	hwfb->ishw = 1;
//	hwfb->show();
	hwfb->redraw();

	gui = new GUI();
	gui->show();
	gui->uiw->position(u0, v0 + fb->h + v0);

	tmsN = 2;
	tms = new TM[tmsN];
	tms[0].LoadBin("geometry/teapot1K.bin");
//	tms[0].LoadBin("geometry/teapot57K.bin");
	tms[0].Position(V3(0.0f, 0.0f, -150.0f));

	V3 vs[4];
	AABB aabb = tms[0].GetAABB();
	V3 qc = tms[0].GetCenter(); qc[1] = aabb.c0[1];
	float qs2 = 55.0f;
	vs[0] = qc + V3(-qs2, 0.0f, -qs2);
	vs[1] = qc + V3(-qs2, 0.0f, +qs2);
	vs[2] = qc + V3(+qs2, 0.0f, +qs2);
	vs[3] = qc + V3(+qs2, 0.0f, -qs2);
	tms[1].SetQuad(vs);
	tms[1].colors[0] =
		tms[1].colors[1] =
		tms[1].colors[2] =
		tms[1].colors[3] = V3(1.0f, 0.0f, 0.0f);
	FrameBuffer *texfb = new FrameBuffer(100, 100, 64, 64);
	texfb->SetChecker(8, 0xFF000000, 0xFFFFFFFF);
	tms[1].tex = texfb;

	// create camera
	float hfov = 60.0f;
	ppc = new PPC(hfov, fb->w, fb->h);
	ppc3 = new PPC(hfov, fb3->w, fb3->h);
	V3 LAP = (ppc->C + tms[0].GetCenter())*0.5f;
	V3 newC = ppc->C + V3(100.0f, 100.0f, 100.0f);
	V3 upv(0.0f, 1.0f, 0.0f);
	ppc3->Pose(newC, LAP, upv);

	// shaders
	cgi = 0;
	soi = 0;

	tms[0].on = 1;
	Render();

}

void Scene::Render(PPC *usePPC, FrameBuffer *useFB) {


	useFB->Set(0xFFFFFFFF);
	useFB->SetZB(0.0f); // 1/w = 0.0f means infinitely far away

	for (int tmi = 0; tmi < tmsN; tmi++) {
//		tms[tmi].DrawWireFrame(0xFF000000, usePPC, useFB);
		tms[tmi].RenderFilled(usePPC, useFB);
	}
	useFB->redraw();


}

void Scene::Render() {

	if (fb) {
		RayTrace();
		fb->redraw();
		return;
	}

	if (fb)
		Render(ppc, fb);
	if (hwfb)
		hwfb->redraw();
	if (fb3) {
		Render(ppc3, fb3);
	ppc->Visualize(ppc3, fb3, 15.0f);

#if 0
		fb3->Set(0xFFFFFFFF);
		fb3->SetZB(0.0f);
		fb3->DrawFBPointCloud(fb, ppc, ppc3);
		fb3->redraw();
#endif
	}

}

void Scene::DBG() {

	cerr << endl;

	{
		int fn = 1000;
		for (int fi = 0; fi < fn; fi++) {
			mFraction = (float)fi / (float)(fn - 1);
			Render();
			Fl::check();
		}
		return;
	}


	V3 C1 = ppc->C + V3(30.f, 100.0f, 0.0f);
	V3 C0 = ppc->C;
	V3 cn = tms[0].GetCenter();
	int fN = 100;
	for (int fi = 0; fi < fN; fi++) {
		Render();
		Fl::check();
		V3 C = C0 + (C1 - C0)*(float)fi / (float) (fN - 1);
		ppc->Pose(C, cn, V3(0.0f, 1.0f, 0.0f));
	}
	return;



	{


		V3 vs[4];
		vs[0] = V3(-40.0f, +20.0f, -100.0f);
		vs[1] = V3(-40.0f, -20.0f, -100.0f);
		vs[2] = V3(+40.0f, -20.0f, -100.0f);
		vs[3] = V3(+40.0f, +20.0f, -100.0f);

		vs[0] = V3(-40.0f, +40.0f, -10.0f);
		vs[1] = V3(-40.0f, -40.0f, -10.0f);
		vs[2] = V3(+40.0f, -40.0f, -10.0f);
		vs[3] = V3(+40.0f, +40.0f, -10.0f);

		tms[0].SetQuad(vs);

		fb3->hide();

		tms[0].tex = new FrameBuffer(10, 10, 1024, 1024);
		tms[0].tex->SetChecker(1, 0xFF000000, 0xFFFFFFFF);
//		tms[0].tex->show();
		for (int fi = 0; fi < 10000; fi++) {
			Render();
			Fl::check();
			tms[0].Translate(V3(0.0f, 0.0f, -.1f));
		}
		return;

		for (int i = 0; i < 45; i++) {
			Render();
			Fl::check();
			tms[0].RotateAboutArbitraryAxis(tms[0].GetCenter(), V3(0.0f, 1.0f, 0.0f), 1.0f);
		}
		return;
	}

	{
		for (int fi = 0; fi < 360; fi++) {
			Render();
			ppc->Pan(1.0f);
			Fl::check();
		}
		return;
	}

	{
		V3 P(0.0f, -20.0f, -100.0f);
		V3 n(0.0f, 1.0f, 0.0f);
		V3 l(-1.0f, 1.0f, 0.0f);
		V3 r = n.Reflect(l);
		fb->Set(0xFFFFFFFF);
		fb->SetZB(0.0f);
		fb->DrawPoint3D(P, ppc, 7, 0xFF000000);
		fb->Draw3DSegment(V3(0.0f, 0.0f, 0.0f), V3(0.0f, 1.0f, 0.0f),
			ppc, P, P + l.Normalized()*17.0f);
		fb->Draw3DSegment(V3(0.0f, 0.0f, 0.0f), V3(1.0f, 0.0f, 0.0f),
			ppc, P, P + r.Normalized()*17.0f);
		fb->Draw3DSegment(V3(0.0f, 0.0f, 0.0f), V3(0.0f, 0.0f, 1.0f),
			ppc, P, P + n.Normalized()*7.0f);
		fb->redraw();
		return;
	}


	{
		V3 ld(0.0f, 0.0f, 1.0f);
		float ka = 0.04f;
		V3 teapotCenter = tms[0].GetCenter();
		V3 L = teapotCenter + V3(0.0f, 0.0f, 30.0f);
		for (int fi = 0; fi < 360; fi++) {
			fb->Set(0xFFFFFFFF);
			fb->SetZB(0.0f);
			tms[0].LightP(L, ka);
			Render();
			fb->DrawPoint3D(L, ppc, 13, 0xFF00FFFF);
			fb->redraw();
			Fl::check();
			L = L.RotateThisPointAboutArbitraryAxis(teapotCenter, 
				V3(0.0f, 1.0f, 0.0f),
				1.0f);
//			L = L + V3(0.0f, 0.0f, -.1f);
		}
		return;
		tms[0].VisualizeNormals(9.0f, ppc, fb);
		fb->redraw();
		return;
	}

	{
		// load triangle mesh
		TM tm;
		tm.LoadBin("geometry/teapot1K.bin");

		tm.Position(V3(0.0f, 0.0f, -150.0f));

		// create camera
		float hfov = 60.0f;
		PPC ppc(hfov, fb->w, fb->h);
		// translate backwards to teapot
//		ppc.Translate(V3(0.0f, 0.0f, 250.0f));
		// clear framebuffer
		fb->Set(0xFFFFFFFF);

		// render mesh with one point per vertex; // no triangles (yet)
		tm.DrawPoints(0xFF000000, 3, &ppc, fb);

		// refresh window
		fb->redraw();

//		return;
		
		// spin the teapot in place (about a vertical axis passing through its center)
		V3 ad(0.0f, 1.0f, 0.0f);
		V3 aO = tm.GetCenter();
		for (int fi = 0; fi < 360; fi++) {
			fb->Set(0xFFFFFFFF);
//			tm.DrawPoints(0xFF000000, 3, &ppc, fb);
			tm.DrawWireFrame(0xFF000000, &ppc, fb);
			fb->redraw();
			Fl::check();
			tm.RotateAboutArbitraryAxis(aO, ad, 1.0f);
		}

		return;



	}


	{
		V3 p0(10.0f, 200.0f, 0.0f);
		V3 p1(210.0f, 200.0f, 0.0f);
		fb->Set(0xFFFFFFFF);
		V3 C0(1.0f, 0.0f, 0.0f);
		V3 C1(0.0f, 1.0f, 0.0f);
		fb->Draw2DSegment(C0, C1, p0, p1);
		fb->redraw();
		return;
	}


	{
		float hfov = 60.0f;
		PPC ppc(hfov, fb->w, fb->h);
		V3 PL(-5.0f, -5.0f, -20.0f);
		V3 PR(+5.0f, -5.0f, -20.0f);
		V3 PP;

		V3 cube[8];
		V3 cubeCenter(0.0f, 0.0f, -10.0f);
		float a = 2.0f;
		cube[0] = cubeCenter + V3(-a, a, a);
		cube[1] = cube[0] + V3(0.0f, -2.0f*a, 0.0f);
		cube[2] = cube[1] + V3(2.0f*a, 0.0f, 0.0f);
		cube[3] = cube[2] + V3(0.0f, 2.0f*a, 0.0f);

		int framesN = 3000;
		V3 tv(0.001f, 0.0f, 0.0f);
		for (int fi = 0; fi < framesN; fi++) {

			for (int vi = 0; vi < 4; vi++) {
				cube[vi + 4] = cube[vi] + V3(0, 0, -2.0f*a);
			}
			fb->Set(0xFFFFFFFF);
			for (int vi = 0; vi < 8; vi++) {
				V3 PP;
				ppc.Project(cube[vi], PP);
				if (vi < 4)
					fb->DrawPoint2D(PP, 13, 0xFF0000FF);
				else
					fb->DrawPoint2D(PP, 13, 0xFFFF0000);
			}
			fb->redraw();
			Fl::check();
			ppc.Translate(tv);
		}

		return;

		framesN = 1000;
		float tstep = 0.01f;
		for (int fi = 0; fi < framesN; fi++) {
			fb->Set(0xFFFFFFFF);
			ppc.Project(PL, PP);
			fb->DrawPoint2D(PP, 13, 0xFFFF0000);
			ppc.Project(PR, PP);
			fb->DrawPoint2D(PP, 13, 0xFFFF0000);
			fb->redraw();
			Fl::check();
			PL[2] -= tstep;
			PR[2] -= tstep;
		}

		return;

	}

	{
		V3 v0(10.0f, -1.0f, 0.0f);
		V3 v1(3.0f, 1.0f, 2.0f);
		V3 v2(-7.0f, 0.0f, 1.0f);
		M33 m(v0, v1, v2), minv;
		minv = m.Inverted();
		cerr << minv*m.GetColumn(0) << endl;
		cerr << minv*m.GetColumn(1) << endl;
		cerr << minv*m.GetColumn(2) << endl;
		return;


		cerr << m[0][0] << endl;
		m[0][0] = -1.0f;
		cerr << m[0][0] << endl;
		cerr << m*v2 << endl;
		return;
	}

	{
		V3 v(1.0f, 2.0f, 3.0f);
		cerr << "vector v: " << v << endl;
		cerr << "length of v: " << v.Length() << endl;
		cerr << "vx3: " << v*3.0f << endl;
		cerr << "v.Normalized(): " << v.Normalized() << endl;
		cerr << v.Normalized().Length() << endl;
		return;
	}

	int stepsN = 10000;
	for (int si = 0; si < stepsN; si++) {
		fb->Set(0xFFFFFFFF);
		int v = fb->h / 2;
		for (int u = 100; u < 200; u++) {
			fb->SetSafe(u + si, v, 0xFF000000);
		}
		fb->redraw();
		Fl::check();
	}
	return;


	V3 v0(1.0f, 2.0f, 3.0f);
	V3 v1(2.0f, 4.0f, 6.0f);
	V3 v;
	v = v0 + v1;
	return;


	fb->SetChecker(32, 0xFF000000, 0xFFFFFFFF);
	fb->redraw();
	return;


	fb->Set(0xFF00FF00);
	fb->redraw();
	return;

	for (int i = 0; i < fb->w*fb->h; i++) {
		fb->pix[i] = 0xFF0000FF;
	}
	
	fb->redraw();

	cerr << endl;
	cerr << "INFO: pressed DBG button on GUI" << endl;

}

void Scene::NewButton() {
	cerr << "INFO: pressed New button on GUI" << endl;
}



void Scene::RenderHW() {

	// clear HW color and depth buffer
	glClearColor(0.0f, 0.0f, 0.5f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	// set the view
	ppc->SetHWInstrinsics();
	ppc->SetHWExtrinsics();


	// iterate over all triangle meshes
	//			draw current triangle mesh
	for (int tmi = 0; tmi < tmsN; tmi++) {
		//shaders
		int useShaders = (tmi == 0);
		if (useShaders) {
			cgi->EnableProfiles();
			soi->PerFrameInit();
			soi->BindPrograms();
		}
		tms[tmi].RenderHW();
		if (useShaders) {
			cgi->DisableProfiles();
			soi->PerFrameDisable();
		}
	}
}

void Scene::InitHWRendering() {

	cerr << "InitHWRendering" << endl;
	glEnable(GL_DEPTH_TEST);

	// add texture creation
	// create HW texture handle
	// load image into FB
	// transfer image from FB into HW texture

	// shaders
	cgi = new CGInterface();
	cgi->PerSessionInit();
	soi = new ShaderOneInterface();
	soi->PerSessionInit(cgi);

}


void Scene::RayTrace() {

	fb->redraw();

	for (int v = 0; v < fb->h; v++) {
		cerr << "INFO: " << (float)v / (float)fb->h << "           \r";
		for (int u = 0; u < fb->w; u++)
			fb->Set(u, v, 0xFF0000FF);
		fb->redraw();
		Fl::check();

		for (int u = 0; u < fb->w; u++) {
			V3 O = ppc->C;
			V3 ray = ppc->GetRay(u, v);
			float t;
			V3 dcolor, color;
			V3 rO, rray;
			if (IntersectWithRay(O, ray, dcolor, t, rO, rray)) {
				float eps = 0.001f;
				rO = rO + rray.Normalized()*eps;
				V3 rcolor;
				V3 rrO, rrray;
				if (IntersectWithRay(rO, rray, rcolor, t, rrO, rrray)) {
					color = (dcolor + rcolor)*0.5f;
				}
				else
					color = dcolor;
				fb->Set(u, v, color.GetColor());
			}
			else
				fb->Set(u, v, 0xFF808080);
		}
	}

}

int Scene::IntersectWithRay(V3 O, V3 ray, V3& color, float &t, V3 &rO, V3 &rray) {

	t = FLT_MAX;
	for (int tmi = 0; tmi < tmsN; tmi++) {
		if (!tms[tmi].on)
			continue;
		V3 ccolor, crO, crray;
		float ct;
		if (!tms[tmi].IntersectWithRay(O, ray, ccolor, ct, crO, crray))
			continue;
		if (ct > t)
			continue;
		t = ct;
		color = ccolor;
		rO = crO;
		rray = crray;
	}
	if (t == FLT_MAX)
		return 0;
	return 1;
}