#pragma once
#include "v3.h"
#include "M33.h"
#include "framebuffer.h"
#include "ppc.h"

class TM {
public:
	int on;
	V3 *verts, *projverts, *tcs;
	int vertsN;
	V3 *colors; // vertex colors in V3 format
				// (one float in [0.0f, 1.0f] per R, G, and B channel)
	V3 *normals; // per vertex normals
	unsigned int *tris; // triples of vertex indices
	int trisN;
	FrameBuffer *tex;
	TM() : verts(0), vertsN(0), colors(0), tris(0), trisN(0), normals(0),
		projverts(0), tcs(0), tex(0), on(1) {};
	void SetQuad(V3 *vs);
	void LoadBin(char *fname); // load from file
	void DrawPoints(unsigned int color, int psize, PPC *ppc,
		FrameBuffer *fb);
	void DrawWireFrame(unsigned int color, PPC *ppc, FrameBuffer *fb);
	void RotateAboutArbitraryAxis(V3 aO, V3 ad, float theta);
	V3 GetCenter(); // return the average of all vertices
	void Position(V3 newCenter);
	void Translate(V3 tv);
	void VisualizeNormals(float nl, PPC *ppc, FrameBuffer *fb);
	void LightD(V3 ld, float ka);
	void LightP(V3 L, float ka);
	void RenderFilled(PPC *ppc, FrameBuffer *fb);
	void SetEEQs(M33 pvs, M33 &eeqs);
	void RenderHW();
	AABB GetAABB();
	int IntersectWithRay(V3 O, V3 ray, V3 &color, float &t, V3 &rO, V3 &rray);

};