#include "ppc.h"
#include "M33.h"
#include "framebuffer.h"

PPC::PPC(float hfov, int _w, int _h) {

	w = _w;
	h = _h;
	C = V3(0.0f, 0.0f, 0.0f);
	a = V3(1.0f, 0.0f, 0.0f);
	b = V3(0.0f, -1.0f, 0.0f);
	float hfovr = hfov *3.1415926f / 180.0f;
	c = V3(-(float)w / 2.0f, (float)h / 2.0f, 
		-(float)w / (2.0f*tan(hfovr / 2.0f)));

}


int PPC::Project(V3 P, V3& PP) {

	int ret = 1;

	M33 M; 
	M.SetColumn(0, a);
	M.SetColumn(1, b);
	M.SetColumn(2, c);

	V3 q = M.Inverted()*(P - C);

	if (q[2] <= 0.0f)
		return 0;

	PP[0] = q[0] / q[2];
	PP[1] = q[1] / q[2];
	PP[2] = 1.0f / q[2];

	return ret;

}


void PPC::Translate(V3 tv) {

	C = C + tv;

}

V3 PPC::GetVD() {

	V3 ret = (a^b).Normalized();

	return ret;

}

// visualize (draw) "this" camera (on which you are calling visualize)
//    as seen by visPPC
//	  into fb
//    IMPORTANT: draw the camera to scale such that the focal length be visF


void PPC::Visualize(PPC *visPPC, FrameBuffer *fb, float visF) {


	float f = GetF();
	float scf = visF / f;

	// draw image frame as a 3D rectangle projected with visPPC onto fb
	// (4 segments)
	V3 topLeft = C + c*scf;
	V3 topRight = topLeft + (a*(float)w)*scf;
	V3 bottomRight = topRight + (b*(float)h)*scf;
	V3 bottomLeft = bottomRight - (a*(float)w)*scf;
	// render 4 3D segments between these 4 corners BUT SCALED DOWN
	fb->Draw3DSegment(0xFF000000, visPPC, topLeft, topRight);
	fb->Draw3DSegment(0xFF000000, visPPC, topRight, bottomRight);
	fb->Draw3DSegment(0xFF000000, visPPC, bottomRight, bottomLeft);
	fb->Draw3DSegment(0xFF000000, visPPC, bottomLeft, topLeft);

	// draw little c vector, i.e., a segment that starts at C and ends at C+c
	//			top left corner of the camera image frame
	fb->Draw3DSegment(0xFF000000, visPPC, C, topLeft);
	fb->DrawPoint3D(C, visPPC, 5, 0xFF0000FF);

}

float PPC::GetF() {

	V3 vd = GetVD();
	float ret = vd*c;
	return ret;

}



void PPC::Pan(float theta) {

	V3 ad = (b*-1.0f).Normalized();
	a = a.RotateThisVectorAboutArbitraryAxis(ad, theta);
	c = c.RotateThisVectorAboutArbitraryAxis(ad, theta);

}



void PPC::Pose(V3 newC, V3 LAP, V3 upv) {


	V3 newa, newb, newc;

	V3 newvd = (LAP - newC).Normalized();
	newa = (newvd ^ upv).Normalized();
	newb = (newvd ^ newa).Normalized();
	float f = GetF();

	newc = newvd * f - newa * ((float)w / 2.0f) - newb * ((float)h / 2.0f);

	a = newa;
	b = newb;
	c = newc;
	C = newC;

}


V3 PPC::Unproject(int u, int v, float _1w) {

	V3 ret = C + (a * (.5f + (float)u) + b * (.5f + (float)v) + c)*(1.0f / _1w);
	return ret;

}
