#include "v3.h"
#include "m33.h"


V3::V3(float x, float y, float z) {

	xyz[0] = x;
	xyz[1] = y;
	xyz[2] = z;

}

V3 V3::operator+(V3 v1) {

	V3 ret;
	V3 &v0 = (*this);
	for (int i = 0; i < 3; i++) {
		ret[i] = v0[i] + v1[i];
	}

	return ret;

}

V3 V3::operator-(V3 v1) {

	V3 ret;
	V3 &v0 = (*this);
	for (int i = 0; i < 3; i++) {
		ret[i] = v0[i] - v1[i];
	}

	return ret;

}

ostream& operator<<(ostream &ostr, V3 v) {

	return ostr << v[0] << " " << v[1] << " " << v[2];

}



float& V3::operator[](int i) {

	return xyz[i];

}

float V3::operator*(V3 v1) {

	V3 &v0 = *this;

	float ret = v0[0] * v1[0] + v0[1] * v1[1] + v0[2] * v1[2];

	return ret;


}

float V3::Length() {

	V3 &v0 = *this;
	float ret = sqrtf(v0*v0);
	return ret;

}

V3 V3::operator/(float scf) {

	V3 ret;
	V3 &v = *this;
	ret[0] = v[0] / scf;
	ret[1] = v[1] / scf;
	ret[2] = v[2] / scf;
	return ret;

}

V3 V3::operator*(float scf) {

	V3 ret;
	V3 &v = *this;
	ret[0] = v[0] * scf;
	ret[1] = v[1] * scf;
	ret[2] = v[2] * scf;
	return ret;

}


V3 V3::Normalized() {

	V3 &v = *this;
	return v / v.Length();

}

V3 V3::operator^(V3 v2) {

	V3 &v1 = *this;
	V3 ret(v1[1] * v2[2] - v1[2] * v2[1],
		v1[2] * v2[0] - v1[0] * v2[2],
		v1[0] * v2[1] - v1[1] * v2[0]);
	return ret;
}

V3 V3::RotateThisVectorAboutArbitraryAxis(V3 ad, float theta) {

  RotateThisPointAboutArbitraryAxis(V3(0.0f, 0.0f, 0.0f), ad, theta);

}

V3 V3::RotateThisPointAboutArbitraryAxis(V3 Oa, V3 ad, float theta) {


	// 1. Buuild lcs
	V3 lcsO = Oa;
	M33 lcs;
	lcs[1] = ad; // placing arbitrary axis ad as second or "y" axis 
						// of the local coordinate system lcs
	V3 aux; // auxiliary axis used to build lcs
	if (fabsf(ad[0]) < fabsf(ad[1])) {
		// arbitrary axis is less like x than like y
		aux = V3(1.0f, 0.0f, 0.0f); // use x axis since less like ad
	}
	else {
		aux = V3(0.0f, 1.0f, 0.0f); // use y since moore dissimilar to ad than x
	}
	lcs[0] = (aux ^ ad).Normalized(); // now lcs has both its x and y set
	lcs[2] = lcs[0] ^ lcs[1]; // z is always x cross y (for a right handed coordinate system)

	// 2. Transform point to lcs
	V3 &P = *this;
	V3 P1 = lcs*(P - Oa);

	// 3. Rotate P1 in lcs about y, that's where we put the arbitrary axis
	M33 R; R.SetRotationAboutY(theta);
	V3 P2 = R*P1;

	// 4. Go back to world CS
	V3 ret = lcs.Inverted()*P2 + Oa;

	return ret;

}


unsigned int V3::GetColor() {

	// x is in [0 1] (red)
	// y is in [0 1] (green)
	// z is in [0 1] (blue)

	V3 &v = *this;
	unsigned char rgb[3];
	for (int ci = 0; ci < 3; ci++) {
		float tmp = v[ci];
		tmp = (tmp < 0.0f) ? 0.0f : tmp;
		tmp = (tmp > 1.0f) ? 1.0f : tmp;
		rgb[ci] = (unsigned char) (tmp * 255.0f + 0.5f);
	}

	unsigned int ret = 0xFF000000 + rgb[2] * 256 * 256 + 
		rgb[1] * 256 + rgb[0];
	return ret;

}

void V3::SetColor(unsigned int color) {

	V3 &v = *this;
	v[0] = (float)((unsigned char*)&color)[0] / 255.0f;
	v[1] = (float)((unsigned char*)&color)[1] / 255.0f;
	v[2] = (float)((unsigned char*)&color)[2] / 255.0f;

}

