#pragma once

#include <FL/Fl.H>
#include <FL/Fl_Gl_Window.H>
#include <GL/glut.h>

#include "v3.h"
#include "ppc.h"

class FrameBuffer : public Fl_Gl_Window {
public:
	unsigned int *pix;
	int w, h;
	FrameBuffer(int u0, int v0, int _w, int _h);
	void draw();
	int handle(int guievent);
	void LoadTiff(char* fname);
	void SaveAsTiff(char* fname);
	void KeyboardHandle();

	void Set(unsigned int color);
	void SetSafe(int u, int v, unsigned int color);
	void Set(int u, int v, unsigned int color);
	unsigned int Get(int u, int v);
	void SetChecker(int cw, unsigned int col0, unsigned int col1);
	void DrawPoint2D(V3 p, int psize, unsigned int color);
	void DrawPoint3D(V3 p, PPC *ppc, int psize, unsigned int color);
	void Draw3DSegment(unsigned int color, PPC *ppc, V3 V0, V3 V1);
	void Draw2DSegment(unsigned int color, V3 pV0, V3 pV1);
	void Draw3DSegment(V3 C0, V3 C1, PPC *ppc, V3 V0, V3 V1);
	void Draw2DSegment(V3 C0, V3 C1, V3 pV0, V3 pV1);
};