#include "v3.h"
#include "m33.h"


V3::V3(float x, float y, float z) {

	xyz[0] = x;
	xyz[1] = y;
	xyz[2] = z;

}

V3 V3::operator+(V3 v1) {

	V3 ret;
	V3 &v0 = (*this);
	for (int i = 0; i < 3; i++) {
		ret[i] = v0[i] + v1[i];
	}

	return ret;

}

V3 V3::operator-(V3 v1) {

	V3 ret;
	V3 &v0 = (*this);
	for (int i = 0; i < 3; i++) {
		ret[i] = v0[i] - v1[i];
	}

	return ret;

}

ostream& operator<<(ostream &ostr, V3 v) {

	return ostr << v[0] << " " << v[1] << " " << v[2];

}



float& V3::operator[](int i) {

	return xyz[i];

}

float V3::operator*(V3 v1) {

	V3 &v0 = *this;

	float ret = v0[0] * v1[0] + v0[1] * v1[1] + v0[2] * v1[2];

	return ret;


}

float V3::Length() {

	V3 &v0 = *this;
	float ret = sqrtf(v0*v0);
	return ret;

}

V3 V3::operator/(float scf) {

	V3 ret;
	V3 &v = *this;
	ret[0] = v[0] / scf;
	ret[1] = v[1] / scf;
	ret[2] = v[2] / scf;
	return ret;

}

V3 V3::operator*(float scf) {

	V3 ret;
	V3 &v = *this;
	ret[0] = v[0] * scf;
	ret[1] = v[1] * scf;
	ret[2] = v[2] * scf;
	return ret;

}


V3 V3::Normalized() {

	V3 &v = *this;
	return v / v.Length();

}

V3 V3::operator^(V3 v2) {

	V3 &v1 = *this;
	V3 ret(v1[1] * v2[2] - v1[2] * v2[1],
		v1[2] * v2[0] - v1[0] * v2[2],
		v1[0] * v2[1] - v1[1] * v2[0]);
	return ret;
}


V3 V3::RotateThisPointAboutArbitraryAxis(V3 Oa, V3 ad, float theta) {


	// 1. Buuild lcs
	V3 lcsO = Oa;
	M33 lcs;
	lcs[1] = ad; // placing arbitrary axis ad as second or "y" axis 
						// of the local coordinate system lcs
	V3 aux; // auxiliary axis used to build lcs
	if (fabsf(ad[0]) < fabsf(ad[1])) {
		// arbitrary axis is less like x than like y
		aux = V3(1.0f, 0.0f, 0.0f); // use x axis since less like ad
	}
	else {
		aux = V3(0.0f, 1.0f, 0.0f); // use y since moore dissimilar to ad than x
	}
	lcs[0] = (aux ^ ad).Normalized(); // now lcs has both its x and y set
	lcs[2] = lcs[0] ^ lcs[1]; // z is always x cross y (for a right handed coordinate system)

	// 2. Transform point to lcs
	V3 &P = *this;
	V3 P1 = lcs*(P - Oa);

	// 3. Rotate P1 in lcs about y, that's where we put the arbitrary axis
	M33 R; R.SetRotationAboutY(theta);
	V3 P2 = R*P1;

	// 4. Go back to world CS
	V3 ret = lcs.Inverted()*P2 + Oa;

	return ret;

}
