#include "v2.h"
#include <math.h>


V2::V2(float x, float y) {

  xy[0] = x;
  xy[1] = y;

}

float V2::operator*(V2 op2) {

  float ret;
  ret = xy[0]*op2.xy[0]+xy[1]*op2.xy[1];
  return ret;

}

V2 V2::operator+(V2 op2) {

  V2 ret;
  ret.xy[0] = xy[0] + op2.xy[0];
  ret.xy[1] = xy[1] + op2.xy[1];
  return ret;

}

V2 V2::operator-(V2 op2) {

  V2 ret;
  ret.xy[0] = xy[0] - op2.xy[0];
  ret.xy[1] = xy[1] - op2.xy[1];
  return ret;

}

ostream& operator<<(ostream &ostr, V2 op) {

  ostr << op.xy[0] << " " << op.xy[1] << endl;
  return ostr;

}

float V2::Length() {

  float ret = sqrtf((*this)*(*this));

  return ret;

}

float V2::Angle(V2 op1) {

  float l0 = Length();
  float l1 = op1.Length();
  // op0*op1 = l0*l1*cos(alpha)
  float ret = acosf(((*this)*op1)/(l0*l1));

  ret = ret / V2_PI * 180.0f;

  return ret;

}

V2 V2::operator*(float f) {

  V2 ret;
  ret.xy[0] = xy[0]*f;
  ret.xy[1] = xy[1]*f;
  return ret;

}

float& V2::operator[](int i) {

  float& ret = xy[i];
  return ret;

}
