/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


/*
  Tie-breaking according to original degrees. 
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#define MAXASN  65536
#define MAXEDGE  1000000


typedef struct {
    int x;
    int y;
    int checked;
} EDGE;

char taken[MAXASN]={0};
int  degree[MAXASN], orgdegree[MAXASN];
int  as2id[MAXASN], id2as[MAXASN];
EDGE edge[MAXEDGE];
int  N, N_edge, N_checked;

void read_graph();
int find_maxdegree();
int find_vc2();


main(int argc, char **argv)
{
    int  as, id, i;

    if (argc != 2) {
        fprintf(stderr, "Usage: %s <ASfile> \n", argv[0]);
	exit(-1);
    }
    N = N_edge = N_checked = 0;
    for (i=0; i<MAXASN; i++)
      as2id[i] = id2as[i] = -1;
    read_graph(argv[1]);

    find_vc2();
}




int 	find_vc2() 
{
    int	i, j, k, max_i;
    
    while ((N_checked < N_edge) && ((max_i = find_maxdegree())!= -1)) {
	assert( !taken[max_i] );
	taken[max_i] = 1;
        printf("%5d\n", id2as[max_i]);
	for (i=0; i< N_edge; i++) {
	    if (edge[i].checked == 0) {
		if (edge[i].x == max_i || edge[i].y == max_i) {
		    edge[i].checked = 1;
		    N_checked++;
		    degree[edge[i].x]--;
		}
	    }
	}
    }
}


int	find_maxdegree()
{
    int	i, maxdegree=0, maxorg=0, max_i=-1;
    for (i=0; i<N; i++) {
        if ((degree[i] > maxdegree) ||
            (degree[i]==maxdegree && maxdegree>0 && orgdegree[i]>maxorg)) {
	    max_i = i;
	    maxdegree = degree[i];
	    maxorg = orgdegree[i];
	} 
    }
    return max_i;
}




void	read_graph(char *graphname) 
{
    FILE  *graphfile;
    int	i, j, k, as, id, neighbor, deg;
    char  checked[MAXASN];

    if ((graphfile = fopen(graphname, "r")) == NULL) {
	fprintf(stderr, "graphfile %s is not found\n",graphname);
	exit(1);
    };

    N = 0;
    while (fscanf(graphfile, "%d", &as) > 0 ) {
	int c;
        id2as[id = N++] = as;
	as2id[as] = id;
        /* Skip the rest of the line */
        while( ((c = getc(graphfile)) != '\n') && (c != EOF))  ;
    }

    rewind(graphfile);
    while (fscanf(graphfile, "%d -> %d\t", &as, &deg) == 2) {
        for (j=0; j < 65536; j++)
            checked[j] = 0;
        checked[as] = 1;

        while (fscanf(graphfile, ":%d", &neighbor) == 1) {
            if ( !checked[neighbor] ) {
		checked[neighbor] = 1;
		edge[N_edge].x = as2id[as];
		edge[N_edge].y = as2id[neighbor];
		edge[N_edge].checked = 0;
		N_edge++;
		degree[as2id[as]]++;
	    }
	}
    }
    for (i=0; i<N ; i++)
	orgdegree[i] = degree[i];

}
