/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


#include "types.h"

main(int argc, char **argv)
{
    FILE *infile, *outfile;
    COUNTER  **In, **Out;
    NODE_ID  a, t;
    int N;

    assert(argc == 3);
    assert ((infile = fopen(argv[1], "r")) != NULL);
    assert ((outfile = fopen(argv[2], "w")) != NULL);

    fread(&N, sizeof(int), 1, infile);
    fwrite(&N, sizeof(int), 1, outfile);

    assert((In = (COUNTER**) calloc(N, sizeof(COUNTER*))) != NULL);
    for (t=0; t<N; t++)
        assert((In[t] = (COUNTER*)calloc(N, sizeof(COUNTER))) != NULL);
    assert((Out = (COUNTER**) calloc(N, sizeof(COUNTER*))) != NULL);
    for (a=0; a<N; a++)
        assert((Out[a] = (COUNTER*)calloc(N, sizeof(COUNTER))) != NULL);

    for(t=0; t<N; t++) 
        fread(In[t], sizeof(COUNTER), N, infile);
    for(t=0; t<N; t++) 
	for(a=0; a<N; a++) 
	    Out[a][t] = In[t][a];
    for(a=0; a<N; a++) 
	fwrite(Out[a], sizeof(COUNTER), N, outfile);

    fclose(infile);
    fclose(outfile);

}
