/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


#include "types.h"

float Psi1(int);
FILE  *ctsfile;
int  N;
COUNTER  *C_t;


main(int argc, char **argv)
{
    char  *ctsfilename;
    int x;

    assert(sscanf(argv[1], "%d", &x) == 1);
    assert((ctsfilename = (char*)malloc(strlen(argv[2])+10)) != NULL);
    strcpy(ctsfilename, argv[2]);
    strcat(ctsfilename, ".Cts");
    assert((ctsfile = fopen(ctsfilename, "r")) != NULL);

    fread(&N, sizeof(int), 1, ctsfile);
    assert((C_t = (COUNTER*)calloc(N, sizeof(COUNTER))) != NULL);

    printf("Psi1(%d) = %f\n", x, Psi1(x));
}


float Psi1(int x)
{
    NODE_ID  s, t;
    int count=0;

    fseek(ctsfile, (long)4, SEEK_SET);
    for (t=0; t<N; t++) {
        fread(C_t, sizeof(COUNTER), N, ctsfile);
        for (s=0; s<N; s++) {
            if (C_t[s] > x)
                break;
        }
        if (s == N)
            count++;
    }
    return(count/(float)N);
}

