/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


#include "types.h"

float Phi3(int);
FILE  *satfile;
int  N;
COUNTER  *S_a;


main(int argc, char **argv)
{
    char  *satfilename;
    int x;

    assert(sscanf(argv[1], "%d", &x) == 1);
    assert((satfilename = (char*)malloc(strlen(argv[2])+10)) != NULL);
    strcpy(satfilename, argv[2]);
    strcat(satfilename, ".Sat");
    assert((satfile = fopen(satfilename, "r")) != NULL);

    fread(&N, sizeof(int), 1, satfile);
    assert((S_a = (COUNTER*)calloc(N, sizeof(COUNTER))) != NULL);

    printf("Phi3(%d) = %f\n", x, Phi3(x));
}


float Phi3(int x)
{
    NODE_ID  a, t;
    int count=0;

    fseek(satfile, (long)4, SEEK_SET);
    for (a=0; a<N; a++) {
        fread(S_a, sizeof(COUNTER), N, satfile);
        for (t=0; t<N; t++) 
            if ((a != t) && (S_a[t] <= x))
                count++;
    }
    return(count/(float)(N*(N-1)));
}


