/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


#include "types.h"

float Phi1(int);
FILE  *stafile;
int  N;
COUNTER  *S_t;


main(int argc, char **argv)
{
    char  *stafilename;
    int x;

    assert(sscanf(argv[1], "%d", &x) == 1);
    assert((stafilename = (char*)malloc(strlen(argv[2])+10)) != NULL);
    strcpy(stafilename, argv[2]);
    strcat(stafilename, ".Sta");
    assert((stafile = fopen(stafilename, "r")) != NULL);

    fread(&N, sizeof(int), 1, stafile);
    assert((S_t = (COUNTER*)calloc(N, sizeof(COUNTER))) != NULL);

    printf("Phi1(%d) = %f\n", x, Phi1(x));
}


float Phi1(int x)
{
    NODE_ID  a, t;
    int count=0;

    fseek(stafile, (long)4, SEEK_SET);
    for (t=0; t<N; t++) {
        fread(S_t, sizeof(COUNTER), N, stafile);
        for (a=0; a<N; a++) {
            if (S_t[a] > x)
                break;
        }
        if (a == N)
            count++;
    }
    return(count/(float)N);
}

