#!/usr/bin/perl
# 
# 
# Copyright (C) Purdue University 2002
# 
# This program, which is part of the DPF software tool kit for
# static distributed denial-of-service (DDoS) performance evaluation
# developed at the Network Systems Lab, Purdue University, may be
# redistributed and/or modified under the terms of the GNU General
# Public License published by the Free Software Foundation.
# 
# 
# Technical Contact at Purdue University:
# 
# Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)
# 
# For future version updates and related information, check the website
# http://www.cs.purdue.edu/nsl
#


$ID=$ARGV[0];
$infilename="ASpaths.$ID";
$outfilename="AStrans.$ID";
open(infile,"$infilename") || die("Cannot open input file $infilename");
open(outfile,">$outfilename") || die("Cannot open output file $outfilename");

while($line=<infile>)
{
    # Process the AS path:
    @r = reverse(split(' ', $line));
    $last_as = -1;
    $n_list = 0;
    while ($as = pop(@r)) {
	if ($as =~ /\D/) { last;}  
	# Check for duplicate entries:
	if ($last_as != $as) {
	    $as_list[ $n_list++ ] = $last_as = $as;	   
	}
    }

    # Now process the duplicate-free AS path:
    for ($i = 1; $i < ($n_list - 1); $i++) {
	$Transit{$as_list[$i]} = 1;
    }

    # If the AS path includes an AS_SET, 
    # take the last entry of AS_SEQ as well:
    if ($line =~ "{") {
	$Transit{$as_list[$n_list - 1]} = 1;
    }

}

foreach $key (keys %Transit) {
    printf outfile "%5d\n", $key;
}

close(infile);
close(outfile);
