#!/usr/bin/perl
# 
# 
# Copyright (C) Purdue University 2002
# 
# This program, which is part of the DPF software tool kit for
# static distributed denial-of-service (DDoS) performance evaluation
# developed at the Network Systems Lab, Purdue University, may be
# redistributed and/or modified under the terms of the GNU General
# Public License published by the Free Software Foundation.
# 
# 
# Technical Contact at Purdue University:
# 
# Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)
# 
# For future version updates and related information, check the website
# http://www.cs.purdue.edu/nsl
#


$ID = $ARGV[0];
$infilename = "ASpaths.$ID";
$outfilename = "ASgraph.$ID";
open(infile,"$infilename") || die("Cannot open input file $infilename");
open(outfile,">$outfilename") || die("Cannot open output file $outfilename");


while($line = <infile>) {

    if ($line =~ "{") {
	$line =~ /(.*)\{(.*)\}/;
	$AS_SEQ = $1;
	$AS_SET = $2;
    }
    else {
	$AS_SEQ = $line;
	$AS_SET = 0;
    }

    # Process the AS_SEQ:
    $lastas = 0;
    @r = reverse(split(' ', $AS_SEQ));
    while($x = pop(@r)) {
	# while !($x > 0)
	if (!($x > 0)) {
	    next;
	}
	if (($lastas == 0) || ($lastas == $x) || $AdjMatrix{$lastas, $x}) {
	    $lastas = $x;
	    next;
	}
	$AdjMatrix{$lastas, $x}++;
	$AdjMatrix{$x, $lastas}++;
	$AdjList{$lastas} = join(':', $AdjList{$lastas}, $x);
	$AdjList{$x} = join(':', $AdjList{$x}, $lastas);
	$Degree{$lastas}++;
	$Degree{$x}++;
	$lastas = $x;
    }

    if (!($AS_SET)) {
	next;
    }
    # Process the AS_SET:
    @r = split(',', $AS_SET);   # 'reverse' not needed in AS_SET
    while($x = pop(@r)) {
	if (($lastas == 0) || ($lastas == $x) || $AdjMatrix{$lastas, $x}) {
	    next;
	}
	$AdjMatrix{$lastas, $x}++;
	$AdjMatrix{$x, $lastas}++;
	$AdjList{$lastas} = join(':', $AdjList{$lastas}, $x);
	$AdjList{$x} = join(':', $AdjList{$x}, $lastas);
	$Degree{$lastas}++;
	$Degree{$x}++;
    }
}


foreach $key ( sort numerically ( keys %AdjList)) {
    printf outfile "%d\t->\t%d\t%s\n", $key, $Degree{$key}, $AdjList{$key};
}


sub numerically  {         $a  <=>         $b ;}

