#! /usr/bin/csh -f
# 
# 
# Copyright (C) Purdue University 2002
# 
# This program, which is part of the DPF software tool kit for
# static distributed denial-of-service (DDoS) performance evaluation
# developed at the Network Systems Lab, Purdue University, may be
# redistributed and/or modified under the terms of the GNU General
# Public License published by the Free Software Foundation.
# 
# 
# Technical Contact at Purdue University:
# 
# Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)
# 
# For future version updates and related information, check the website
# http://www.cs.purdue.edu/nsl
#


set ID = 19971108
set echo


# 1. PREPARATION OF THE INPUT

# Extracting the AS paths:
gzip -d ASmap.$ID.gz
../get_ASpaths.pl $ID
gzip -f ASmap.$ID

# Deducing the graph topology from AS paths:
../get_ASgraph.pl $ID

# Identifying the transit nodes:
../get_AStrans.pl $ID
gzip -f ASpaths.$ID

# Computing vertex cover as filter placement 
../vc/vc.trans ASgraph.$ID AStrans.$ID > ASfilter.$ID


# 2. RUNNING THE SIMULATOR:

../dpf/dpf ASgraph.$ID ASfilter.$ID AStrans.$ID 0 1 0 0


# 3. OUTPUT ANALYSIS:

../measure/psi1 3 ASgraph.$ID  > psi1.out
../measure/transpose ASgraph.$ID.Sta ASgraph.$ID.Sat
../measure/phi2 1 ASgraph.$ID  > phi2.out
gzip -f ASgraph.$ID.{Cts,Sta,Sat}

unset echo