/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


/*
 *   types.h --- Includes the type and constant definitions
 */

#ifndef __TYPES_H__
#define __TYPES_H__


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <sys/types.h>


/* Parameter definitions */

#define sizeF (8 * sizeof(FILTER_CELL))
#define numF ((N%sizeF)?((N/sizeF)+1):(N/sizeF))


/* Constant definitions */

#define fNIL ((FTR_ID)(-1))
#define nNIL ((NODE_ID)(-1))
#define eNIL ((EDGE_ID)(-1))
#define dNIL ((DIST)(-1))

#define MAXHOP 	250		/* maximum hops on a path */
#define MAXN	65536		/* maximum AS number allowed */


/* Type definitions */

typedef unsigned int   FTR_ID;
typedef unsigned short NODE_ID;
typedef unsigned short NODE_CNT;
typedef unsigned short EDGE_ID;
typedef enum {STUB, TRANSIT} NODE_TYPE;
typedef struct {
    NODE_ID  to;
    FTR_ID   ftr; }    EDGE;
typedef unsigned short COUNTER;
typedef unsigned char  DIST;
typedef long long      FILTER_CELL;
typedef FILTER_CELL*   BITARRAY;
typedef struct {
    NODE_CNT n;
    NODE_ID *list; }   NODELIST;
typedef struct {
    unsigned char  n;
    NODE_ID *list; }   shNODELIST;
typedef struct {
    unsigned char  n;
    EDGE_ID *list; }   shEDGELIST;
typedef  EDGE_ID     RTABLE_ENTRY;

typedef struct {
    EDGE          *edge;
    RTABLE_ENTRY  *rtable;
} NODE;


#endif
