/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


/*
 *                 preroute.c
 */

#include "types.h"
#include "extern.h"
#include "functions.h"



void  UploadRoutes()
/* Upload the pre-computed routes */
{
    char *rtfilename;
    FILE *rtfile;
    NODE_ID  src, dest, hop, src_as, dest_as, hop_as;

    /* Open the pre-route input file */
    assert(( rtfilename = malloc(strlen(graphfilename)+5)) != NULL);
    strcpy(rtfilename, graphfilename);
    strcat(rtfilename, ".rt");
    assert ((rtfile = fopen(rtfilename, "r")) != NULL); 

    /* Read the pre-route input file and fill the data structure */
    while( (fread(&src_as,  sizeof(NODE_ID), 1, rtfile) == 1) && 
	   (fread(&dest_as, sizeof(NODE_ID), 1, rtfile) == 1) && 
	   (fread(&hop_as,  sizeof(NODE_ID), 1, rtfile) == 1) ) {
	src = as2id[src_as]; dest = as2id[dest_as]; hop = as2id[hop_as];

	/* Check for error conditions */
	if (src == nNIL) {
	    fprintf(stderr, "ERROR: Source does not exist\n");
	    fprintf(stderr, "Src = %d, Dest = %d, Hop = %d.\n", 
		    src_as, dest_as, hop_as);
	    exit(-1);
	}
	if (dest == nNIL) {
	    fprintf(stderr, "ERROR: Destination does not exist\n");
	    fprintf(stderr, "Src = %d, Dest = %d, Hop = %d.\n", 
		    src_as, dest_as, hop_as);
	    exit(-1);
	}
	if (dest == src)
	    continue;
	if (hop == nNIL) {
	    fprintf(stderr, "ERROR: Hop does not exist\n");
	    fprintf(stderr, "Src = %d, Dest = %d, Hop = %d.\n", 
		    src_as, dest_as, hop_as);
	    exit(-1);
	}
	if (hop == src) {
	    fprintf(stderr, "ERROR: Hop = Source is not allowed\n");
	    fprintf(stderr, "Src = %d, Dest = %d, Hop = %d.\n", 
		    src_as, dest_as, hop_as);
	    exit(-1);
	}

	if ((InitialRouteTable[src][dest] != nNIL) && 
	    (InitialRouteTable[src][dest] != hop)) {
	    fprintf(stderr, "ERROR: Different routing entries are given for one source-destination pair. Not allowed with single-path routing.\n");
	    fprintf(stderr, "Src = %d, Dest = %d, Hop1 = %d, Hop2 = %d.\n", 
		    src_as, dest_as, hop_as, 
		    id2as[InitialRouteTable[src][dest]]);
	    exit(-1);
	}

	InitialRouteTable[src][dest] = hop;
    }
    fclose(rtfile);
}



void  DownloadRoutes()
/* This function can be used to save the routes in the format 
   used by the UploadRoutes function */
{
    char *rtfilename;
    FILE *rtfile;
    NODE_ID  src, dest, hop;

    /* Open the route dump file */
    assert(( rtfilename = malloc(strlen(graphfilename)+5)) != NULL);
    strcpy(rtfilename, graphfilename);
    strcat(rtfilename, ".rt");
    assert ((rtfile = fopen(rtfilename, "w")) != NULL); 

    for (src=0; src<N; src++) {
        for (dest=0; dest<N; dest++) {
	    hop = InitialRouteTable[src][dest];
	    if (hop != nNIL) {
		fwrite(&(id2as[src]),  sizeof(NODE_ID), 1, rtfile);
		fwrite(&(id2as[dest]), sizeof(NODE_ID), 1, rtfile);
		fwrite(&(id2as[hop]),  sizeof(NODE_ID), 1, rtfile);
	    }
	}
    }
    fclose(rtfile);
}

