/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


#include "types.h"
#include "extern.h"
#include "functions.h"

FILE  *stafile, *ctsfile;


void  OpenOutputFiles()
/* Open the files to save the results. */
{
    char *stafilename, *ctsfilename;
    int n = N;

    assert(( stafilename = malloc(strlen(graphfilename)+10)) != NULL);
    assert(( ctsfilename = malloc(strlen(graphfilename)+10)) != NULL);
    strcpy(stafilename, graphfilename);
    strcpy(ctsfilename, graphfilename);
    strcat(stafilename, ".Sta");
    strcat(ctsfilename, ".Cts");
    assert ((stafile = fopen(stafilename, "w")) != NULL); 
    assert ((ctsfile = fopen(ctsfilename, "w")) != NULL); 

    if(!SETS) {
	fwrite(&n, sizeof(int), 1, stafile);
	fwrite(&n, sizeof(int), 1, ctsfile);
    }
}


void SaveResults(NODE_ID t /* target destination */) 
/* Save the results for this given target */
{
    if(!SETS)
	SaveStats(t);
    else
	SaveSets(t);
}	


void SaveStats(NODE_ID t /* target destination */) 
/* Save the cardinalities of the S_at and C_st sets */
{
    NODE_ID  a;
    COUNTER *S, *C;
    int i;

    assert( (S = calloc(N, sizeof(COUNTER))) != NULL);
    assert( (C = calloc(N, sizeof(COUNTER))) != NULL);
    for(a=0; a<N; a++) 
	C[a] = 0;

    /* Calculate the cardinalities of the S_ta and C_ts sets for current t */
    for(a=0; a<N; a++) {
	S[a] = Sta2[a].n;
	for(i=0; i < Sta2[a].n; i++) 
	    C[ Sta2[a].list[i] ]++; 
    }

    /* Save the S and C tables */
    fwrite(S, sizeof(COUNTER), N, stafile);
    fwrite(C, sizeof(COUNTER), N, ctsfile);
    
    free(S);
    free(C);

}


void SaveSets(NODE_ID t /* target destination */) 
/* Save the S_at and C_st sets explicitly */ 
{
    NODE_ID  a, s;
    int i, n;


    for(s = 0; s < N; s++) 
	Cts2[s].n = 0;

    /* Get the C_ts set for current t */
    for(a=0; a<N; a++) {
	for(i=0; i < Sta2[a].n; i++) {
	    s = Sta2[a].list[i];
	    n = ++Cts2[s].n;
	    assert((Cts2[s].list = realloc(
		Cts2[s].list, n * sizeof(NODE_ID))) != NULL);
	    Cts2[s].list[n-1] = a;
	}
    }

    /* Save the S_ta and C_ts sets */
    for(a=0; a<N; a++) {
	fprintf(stafile, "%d,%d", id2as[a], id2as[t]);
	for(i=0; i < Sta2[a].n; i++) 
	    fprintf(stafile, ":%d", id2as[Sta2[a].list[i]]);
	fprintf(stafile, "\n");
    }

    for(s=0; s<N; s++) {
	fprintf(ctsfile, "%d,%d", id2as[s], id2as[t]);
	for(i=0; i < Cts2[s].n; i++) 
	    fprintf(ctsfile, ":%d", id2as[Cts2[s].list[i]]);
	fprintf(ctsfile, "\n");
    }

}
