/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


#include "types.h"
#include "extern.h"
#include "functions.h"

NODE	*node;
int     N;
FTR_ID  N_ftr=0;
BITARRAY  *Filter1, *Sta1;
NODELIST  *Filter2, *Sta2, *Cts2;
int     MAX, EGRESS, SETS, ROUTE;
NODE_ID  **InitialRouteTable;
NODE_ID  as2id[65536], id2as[65536];
EDGE_ID	 Degree[65536]={0};
char	 Transit[65536]={0}, Filter[65536]={0};
char    *graphfilename, *coverfilename, *transfilename;

main(int argc, char **argv)
{
    NODE_ID  s, d;
    time_t time0, time1, time2, time3, time4;

    time(&time0);
    if (argc != 8) {
	fprintf(stderr, "Usage: %s <graphfile> <coverfile> <transfile> <MAX (0|1)> <EGRESS (0|1)> <ROUTE (0|1|2)> <SETS (0|1)>\n", argv[0]);
	exit(-1);
    }
    graphfilename = argv[1];
    coverfilename = argv[2];
    transfilename = argv[3];
    assert(sscanf(argv[4], "%d", &MAX) == 1);
    assert(sscanf(argv[5], "%d", &EGRESS) == 1);
    assert(sscanf(argv[6], "%d", &ROUTE) == 1);
    assert(sscanf(argv[7], "%d", &SETS) == 1);

    fprintf(stdout, "Reading the input graph...\n");
    GetInputGraph();
    OpenOutputFiles();
    time(&time1);
    fprintf(stdout, "Initialization: %d sec.\n", time1-time0);

    fprintf(stdout, "Computing the routes...\n");
    ComputeRoutes();
    time(&time2);
    fprintf(stdout, "Route construction: %d sec.\n", time2-time1);

    if (MAX) {
	fprintf(stdout,"Computing the filter tables & reachability sets...\n");
	AllocFilters();
	AllocSets();
	for (d=0; d<N; d++) {
	    UnsetFilters();
	    for (s=0; s<N; s++) 
		TraverseRoute_SetFilters(s, d, s, fNIL);
	    ComputeSets(d);
	    SaveResults(d); 
	}
        time(&time4);
        fprintf(stdout, "Filter & set computation: %d sec.\n", time4-time2);
    }
    else {
	fprintf(stdout, "Computing the filter tables...\n");
	AllocFilters();
	UnsetFilters();
	for (s=0; s<N; s++) {
	    for (d=0; d<N; d++)
		TraverseRoute_SetFilters(s, d, s, fNIL);
	}
	FreeFilters1();
        time(&time3);
        fprintf(stdout, "Filter construction: %d sec.\n", time3-time2);
	fprintf(stdout, "Computing the reachability sets...\n");
	AllocSets();
	for (d=0; d<N; d++) {
	    ComputeSets(d);
	    SaveResults(d); 
	}
	FreeSets();
        time(&time4);
        fprintf(stdout, "Set computation: %d sec.\n", time4-time3);
    }

    fprintf(stdout, "Total: %d sec.\n", time4-time0);
    fprintf(stdout, "Simulation complete.\n\n");

}
