/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


/*
 *                 init.c
 */

#include "types.h"
#include "extern.h"
#include "functions.h"


void  GetInputGraph()
/* Read the input graph; create the nodes and the edges */
{
    FILE   *graphfile, *coverfile, *transfile;
    int  i, j, as, id, neighbor, degree, deg, c;
    char  checked[65536];

    /* Get the list of AS nodes */
    for (i=0; i<65536; i++)
	as2id[i] = id2as[i] = nNIL;
    N = 0;
    assert((graphfile = fopen(graphfilename, "r")) != NULL);
    while ( fscanf(graphfile, " %d", &as) == 1 ) {
	id2as[N++] = as;
	/* Skip the rest of the line */
	while( ((c = getc(graphfile)) != '\n') && (c != EOF))   ;
    }

    /* Node creation */
    assert((node = calloc(N, sizeof(NODE))) != NULL);
    for (i=0; i<N; i++){
	as2id[id2as[i]] = i;
	assert((node[i].rtable = calloc(N, sizeof(RTABLE_ENTRY))) != NULL);
    }


    /* Set filter nodes */
    assert((coverfile = fopen(coverfilename, "r")) != NULL);
    while (fscanf(coverfile, " %d \n", &as) == 1) 
        Filter[as2id[as]] = 1;
    fclose(coverfile);


    /* Get the edges; set links to filters */
    rewind(graphfile);    
    for (i=0; i<N; i++){
	assert( fscanf(graphfile, "%d -> %d\t", &as, &degree) == 2);
	id = as2id[as];
	assert((node[id].edge = calloc(degree, sizeof(EDGE))) 
	       != NULL);
        for (j=0; j < 65536; j++)   /* To eliminate duplicate entries */ 
            checked[j] = 0;
        checked[as] = 1;
	deg = 0;

	while (fscanf(graphfile, ":%d", &neighbor) == 1) {
	    if ( !checked[neighbor] ) {
		node[id].edge[deg].to = as2id[neighbor];
		if ( Filter[as2id[neighbor]] )
		    node[id].edge[deg].ftr = N_ftr++;
		else
		    node[id].edge[deg].ftr = fNIL;
		deg++;
		checked[neighbor] = 1;
	    } 
	}
	Degree[id] = deg;
    }
    fclose(graphfile);

    /* Get the transitness information */
    assert((transfile = fopen(transfilename, "r")) != NULL);
    while (fscanf(transfile, " %d \n", &as) == 1) 
        Transit[ as2id[as] ] = 1;
    fclose(transfile);

}

