/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


/* 
 *   functions.h --- Includes the function prototypes
 */


#ifndef __FUNCTIONS_H__
#define __FUNCTIONS_H__

void  CycleDetect(NODE_ID, NODE_ID, NODE_ID, int);
void  ComputeRoutes();
void  AllocFilters();
void  AllocFilters1();
void  AllocFilters2();
void  FreeFilters1(); 
void  AllocSets(); 
void  FreeSets();
void  AllocTmpRtStrct();
void  FreeTmpRtStrct();
void  UploadRoutes();
void  DownloadRoutes();
void  ReadPR(NODE_ID);
void  Dijkstra(NODE_ID);
void  InitList(NODE_ID);
void  UpdateNode( NODE_ID, DIST, NODE_ID);
void  GetInputGraph();
void  OpenOutputFiles();
void  UnsetFilters(void);
void  UnsetStas(void);
void  TraverseRoute_SetFilters(NODE_ID, NODE_ID, NODE_ID, FTR_ID);
void  ConvertFilters(void);
void  ConvertRouteTables(void);
void  ComputeSta(NODE_ID, NODE_ID, char*);
void  ComputeSets(NODE_ID);
void  SaveResults(NODE_ID);
void  SaveStats(NODE_ID);
void  SaveSets(NODE_ID);


#endif
