/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


/*
 *   extern.h --- Includes definition of external variables
 */

#ifndef __EXTERN_H__
#define __EXTERN_H__


extern 	NODE    *node;          /* Node table */
extern 	int     N;              /* Total number of nodes */
extern  FTR_ID  N_ftr;          /* Total number of filter edges */
extern  BITARRAY  *Filter1, *Sta1;  /* Filters and S_ta sets, in bit array 
				      format. Preferred for direct access 
				      to a specified entry */
extern  NODELIST  *Filter2, *Sta2, *Cts2; /* Filters and S_ta sets, in dynamic table
				      format. Preferred for fast enumeration.*/
extern  NODE_ID  as2id[65536], id2as[65536]; /* Arrays for converting an AS
						number to the corresponding 
						node id of the program 
						and vice versa. */
extern  EDGE_ID	 Degree[65536];    /* Table of node degrees */
extern  char  Transit[65536];   /* Transit[x] is 1 if x is a transit node */
extern  char  Filter[65536];    /* Filter[x] is 1 if x is a filter node */
extern  int   MAX, EGRESS, SETS, ROUTE; 
/* Specify options, such as maximal or egress filtering is in effect */
extern  NODE_ID  **InitialRouteTable;  /* Temporary route table, used during
					  routing */
extern  char    *graphfilename, *coverfilename, *transfilename;


#endif
