/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


/*
 *   edge.h --- Includes the macro definitions for edge operations
 */

#ifndef __EDGE_H__
#define __EDGE_H__

#define GetEdge(x,y,e) { \
    register EDGE *e_macro = node[x].edge; \
    register NODE_ID y_macro = y; \
    register EDGE_ID d_macro = Degree[x]; \
\
    for(e=0; e < d_macro; e++, e_macro++) \
       if ( (*e_macro).to == y_macro ) \
           break; \
\
    if(e == d_macro) { \
        fprintf( stderr, "ERROR: Edge not found from %d to %d.\n", id2as[x], id2as[y]); \
        exit(-1); \
    } \
}

#endif  /* __EDGE_H__ */
