/*

Copyright (C) Purdue University 2002

This program, which is part of the DPF software tool kit for
static distributed denial-of-service (DDoS) performance evaluation
developed at the Network Systems Lab, Purdue University, may be
redistributed and/or modified under the terms of the GNU General
Public License published by the Free Software Foundation.


Technical Contact at Purdue University:

Ali Selcuk (selcuk@cs.purdue.edu) or Kihong Park (park@cs.purdue.edu)

For future version updates and related information, check the website
http://www.cs.purdue.edu/nsl

*/


/*
 *   filter.h --- Includes the macro definitions for filter operations
 */


#ifndef __FILTER_H__
#define __FILTER_H__


/* Filter bit operations: */

#define GetBit(x,i) \
(( (x)[(int)(i)/sizeF] >> ((int)(i)%sizeF) ) & (FILTER_CELL)1 )
#define SetBit(x,i) \
( (x)[(int)(i)/sizeF] |=  ( ((FILTER_CELL)1) << ((int)(i)%sizeF) ) )
#define UnsetBit(x,i) \
( (x)[(int)(i)/sizeF] &= ~( ((FILTER_CELL)1) << ((int)(i)%sizeF) ) )


/* Filter array operations: */

#define UnsetBitArray(x) { \
    register BITARRAY a_macro=(x), c_macro=(x)+numF; \
    for( ; a_macro < c_macro; a_macro++) \
        *a_macro = (FILTER_CELL)0; \
}
#define SetBitArray(x) { \
    register BITARRAY a_macro=(x), c_macro=(x)+numF; \
    for( ; a_macro < c_macro; a_macro++) \
        *a_macro = ~((FILTER_CELL)0); \
}
#define CopyBitArray(x,y) { \
    register BITARRAY a_macro=(x), b_macro=(y), c_macro=(x)+numF; \
    for( ; a_macro < c_macro; a_macro++, b_macro++) \
        *a_macro = *b_macro; \
}
#define MergeBitArray(x,y) { \
    register BITARRAY a_macro=(x), b_macro=(y), c_macro=(x)+numF; \
    for( ; a_macro < c_macro; a_macro++, b_macro++) \
        *a_macro &= *b_macro; \
}


#define TreshUnset (N / 400)
/* This is only for optimization. If a filter has very few 1's in it,
   unseting it will be done faster by turning off these bits individually.
   Otherwise, unsetting the filter as an array is faster.
   "TreshUnset" specifies the treshold for this choice.
*/


#define UnsetSta(i) { \
    register int k_macro; \
\
    if ( Sta2[i].n > TreshUnset ) { \
	UnsetBitArray( Sta1[i] ); \
    } \
    else { \
	for (k_macro=0; k_macro < Sta2[i].n; k_macro++) \
	    UnsetBit(Sta1[i], Sta2[i].list[k_macro]); \
    } \
    Sta2[i].n = 0; \
}

#define UnsetFilter(i) { \
    register int k_macro; \
\
    if ( Filter2[i].n > TreshUnset ) { \
	UnsetBitArray( Filter1[i] ); \
    } \
    else { \
	for (k_macro=0; k_macro < Filter2[i].n; k_macro++) \
	    UnsetBit(Filter1[i], Filter2[i].list[k_macro]); \
    } \
    Filter2[i].n = 0; \
}



#define AppendFilter2(f,x) { \
    (f).n++; \
    assert(( (f).list = realloc((f).list, (f).n * sizeof(NODE_ID))) != NULL); \
    (f).list[ (f).n - 1 ] = (x); \
}


#endif
