/**
 * Copyright 2007 The Apache Software Foundation, All Rights Reserved,
 * Copyright 2008 Ethan Blanton.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * @see http://hadoop.apache.org/core/docs/r0.18.0/mapred_tutorial.html
 */

package edu.purdue.cs.eblanton;

import java.io.IOException;
import java.util.*;

import org.apache.hadoop.mapred.*;
import org.apache.hadoop.io.*;

/**
 * CounterReduce implements a reduction which accepts any
 * WritableComparable object and a vector of IntWritable occurrence
 * counts, and sums these counts.
 *
 * @author The Apache Software Foundation
 * @author Ethan Blanton
 *
 * @see MapReduceBase
 * @see Reducer
 */
public class CounterReduce extends MapReduceBase
    implements Reducer<WritableComparable, IntWritable, WritableComparable, IntWritable> {
    /**
     * Implements the CounterReduce reduction operation.
     *
     * @param key       the WritableComparable object being counted
     * @param values    iterator over counts provided by the Map operation
     * @param output    the output collector for the resulting sum
     * @param reporter  ignored
     */
    public void reduce(WritableComparable key, Iterator<IntWritable> values,
                       OutputCollector<WritableComparable, IntWritable> output,
                       Reporter reporter) throws IOException {
        int sum = 0;

        while(values.hasNext()) {
            sum += values.next().get();
        }
        output.collect(key, new IntWritable(sum));
    }
}