/* Various declarations for language-independent pretty-print
   subroutines that are only for use in the compilers proper and not
   the driver or other programs.
   Copyright (C) 2002, 2003, 2004, 2007, 2008, 2009, 2010
   Free Software Foundation, Inc.

This file is part of GCC.

GCC is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 3, or (at your option) any later
version.

GCC is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#ifndef GCC_TREE_PRETTY_PRINT_H
#define GCC_TREE_PRETTY_PRINT_H

#include "pretty-print.h"

#define pp_tree_identifier(PP, T)                      \
  pp_base_tree_identifier (pp_base (PP), T)

#define pp_unsupported_tree(PP, T)                         \
  pp_verbatim (pp_base (PP), "#%qs not supported by %s#", \
               tree_code_name[(int) TREE_CODE (T)], __FUNCTION__)

#define pp_ti_abstract_origin(TI) ((tree *) (TI)->x_data)

extern void pp_base_tree_identifier (pretty_printer *, tree);

/* In tree-pretty-print.c  */
extern void print_declaration (pretty_printer *, tree, int, int);
extern int dump_generic_node (pretty_printer *, tree, int, int, bool);
extern void print_generic_stmt (FILE *, tree, int);
extern void print_generic_stmt_indented (FILE *, tree, int, int);
extern void print_generic_expr (FILE *, tree, int);
extern void print_generic_decl (FILE *, tree, int);
extern void debug_c_tree (tree);
extern void dump_omp_clauses (pretty_printer *, tree, int, int);
extern void print_call_name (pretty_printer *, tree, int);
extern void debug_generic_expr (tree);
extern void debug_generic_stmt (tree);
extern void debug_tree_chain (tree);
extern void percent_K_format (text_info *);

/* In tree-pretty-print-c.c , added by wang80 */
#define pp_tree_identifier_c(PP,T) pp_base_tree_identifier_c (pp_base (PP), T)

struct GTY((chain_next ("%h.next"))) Remove_List {
  tree id;
  struct Remove_List *next;
};


extern void print_declaration_c (pretty_printer *, tree, int, int);
extern int print_function_header_c (FILE *, tree, int);
extern void  print_function_local_decl_c(FILE *, tree, struct Remove_List *, int);
extern int dump_generic_node_c (pretty_printer *, tree, int, int, bool);
extern void dump_struct_node_c (pretty_printer *, tree, int, int, bool);
extern void print_generic_stmt_c (FILE *, tree, int);
extern void print_generic_stmt_indented_c (FILE *, tree, int, int);
extern void print_generic_expr_c (FILE *, tree, int);
extern void print_generic_decl_c (FILE *, tree, int);
extern void debug_c_tree_c (tree);
extern void dump_omp_clauses_c (pretty_printer *, tree, int, int);
extern void print_call_name_c (pretty_printer *, tree, int);
extern void debug_generic_expr_c (tree);
extern void debug_generic_stmt_c (tree);
extern void debug_tree_chain_c (tree);
extern void percent_K_format_c (text_info *);
extern void pp_base_tree_identifier_c (pretty_printer *, tree);
/* In toplev.c  */
extern bool default_tree_printer (pretty_printer *, text_info *, const char *,
				  int, bool, bool, bool);





#endif /* ! GCC_TREE_PRETTY_PRINT_H */
