#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "tree.h"
#include "langhooks.h"
#include "flags.h"
#include "cgraph.h"
#include "diagnostic.h"
#include "gimple-pretty-print.h"
#include "gimple.h"
#include "timevar.h"
#include "params.h"
#include "fibheap.h"
#include "intl.h"
#include "tree-pass.h"
#include "hashtab.h"
#include "coverage.h"
#include "ggc.h"
#include "tree-flow.h"
#include "rtl.h"
#include "ipa-prop.h"
#include "except.h"
#include "function.h"
//#include "type-decl-opt.h"
#include <stdio.h>


FILE *dumpfile;

struct Type_List *printedtypelist;

static void init_dump(){
  char outputfile[100];
  strcpy(outputfile,input_filename);
  strcat(outputfile, "_source.c");
  
  dumpfile = fopen(outputfile,"w");
}


static inline void
switch_to_context_new( tree func_decl )
{
  push_cfun (DECL_STRUCT_FUNCTION (func_decl));
  current_function_decl = func_decl;
}


static inline void
switch_off_context_new (void)
{
  pop_cfun ();
  if ( cfun )
    current_function_decl = cfun->decl;
  else
    current_function_decl = NULL_TREE;
}

/* print function call, notice the system call such as "printf" */
static void dump_gimple_to_c_call(FILE *fp, gimple stmt){
  
 
  
}

#ifdef NO_CHANCE_THAT_THIS_SYMBOL_WILL_EVER_EXIST  
void dump_gimple_statement(gimple stmt){
  /*get the gimple code*/
  enum gimple_code stmt_code = gimple_code (stmt);  
  
  /*print the statement based on different type*/
  //fprintf (dumpfile, "LINE : %d", LOCATION_LINE (gimple_location (stmt)));

  //fprintf (dumpfile, " STMT %lld: ", gimple_uid(stmt));
  print_gimple_stmt_c (dumpfile, stmt, 0, 0); //added in gimple-pretty-print-c.c
  fprintf(dumpfile,"\n");

  
}


/*if stmt is a "printf" function call */
int isPrintf(gimple stmt){
  enum gimple_code stmt_code = gimple_code (stmt);
  if (stmt_code != GIMPLE_CALL) return 0;
  
  tree fn = gimple_call_fn(stmt);
  if (TREE_CODE (fn) == NON_LVALUE_EXPR)
    fn = TREE_OPERAND (fn, 0);

 continue_1:
  switch (TREE_CODE (fn))
    {
    case VAR_DECL:
    case PARM_DECL:
    case FUNCTION_DECL:
      goto continue_2;
      break;
      
    case ADDR_EXPR:
    case INDIRECT_REF:
    case NOP_EXPR:
      fn = TREE_OPERAND (fn, 0);
      goto continue_1;
      /*
    case COND_EXPR:
      pp_string (buffer, "(");
      dump_generic_node (buffer, TREE_OPERAND (op0, 0), 0, flags, false);
      pp_string (buffer, ") ? ");
      dump_generic_node (buffer, TREE_OPERAND (op0, 1), 0, flags, false);
      pp_string (buffer, " : ");
      dump_generic_node (buffer, TREE_OPERAND (op0, 2), 0, flags, false);
      break;

    case ARRAY_REF:
      if (TREE_CODE (TREE_OPERAND (op0, 0)) == VAR_DECL)
	dump_function_name (buffer, TREE_OPERAND (op0, 0), flags);
      else
	dump_generic_node (buffer, op0, 0, flags, false);
      break;

    case MEM_REF:
      if (integer_zerop (TREE_OPERAND (op0, 1)))
	{
	  op0 = TREE_OPERAND (op0, 0);
	  goto again;
	}
     
    case COMPONENT_REF:
    case SSA_NAME:
    case OBJ_TYPE_REF:
      dump_generic_node (buffer, op0, 0, flags, false);
      break;
      */
    default:
      break;
    }
  return 0;
 continue_2:
  printf("%s\n",lang_hooks.decl_printable_name (fn, 1));
  if (strcmp(lang_hooks.decl_printable_name (fn, 1),"printf")) return 0; 
  return 1;
}
/* handle D.*="";
   printf(D.*,...);
*/
void dump_gimple_statement_1(gimple stmt, gimple stmt1){
  /*get the gimple code*/
  int flags;
  enum gimple_code stmt_code = gimple_code (stmt);
  
  /*print the statement based on different type*/
  //fprintf (dumpfile, "LINE : %d", LOCATION_LINE (gimple_location (stmt)));

  //fprintf (dumpfile, " STMT %lld: ", gimple_uid(stmt));

  if (!isPrintf(stmt))
    print_gimple_stmt_c(dumpfile, stmt1, 0, 0);

  /* if this is a printf call, the first parameter should be builted in*/
  flags = TDF_PRINT;
  print_gimple_stmt_c (dumpfile, stmt, 0, flags); //added in gimple-pretty-print-c.c                                                    
  fprintf(dumpfile,"\n");

}

void dump_bb_new(basic_block bb){
  gimple_stmt_iterator bsi; //iterator object for gimple statement sequence
  
  /*
  fprintf (dumpfile, "BB %d  in  FILE %s   FUNCTION %s ",
	   (bb->extra_info),
	   DECL_SOURCE_FILE (node->decl),
	   lang_hooks.decl_printable_name (node->decl, 2)
	   );
  */

  gimple tempstmt;
  int flag = 0;
  enum gimple_code stmt_code;
  for (bsi = gsi_start_bb (bb); !gsi_end_p (bsi); gsi_next (&bsi))
    {
      gimple stmt = gsi_stmt (bsi);
      stmt_code = gimple_code(stmt);
      if (flag ==0 && stmt_code == GIMPLE_ASSIGN) {
	tempstmt = stmt;
	flag = 1;
	continue;
      }
     
      if (flag ==0 && stmt_code != GIMPLE_ASSIGN){
	dump_gimple_statement(stmt);
	continue;
      }
	
      if (flag == 1 && stmt_code != GIMPLE_ASSIGN) {
	dump_gimple_statement_1(stmt,tempstmt);
	flag = 0;
      } else {
	dump_gimple_statement(tempstmt);
	tempstmt = stmt;
      }
	
    }

  gimple_seq seq = bb_seq (bb);
  if ( gimple_seq_empty_p(seq) )
    fprintf (dumpfile, "  empty" );

  fprintf (dumpfile, "\n" );
}
#endif
 
static void dump_sourcec_main(){
  if (!flag_instr_source) return;
  printf("to do: dumping c source code from gimple ...\n");

  struct cgraph_node *node;
  struct cgraph_node *node_end;

  printedtypelist = NULL;
  init_dump();
  printf("initialization success!\n");
  
  /* dump type declarations: struct,union */
  dump_struct_declaration_c(dumpfile);
  /* dump the global variables*/
  dump_varpool_c(dumpfile);

  node_end = cgraph_nodes;
  while (node_end->next != NULL) node_end = node_end->next;

  //for (node = cgraph_nodes; node; node = node->next)
  for (node = node_end; node != cgraph_nodes ; node = node->previous)
    {

      switch_to_context_new (node->decl);
      
      dump_function_decl_c(node->decl,dumpfile);
      if (cfun == NULL) continue;
      
      pre_check_bb_edge(node->decl, dumpfile);
      basic_block bb;
      FOR_EACH_BB (bb)
	//dump_bb_new(bb);
	gimple_dump_bb_c(bb,dumpfile,2,0);
      

      /*********************************/
      /*
      bool ignore_topmost_bind = false, any_var = false; 
      gimple_seq body = gimple_body (node->decl);

      if (gimple_seq_first_stmt (body)
	  && gimple_seq_first_stmt (body) == gimple_seq_last_stmt (body)
	  && gimple_code (gimple_seq_first_stmt (body)) == GIMPLE_BIND)
	print_gimple_seq_c (dumpfile, body, 0, 0);
      else
	{
	  if (!ignore_topmost_bind)
	    fprintf (dumpfile, "{\n");

	  if (any_var)
	    fprintf (dumpfile, "\n");

	  print_gimple_seq_c (dumpfile, body, 2, 0);
	} */ 
      /*********************************/
      fprintf(dumpfile,"}\n\n");
      switch_off_context_new ();
    }
  fclose(dumpfile);
  printf("==================finished====================\n\n");
  //exit(1);
}

struct simple_ipa_opt_pass pass_dump_sourcec =
  {
    {
      SIMPLE_IPA_PASS,
      "dump-sourcec",               /* name */
      dump_sourcec_main,             /* gate */
      NULL, /* sub */
      NULL, /* next */
      0, /* static_pass_number */
      0, /* tv_id */
      PROP_ssa, /* properties_required */
      0, /* properties_provided */
      0, /* properties_destroyed */
      0, /* todo_flags_start */
    0
    }
  };
