#include <stdio.h>
#include <stdlib.h>

#define NUM_F 1000
#define GV_REF 1


const char *inName = "log.txt";
const char *intrName = "intr.txt";

int func[NUM_F];
int current_func = 0;
int gv = 0;
int intrTable[30];

void clear(int func[], int n){
  int i;
  for (i = 0 ; i < n; i++)
    func[i] = 0;
}

/*get the interrupt function ID*/
void init_intr_table(int intrTable[], char *filename){
  FILE *fp;
  if (!(fp = fopen(filename, "r"))) return;
  int n, i;

  fscanf(fp, "%d\n", &n);
  for (i = 0; i < n; i++)
    fscanf(fp, "%d\n", &intrTable[i]);
  
  for (i; i < 30; i++)
    intrTable[i] = -1;
 
  fclose(fp);
}

int isIntr(int id){
  int i;

  for (i  = 0; i < 30; i++)
    if (intrTable[i] == id) return 1;
  return 0;
}

#if 0
void handle_func(FILE *fp, unsigned char buffer[100], int n){
  int name = buffer[0] << 8 + buffer[1];
  if (isIntr(name)) {
    // an interupt
    fprintf(fp, "%d %d %d %d",current_func, func[current_func], name, gv);
    return;
  }

  func[name] ++;
  return;
}

void handle_var(FILE *fp, unsigned char buffer[100], int n){
  int name = buffer[0] << 8 + buffer[1];
  int type = buffer[2];
  
  if (name == GV_REF){
    gv = buffer[3] << 8 + buffer[4];
    return;
  }
  fwrite(buffer, sizeof(buffer[0]), n, fp); 
}
#endif
 
/*generate the reorgnized data & interrupt section*/
void generate_file(char *filename, FILE *wfp1, FILE *wfp2){
  FILE *rfp;
  if (!(rfp = fopen(filename, "rb"))) return;
  unsigned char c;
  unsigned char buffer[100];
  int name;
  int type;

  while (!feof(rfp)){
    fread(&c, 1, 1, rfp);
    int j = 0;
    while (c != '#'){
      buffer[j] = c;
      j++;
      fread(&c, 1, 1, rfp);
    }
    if (j <= 2) {
      // this is a function enter/return record
      name = buffer[0] << 8 + buffer[1];
      if (isIntr(name)) {
	// an interupt
	fprintf(wfp2, "%d %d %d %d",current_func, func[current_func], name, gv);
      } else func[name] ++;
    }else{
      name = buffer[0] << 8 + buffer[1];
      type = buffer[2];

      if (name == GV_REF){
	gv = buffer[3] << 8 + buffer[4];
	return;
      }
      fwrite(buffer, sizeof(buffer[0]), j, wfp1);
    }
      
  }
  
  fclose(rfp);
}



void main(){

  int intrTable[30];

  FILE *wfp1 = fopen("data_section", "wb");
  FILE *wfp2 = fopen("intr_section", "w");
  
  clear(func, NUM_F);
  init_intr_table(intrTable, intrName);
  generate_file(inName, wfp1, wfp2);
  

  fclose(wfp1);
  fclose(wfp2);


}
