#include <sys/time.h>
#include <stdio.h>
#include <unistd.h>
#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "ggc.h"
#include "obstack.h"
#include "bitmap.h"
#include "flags.h"
#include "basic-block.h"
#include "output.h"
#include "tree.h"
#include "tree-flow.h"
#include "tree-inline.h"
#include "diagnostic-core.h"
#include "hashtab.h"
#include "function.h"
#include "tree-pass.h"
#include "timevar.h"
#include "alloc-pool.h"
#include "splay-tree.h"
#include "params.h"
#include "cgraph.h"
#include "alias.h"
#include "pointer-set.h"
#include "pta.h"
#include "et-forest.h"
 
/******************** begin global variables & initializer ********************/
//#define START_FUNC "f"
//#define START_BB 2

#define USE_PRE_RESULT true
#define USE_POST_RESULT true
#define USE_UNSTEABLE true
#define GET_MORE_ACCURATE true
#define COLLECT_TEST true
#define MUST_TEST false
#define TEST2 true
#define TEST_ANSWER_BY false

#define dump_flags 1
#define TDF_DETAILS 0

#define HEAP_PARENT(i) (i-1)/2
#define HEAP_LEFT(i) 2*i+1
#define HEAP_RIGHT(i) 2*i+2
#define has_exact_pointsto(id) (id >= 0 ? 1 : 0)
int varcnt = 0;
int totalcnt = 0;
#if(TEST_ANSWER_BY)
static int g_level;
#endif
static bool reuse = false;
char START_FUNC[50];
int START_BB = 2;
enum {MAY_INFO = -1, UNKNOWN = -2, TRY_AGAIN = -3};
enum {BEFORE = true, AFTER = false};


struct resultInfo{
	bitmap before_workVar;
	bitmap after_workVar;
	bitmap UpdatedTo;
	bitmap mask;
	int mustPointsTo;
	struct resultInfo *next;
};

struct disjointedSet{
	unsigned int rep;
	struct resultInfo *head;	
	struct resultInfo *tail;	
};

#if(USE_LIST_NODE)
struct callStringSummary{
    VEC(gimple, heap) *callString;
    int size;
    struct disjointedSet *summary;
};
typedef struct callStringSummary *summary_t;
DEF_VEC_P(summary_t);
DEF_VEC_ALLOC_P(summary_t,heap);
#endif

struct cgraph_dom{
    sbitmap dominator;
    unsigned int depth;
	struct disjointedSet *preResult;
#if(USE_LIST_NODE)
    VEC(summary_t, heap) *postHead;
#else
	struct disjointedSet *postResult;
#endif
};

struct cgraph_dom *dom = NULL;
htab_t derefTab = NULL;
int derefDepth = 0;

struct cgraph_node *main_node = NULL; 

long timer[5];
unsigned int cnt[5];

struct preList{
	struct resultInfo *info;
	struct cgraph_node *checkNode;
	bitmap old_UpdatedTo;
	bitmap after_workVar;
	bool try_again;
	unsigned int root;
};

typedef struct preList *preList_t;
DEF_VEC_P(preList_t);
DEF_VEC_ALLOC_P(preList_t, heap);

struct constraint *all_constraints;
int constraints_cnt;

struct bootstrap_varinfo *bsvars;
unsigned int var_range;

// Used for keeping track of variables //
typedef struct TraceVar *TraceVar_t;
DEF_VEC_P(TraceVar_t);
DEF_VEC_ALLOC_P(TraceVar_t,heap);
VEC(TraceVar_t, heap) *trace_var = NULL;
VEC(TraceVar_t, heap) *reuse_var = NULL;




// Used for keeeping track of each accurate deref trace. //

// Used for each call site of a function //
struct CallList{
	gimple call_stmt;
	struct cgraph_node *calleeNode;
	struct TraceVar *var;
};
typedef struct CallList *CallList_t;
DEF_VEC_P(CallList_t);
DEF_VEC_ALLOC_P(CallList_t,heap);

struct workBB_func_rep {
	int id;
/*	void *ptr;*/
	struct cgraph_node *ptr;
	bitmap workVar;
	bitmap old_workVar;
	bitmap exit_old_workVar;
	unsigned int depth;
	/*enum {ENABLE, DISABLE} backEdge;*/
	bool inQueue;
	VEC(CallList_t, heap) *callList;
};

static htab_t VarTab = NULL;

// Used for pretty printing in dump_dominator_tree //
sbitmap depth_flag;

enum dump_flag {ALL, STMT, CONSTRAINTS};

// Used for rolling back //
bool rollBackFlag = false;

// Used for workVar bitmap //
static bitmap_obstack workVar_obstack;
static bitmap_obstack result_obstack;

static inline TraceVar_t
alloc_var(struct CheckPoint p);

static inline TraceVar_t
lookup_var(struct CheckPoint p);

static void 
bootstrap_caller_off(struct cgraph_node *, gimple_stmt_iterator, struct TraceVar *, struct workBB_func_rep *, bool, enum bootstrap_mode);

static void
bootstrap_caller_on(struct workBB_func_rep **, int *, struct TraceVar *, struct workBB_func_rep *, struct cgraph_node *, enum bootstrap_mode);

static void
calculate_pt_level(struct TraceVar *, unsigned int);

void
print_tree_code(FILE *file, tree node){
  switch (TREE_CODE (node))
    {
    case ERROR_MARK:
		fprintf(file, "ERROR_MARK");
      break;

    case IDENTIFIER_NODE:
		fprintf(file, "IDENTIFIER_NODE");
      break;

    case TREE_LIST:
      break;

    case TREE_BINFO:
      break;

    case TREE_VEC:
      break;

    case VOID_TYPE:
    case INTEGER_TYPE:
    case REAL_TYPE:
    case FIXED_POINT_TYPE:
    case COMPLEX_TYPE:
    case VECTOR_TYPE:
    case ENUMERAL_TYPE:
    case BOOLEAN_TYPE:
	break;

    case POINTER_TYPE:
	fprintf(file, "POINTER_TYPE");
	break;

    case REFERENCE_TYPE:
	fprintf(file, "REFERENCE_TYPE");
	break;

    case OFFSET_TYPE:
	fprintf(file, "OFFSET_TYPE");
	break;

    case MEM_REF:
		fprintf(file, "MEM_REF");
	break;

    case TARGET_MEM_REF:
	fprintf(file, "TARGET_MEM_REF");
	break;

    case ARRAY_TYPE:
		fprintf(file, "ARRAY_TYPE");
	break;

    case RECORD_TYPE:
    case UNION_TYPE:
    case QUAL_UNION_TYPE:
        break;

    case LANG_TYPE:
      break;

    case INTEGER_CST:
      fprintf(file, "INTEGER_CST");
      break;

    case REAL_CST:
      fprintf(file, "REAL_CST");
	break;

    case FIXED_CST:
      fprintf(file, "FIXED_CST");
	break;

    case COMPLEX_CST:
      fprintf(file, "COMPLEX_CST");
      break;

    case STRING_CST:
      fprintf(file, "STRING_CST");
      break;

    case VECTOR_CST:
      fprintf(file, "VECTOR_CST");
      break;

    case FUNCTION_TYPE:
    case METHOD_TYPE:
		fprintf(file, "METHOD_TYPE");
      break;

    case FUNCTION_DECL:
    case CONST_DECL:
      break;

    case LABEL_DECL:
    case TYPE_DECL:
      break;

    case VAR_DECL:
    case PARM_DECL:
    case FIELD_DECL:
    case DEBUG_EXPR_DECL:
    case NAMESPACE_DECL:
      break;

    case RESULT_DECL:
      break;

    case COMPONENT_REF:
	  fprintf(file, "COMPONENT_REF");
      break;

    case BIT_FIELD_REF:
      break;

    case ARRAY_REF:
		fprintf(file, "ARRAY_REF");
	break;

    case ARRAY_RANGE_REF:
      break;

    case CONSTRUCTOR:
      break;

    case COMPOUND_EXPR:
      break;

    case STATEMENT_LIST:
      break;

    case MODIFY_EXPR:
    case INIT_EXPR:
      break;

    case TARGET_EXPR:
      break;

    case DECL_EXPR:
      break;

    case COND_EXPR:
      break;

    case BIND_EXPR:
      break;

    case CALL_EXPR:
		fprintf(file, "CALL_EXPR");
      break;

    case WITH_CLEANUP_EXPR:
      break;

    case CLEANUP_POINT_EXPR:
      break;

    case PLACEHOLDER_EXPR:
      break;

      /* Binary arithmetic and logic expressions.  */
    case WIDEN_SUM_EXPR:
    case WIDEN_MULT_EXPR:
    case MULT_EXPR:
    case PLUS_EXPR:
    case POINTER_PLUS_EXPR:
    case MINUS_EXPR:
    case TRUNC_DIV_EXPR:
    case CEIL_DIV_EXPR:
    case FLOOR_DIV_EXPR:
    case ROUND_DIV_EXPR:
    case TRUNC_MOD_EXPR:
    case CEIL_MOD_EXPR:
    case FLOOR_MOD_EXPR:
    case ROUND_MOD_EXPR:
    case RDIV_EXPR:
    case EXACT_DIV_EXPR:
    case LSHIFT_EXPR:
    case RSHIFT_EXPR:
    case LROTATE_EXPR:
    case RROTATE_EXPR:
    case VEC_LSHIFT_EXPR:
    case VEC_RSHIFT_EXPR:
    case BIT_IOR_EXPR:
    case BIT_XOR_EXPR:
    case BIT_AND_EXPR:
    case TRUTH_ANDIF_EXPR:
    case TRUTH_ORIF_EXPR:
    case TRUTH_AND_EXPR:
    case TRUTH_OR_EXPR:
    case TRUTH_XOR_EXPR:
    case LT_EXPR:
    case LE_EXPR:
    case GT_EXPR:
    case GE_EXPR:
    case EQ_EXPR:
    case NE_EXPR:
    case UNLT_EXPR:
    case UNLE_EXPR:
    case UNGT_EXPR:
    case UNGE_EXPR:
    case UNEQ_EXPR:
    case LTGT_EXPR:
    case ORDERED_EXPR:
    case UNORDERED_EXPR:
      break;

      /* Unary arithmetic and logic expressions.  */
    case NEGATE_EXPR:
    case BIT_NOT_EXPR:
    case TRUTH_NOT_EXPR:
    case ADDR_EXPR:
    case PREDECREMENT_EXPR:
    case PREINCREMENT_EXPR:
    case INDIRECT_REF:
      break;

    case POSTDECREMENT_EXPR:
    case POSTINCREMENT_EXPR:
      break;

    case MAX_EXPR:
      break;

    case ABS_EXPR:
      break;

    case RANGE_EXPR:
      break;

    case SSA_NAME:
		fprintf(file, "SSA_NAME");
		break;
    case ADDR_SPACE_CONVERT_EXPR:
    case FIXED_CONVERT_EXPR:
    case FIX_TRUNC_EXPR:
    case FLOAT_EXPR:
      fprintf(file, "FLOAT_EXPR");
      break;

    CASE_CONVERT:
    case VIEW_CONVERT_EXPR:
    case PAREN_EXPR:
    case NON_LVALUE_EXPR:
    case SAVE_EXPR:
    case COMPLEX_EXPR:
    case CONJ_EXPR:
    case REALPART_EXPR:
    case IMAGPART_EXPR:
    case VA_ARG_EXPR:
    case TRY_FINALLY_EXPR:
    case TRY_CATCH_EXPR:
    case CATCH_EXPR:
    case EH_FILTER_EXPR:
    case LABEL_EXPR:
    case LOOP_EXPR:
    case PREDICT_EXPR:
    case RETURN_EXPR:
    case EXIT_EXPR:
    case SWITCH_EXPR:
    case GOTO_EXPR:
    case ASM_EXPR:
    case CASE_LABEL_EXPR:
    case OBJ_TYPE_REF:
    case WITH_SIZE_EXPR:
    case ASSERT_EXPR:
    case SCEV_KNOWN:
    case SCEV_NOT_KNOWN:
    case POLYNOMIAL_CHREC:
    case REALIGN_LOAD_EXPR:
    case VEC_COND_EXPR:
    case DOT_PROD_EXPR:
    case WIDEN_MULT_PLUS_EXPR:
    case WIDEN_MULT_MINUS_EXPR:
    case FMA_EXPR:
    case OMP_PARALLEL:
    case OMP_TASK:
    case OMP_FOR:
    case OMP_SECTIONS:
    case OMP_SECTION:
    case OMP_MASTER:
    case OMP_ORDERED:
    case OMP_CRITICAL:
    case OMP_ATOMIC:
    case OMP_SINGLE:
    case OMP_CLAUSE:
    case REDUC_MAX_EXPR:
    case REDUC_MIN_EXPR:
    case REDUC_PLUS_EXPR:
    case VEC_WIDEN_MULT_HI_EXPR:
    case VEC_WIDEN_MULT_LO_EXPR:
    case VEC_UNPACK_HI_EXPR:
    case VEC_UNPACK_LO_EXPR:
    case VEC_UNPACK_FLOAT_HI_EXPR:
    case VEC_UNPACK_FLOAT_LO_EXPR:
    case VEC_PACK_TRUNC_EXPR:
    case VEC_PACK_SAT_EXPR:
    case VEC_PACK_FIX_TRUNC_EXPR:
    case BLOCK:
    case VEC_EXTRACT_EVEN_EXPR:
    case VEC_EXTRACT_ODD_EXPR:
    case VEC_INTERLEAVE_HIGH_EXPR:
    case VEC_INTERLEAVE_LOW_EXPR:
	  fprintf(file, "other %d ", TREE_CODE(node));
      break;

    default:
      gcc_assert(0);
	}
}


static void 
init_bootstrap(void) {
	bitmap_obstack_initialize(&workVar_obstack);
}

static void 
release_bootstrap(void) {
	int i;
	TraceVar_t var;

/*	for (i = 0; VEC_iterate(TraceVar_t, reuse_var, i, var); i++){
		BITMAP_FREE(var->workVar);
		BITMAP_FREE(var->UpdatedTo);
		free(var);
	}
*/
//	free(all_constraints);
	bitmap_obstack_release(&workVar_obstack);
//	VEC_free(TraceVar_t, heap, reuse_var);
}

/********************* end global variables & initializer *********************/



/**************************** begin dump funcitons ****************************/
static void
dump_dominator_tree_1(FILE *file, unsigned int dir, basic_block bb, bool first) {
	int i;
	bool this_first;
	
	if(file == NULL)
		return;

	if(next_dom_son (CDI_DOMINATORS, bb) == NULL)
		RESET_BIT(depth_flag, bb->dom[dir]->depth);
	else
		SET_BIT(depth_flag, bb->dom[dir]->depth);

/*	if(first == true){
		if(TEST_BIT(depth_flag, bb->dom[dir]->depth))
            fprintf(file, "+ <bb %2d> ", bb->index);
        else
            fprintf(file, "- <bb %2d> ", bb->index);
	}else{
		for(i = 0; i < bb->dom[dir]->depth; i++){
			if(TEST_BIT(depth_flag, i))
				fprintf(file, "|         ");
			else
				fprintf(file, "          ");
		}
		if(TEST_BIT(depth_flag, bb->dom[dir]->depth))
			fprintf(file, "+ <bb %2d> ", bb->index);
		else
			fprintf(file, "- <bb %2d> ", bb->index);
	}
*/
	for(bb = first_dom_son (CDI_DOMINATORS, bb), this_first = true; bb; bb = next_dom_son (CDI_DOMINATORS, bb), this_first = false){
		dump_dominator_tree_1(file, dir, bb, this_first);
//		if(first_dom_son (CDI_DOMINATORS, bb) == NULL){	// it is a leaf node
//			fprintf(file, "\n");
//		}
	}
}

static inline void
dump_dominator_tree(FILE *file, basic_block bb, unsigned int max_depth){
	if(file){
		depth_flag = sbitmap_alloc(max_depth);

		sbitmap_zero(depth_flag);
		dump_dominator_tree_1(file, 0, bb, true);
		sbitmap_free(depth_flag);
	}
}

void
dump_bitmap_var(FILE *file, bitmap bmap) {
	unsigned int i;
	bitmap_iterator bi;

	if(file){
		EXECUTE_IF_IN_NONNULL_BITMAP (bmap, 0, i, bi){
			if(i >= var_range){
				fprintf (file, "*%s", bsvars[i-var_range].name);
				fprintf (file, "(%d) ", i);
			}else{
				fprintf (file, "%s", bsvars[i].name);
				fprintf (file, "(%d) ", i);
			}
		}
	}
}

static void
dump_constraint (FILE *file, struct constraint *c)
{
	if(file){
		if (c->lhs.type == ADDRESSOF)
			fprintf (file, "&");
		else if (c->lhs.type == DEREF)
			fprintf (file, "*");
		fprintf (file, "%s", get_pta_name (c->lhs.var));
		fprintf (file, "(%d)",c->lhs.var);
		if (c->lhs.offset == UNKNOWN_OFFSET)
			fprintf (file, " + UNKNOWN");
		else if (c->lhs.offset != 0)
			fprintf (file, " + " HOST_WIDE_INT_PRINT_DEC, c->lhs.offset);
		fprintf (file, " = ");
		if (c->rhs.type == ADDRESSOF)
			fprintf (file, "&");
		else if (c->rhs.type == DEREF)
			fprintf (file, "*");
		fprintf (file, "%s", get_pta_name (c->rhs.var));
		fprintf (file, "(%d)",c->rhs.var);
		if (c->rhs.offset == UNKNOWN_OFFSET)
			fprintf (file, " + UNKNOWN");
		else if (c->rhs.offset != 0)
			fprintf (file, " + " HOST_WIDE_INT_PRINT_DEC, c->rhs.offset);
		fprintf (file, "\n");
	}
}

static void
dump_solution_for_var (FILE *file, unsigned int id) {
	if(file){
		fprintf (file, "%s(%d) = { ", bsvars[id].name, id);
		dump_bitmap_var(file, bsvars[id].solution);
		fprintf (file, "}\n");
	}

/*
	varinfo_t vi = get_varinfo (var);

	// Dump the solution for unified vars anyway, this avoids difficulties
	//   in scanning dumps in the testsuite.  
	fprintf (file, "%s(%d) = { ", vi->name, vi->id);
	vi = get_varinfo (find (var));
	dump_bitmap_var(file, vi->solution);
	fprintf (file, "}");

	// But note when the variable was unified.  
	if (vi->id != var)
		fprintf (file, " same as %s", vi->name);
	fprintf (file, "\n");
*/
}

static inline void
dump_stmt_and_constraint(FILE *file, gimple stmt, int index, struct constraint *c, enum dump_flag flag) {
	if(file){
		if(flag == ALL || flag == STMT){
			fprintf(file, "\tstmt:\t");
			print_gimple_stmt(file, stmt, 0, 0);
		}
		if(flag == ALL || flag == CONSTRAINTS){
			fprintf(file, "\t\tconstraint %d:\t", index);
			dump_constraint (file, c);
		}
	}
}

static inline void
dump_bitmap_elements(FILE *file, bitmap bmap, char left, const char *str, char right) {
	if(file){
		fprintf (file, "%s = %c ", str, left);
		dump_bitmap_var(file, bmap);
		fprintf (file, "%c\n", right);
	}
}

/***************************** end dump funcitons *****************************/

#define list_node_push(LIST, STMT)              \
  VEC_safe_push(gimple, heap, LIST, STMT);

#define list_node_pop(LIST, STMT)               \
    if(VEC_length(gimple, LIST) == 0)			\
        STMT = NULL;                            \
    else{                                       \
        STMT = VEC_pop(gimple, LIST);			\
        if(VEC_length(gimple, LIST) == 0){		\
            VEC_free(gimple, heap, LIST);       \
            LIST = NULL;                        \
        }                                       \
    }

#define list_node_free(LIST)			\
    VEC_free(gimple, heap, LIST);       \
    LIST = NULL;

inline void 
dump_list_node(FILE *fp, VEC(gimple, heap) *LIST){
    int i, j;
    gimple stmt;
    for (i = 0; VEC_iterate(gimple, LIST, i, stmt); i++){
        for(j = 0; j < i; j ++)
            fprintf(fp, "\t");
        print_gimple_stmt(fp, stmt, 0, 0);
    }
    fprintf(fp, "\n");
}

#define list_node_copy(des, src){                               \
    int i;                                                      \
    gimple stmt;                                                \
    if(des != NULL)                                             \
        gcc_assert(0);                                          \
    if(src != NULL)                                             \
    for (i = 0; VEC_iterate(gimple, src, i, stmt); i++){        \
        VEC_safe_push (gimple, heap, des, stmt);                \
    }                                                           \
}                                                               \

inline bool
list_node_compare(VEC(gimple, heap) *src1, VEC(gimple, heap) *src2){
    int i;
    gimple stmt1, stmt2;
    if(VEC_length(gimple, src1) != VEC_length(gimple, src2))
        return true;
    for (i = 0; VEC_iterate(gimple, src1, i, stmt1) && VEC_iterate(gimple, src2, i, stmt2); i++){
        if(stmt1 != stmt2)
            return true;
    }
    return false;
}



/* Create new indirect edges with each edge coresponding to a possible target */
/* TODO: possibleCallee needs to be freed */
void
cgraph_resolve_indirect_edge (struct cgraph_node *caller, struct cgraph_edge *iedge) {
	struct edgeList *headEdge = NULL, *oldheadEdge;
	gimple call = iedge->call_stmt;

	if(dump_file){
		fprintf(dump_file, "solving indirect call:\t");
		print_gimple_stmt(dump_file, call, 0, 0);
	}

	tree target = gimple_call_fn (call);
	gcc_assert (TREE_CODE (target) == SSA_NAME);

//  struct ptr_info_def *pi = SSA_NAME_PTR_INFO (target);
//  gcc_assert (pi);

	struct variable_info *vi = lookup_vi_for_tree(target);
	bitmap pta = get_pta_solution(vi->id);
	gcc_assert (pta && !bitmap_empty_p (pta));

//fprintf(dump_file, "%d\n", vi->id);
//dump_bitmap_var(dump_file, pi->pt.vars);
//  gcc_assert (pi->pt.vars && !bitmap_empty_p (pi->pt.vars));

//  iedge->indirect_info->next = NULL;
//  if(!iedge->possibleCallee){
//	gcc_assert(0);
//	iedge->possibleCallee = XNEW(struct nodeList);
//  }

	int count = 0;
	struct cgraph_node *node;
	for (node = cgraph_nodes; node; node = node->next) {
		vi = lookup_vi_for_tree(node->decl);

		fprintf(dump_file, "%d ", vi->id);
		//if (bitmap_bit_p (pi->pt.vars, DECL_UID (node->decl)))
		if (bitmap_bit_p (pta, vi->id)) {
			if(dump_file){
				fprintf(dump_file, "\n\tnew_edge:\t%s->%s\n", cgraph_node_name(caller), cgraph_node_name(node));
			}

			oldheadEdge = node->possibleCaller;
			headEdge = XNEW(struct edgeList);
			headEdge->edge = iedge;
			headEdge->next = oldheadEdge;
			node->possibleCaller = headEdge;
			/*
	  struct cgraph_edge *edge = cgraph_create_edge (caller, node, call,
							 iedge->count,
							 iedge->frequency,
							 iedge->loop_nest);



	  edge->indirect_unknown_callee = 0;
	  edge->indirect_info =
	    ggc_alloc_cleared_cgraph_indirect_call_info ();
	  edge->indirect_info->param_index = -1;
	  edge->indirect_info->ecf_flags = iedge->indirect_info->ecf_flags;
	  edge->indirect_fake_edge = 1;
	  edge->indirect_info->next = NULL;

	  edge->next_callee = caller->indirect_calls;
	  if (caller->indirect_calls)
	    caller->indirect_calls->prev_callee = edge;
	  caller->indirect_calls = edge;

//	 edge->next_caller = 

	  if (!iedge->indirect_info->next)
	    iedge->indirect_info->next = edge;
	  else
	    {
	      edge->indirect_info->next = iedge->indirect_info->next;
	      iedge->indirect_info->next = edge;
	    }

	  count++;
*/
		}
	}
}


void
cgraph_resolve_indirect_edges (void) {
	if(dump_file)
		fprintf(dump_file, "kobill: cgraph_resolve_indirect_edge\n");

	struct cgraph_node *node;
	for (node = cgraph_nodes; node; node = node->next)
		node->possibleCaller = NULL;
	for (node = cgraph_nodes; node; node = node->next) {
		if(dump_file){
			fprintf(dump_file, "kobill: dump cgraph node\n");
			dump_cgraph_node(dump_file, node);
		}
		/* Check indirect call */
		if (!node->indirect_calls)
			continue;

		struct cgraph_edge *edge;
		for (edge = node->indirect_calls; edge; edge = edge->next_callee) {
			if (edge->indirect_unknown_callee)
				cgraph_resolve_indirect_edge (node, edge);
		}
    }

	for (node = cgraph_nodes; node; node = node->next) {
			if(dump_file && node->possibleCaller){
				fprintf(dump_file, "\n\tnew_edge:\t%s->%s\n", cgraph_node_name(node->possibleCaller->edge->caller), cgraph_node_name(node));
			}
	}
}

inline bitmap
get_pta_solution(unsigned int id){
	return bsvars[id].solution;
}

inline const char *
get_pta_name(unsigned int id){
	return bsvars[id].name;
}

static inline bitmap 
find_solution_for_func(struct variable_info *vi, enum func_var offset) {
	for(; vi; vi = vi->next)
		if(vi->offset == offset)
			return get_pta_solution (vi->id);
	return NULL;
}

static inline struct variable_info *
find_varinfo_for_func(struct variable_info *vi, enum func_var offset) {
	for(; vi; vi = vi->next)
        if(vi->offset == offset)
            return vi;
    return NULL;
}

static void
calculate_dom_depth_for_call_graph(void){
	bool nochange_flag = false;
	struct cgraph_edge *edge;
	struct cgraph_node *node;
	sbitmap tmp;

	tmp = sbitmap_alloc(cgraph_max_uid+1);
	dom = XNEWVEC(struct cgraph_dom, cgraph_max_uid+1);

	for(node = cgraph_nodes; node; node = node->next){
#if(USE_LIST_NODE)
        dom[node->uid].postHead = NULL;
        dom[node->uid].preResult = NULL;
#else
		dom[node->uid].postResult = NULL;
		dom[node->uid].preResult = NULL;
#endif
		dom[node->uid].dominator = sbitmap_alloc(cgraph_max_uid+1);
		sbitmap_ones(dom[node->uid].dominator);
	}	

	sbitmap_zero(dom[main_node->uid].dominator);
	SET_BIT(dom[main_node->uid].dominator, main_node->uid);

	while(nochange_flag == false){
		nochange_flag = true;
		for(node = cgraph_nodes; node; node = node->next){
			gcc_assert(node->uid <= cgraph_max_uid + 1 && node->uid >= 0);
			if(node != main_node){
				sbitmap_ones(tmp);
				for(edge = node->callers; edge; edge = edge->next_caller){
					sbitmap_a_and_b(tmp, tmp, dom[edge->caller->uid].dominator);
				}
				struct edgeList *list;
				for(list = node->possibleCaller; list; list = list->next){
					sbitmap_a_and_b(tmp, tmp, dom[list->edge->caller->uid].dominator);
				}
				SET_BIT(tmp, node->uid);
				if(!sbitmap_equal(tmp, dom[node->uid].dominator)){
					sbitmap_copy(dom[node->uid].dominator, tmp);
					nochange_flag = false;
				}
			}

		}
	}

	for(node = cgraph_nodes; node; node = node->next){
		dom[node->uid].depth = sbitmap_popcount(dom[node->uid].dominator, cgraph_max_uid);
		if(dump_file)
			fprintf(dump_file, "cgraph_node %s(%d) depth = %d\n", cgraph_node_name(node), node->uid, dom[node->uid].depth);
	}

	sbitmap_free(tmp);

	for(node = cgraph_nodes; node; node = node->next){
		sbitmap_free(dom[node->uid].dominator);
	}

}

static void
init_workFunc(struct workBB_func_rep *workFunc){
	struct cgraph_node *node;
	for(node = cgraph_nodes; node; node = node->next){
		workFunc[node->uid].workVar = BITMAP_ALLOC(&workVar_obstack);
		workFunc[node->uid].old_workVar = BITMAP_ALLOC(&workVar_obstack);
		workFunc[node->uid].exit_old_workVar = BITMAP_ALLOC(&workVar_obstack);
		workFunc[node->uid].ptr = node;
		workFunc[node->uid].depth = dom[node->uid].depth;
		workFunc[node->uid].callList = NULL;
		workFunc[node->uid].inQueue = false;
	}
}



/* Return true if two deref CheckPoint table entries are the same. */
static int
trans_eq_deref (const void *p1, const void *p2) {
	const struct CheckPoint *ve1 = (const struct CheckPoint *) p1;
	const struct CheckPoint *ve2 = (const struct CheckPoint *) p2;

	if (ve1->id != ve2->id)
		return false;

	if (ve1->gsi.ptr != ve2->gsi.ptr)
		return false;

	if (ve1->gsi.bb != ve2->gsi.bb)
		return false;

	if (ve1->gsi.seq != ve2->gsi.seq)
		return false;


	if (ve1->node != ve2->node)
		return false;
/*
	if(gsi_stmt(ve1->gsi) != gsi_stmt(ve2->gsi))
		return false;*/
	return true;
}

/* Return the hash value for a deref CheckPoint.  */
static hashval_t
trans_hash_deref (const void *p) {
	const struct CheckPoint *ve = (const struct CheckPoint *) p;
	return ve->id;
}

static inline struct CheckPoint *
lookup_deref(struct CheckPoint p) {
    void **slot;

    slot = htab_find_slot (derefTab, &p, NO_INSERT);
    if (!slot)
        return NULL;
	return ((struct CheckPoint *)*slot);
}

static inline void
dealloc_deref(struct CheckPoint p) {
    void **slot;

    slot = htab_find_slot (derefTab, &p, NO_INSERT);
    if (!slot){
		gcc_assert(0);
	}else{
		free(*slot);
		htab_clear_slot	(derefTab, slot);
	}
}


static inline struct CheckPoint *
alloc_deref(struct CheckPoint p) {
	void **slot;
	struct CheckPoint *var;
	if((var = lookup_deref(p)) == NULL){
		var = XNEW(struct CheckPoint);
		var->id = p.id;
		var->gsi = p.gsi;
		var->node = p.node;
		slot = htab_find_slot (derefTab, var, INSERT);
		*slot = var;
	}else{
		gcc_assert(0);
	}
	return var;
}

/*********** calculate the number of pointers ***********/
/*
struct pointers{
  int id;
};

inline bool 
compare_func(const struct pointers *ve1, const struct pointers *ve2){
  if(ve1->id != ve2->id)
    return false;
  return true;
}

TB_prepare(struct pointers, PTRS);
TB_define(PTRS, compare_func, id);
*/ 
static int
calcualte_the_number_of_pointers(void){
    struct cgraph_node *node;
    gimple_stmt_iterator gsi;
    gimple stmt;
    basic_block bb;
    int i, cnt = 0;
    FILE *file = fopen ("mydumpfile.txt", "a");
//    TB_create(PTRS);
    for(node = cgraph_nodes; node; node = node->next){
        if (!gimple_has_body_p (node->decl) || node->clone_of)
            continue;

        struct function *func = DECL_STRUCT_FUNCTION (node->decl);
        tree old_func_decl = current_function_decl;
        push_cfun (func);
        current_function_decl = node->decl;
        fprintf(file, "\nConstraints for function %s\n", cgraph_node_name(node));
        FOR_EACH_BB_FN(bb, func){
            fprintf(file, "bb: <%d>\n", bb->index);
            for(gsi = gsi_start_bb(bb); !gsi_end_p (gsi); gsi_next (&gsi) ){
                stmt = gsi_stmt(gsi);
                for (i = gsi.ptr->constraints_start; i < gsi.ptr->constraints_end; i++){
                    struct constraint_expr lhs, rhs;
                    struct constraint *c;

                    c = &all_constraints[i];
                    lhs = c->lhs;
                    rhs = c->rhs;

                    if(lhs.type == DEREF){
                        cnt++;
/*                        ptr.id = lhs.var;

                        if(lookup_PTRS(&ptr) == NULL){
                            cnt ++;
                            alloc_PTRS(&ptr);
                        }
*/
                    }

                    if(rhs.type == DEREF){
                        cnt++;
/*
                        ptr.id = rhs.var;
                        if(lookup_PTRS(&ptr) == NULL){
                            cnt ++;
                            alloc_PTRS(&ptr);
                        }
*/
                    }
			
                    dump_constraint (file, c);
                }
            }
        }
        current_function_decl = old_func_decl;
        pop_cfun ();
    }

    fclose(file);
//    TB_free(PTRS);
    return cnt;
}


/*********** END calculate the number of pointers ***********/

static void
copy_var(TraceVar_t to, TraceVar_t from){
	to->node = from->node;
	to->gsi = from->gsi;
	to->id = from->id;
	to->mustAlias = from->mustAlias;
	to->mustPointsTo = from->mustPointsTo;
	to->mustAliasFlag = from->mustAliasFlag;
	to->weakUpdateFlag = from->weakUpdateFlag;
	to->unknownFlag = from->unknownFlag;
	to->level = from->level;
//	bitmap_copy(to->workVar, from->workVar);
	bitmap_copy(to->UpdatedTo, from->UpdatedTo);
}



static struct TraceVar *
get_more_accurate_deref(struct cgraph_node *start_node, struct constraint_expr *expr, gimple_stmt_iterator gsi, enum bootstrap_mode mode, VEC(gimple, heap) *src_list){
	struct TraceVar *var, *ret_var, *reuse_var = NULL;
	struct cgraph_node *node;
	struct CheckPoint p, org_p;
	gimple stmt;


	org_p.id = expr->var;
	org_p.node = start_node;
	stmt = gsi_stmt(gsi);
//	fprintf(stderr, "%p \t %p \t", stmt, gsi.ptr);
//	print_gimple_stmt(stderr, stmt, 0, 0);
//	org_p.gsi = gsi;
	org_p.gsi = gsi;

	gsi_prev(&gsi);

	var = XNEW(struct TraceVar);
#if(USE_LIST_NODE)
	bool skip_cache = true;
	var->list_node = NULL;
	list_node_copy(var->list_node, src_list);
	if(VEC_length(gimple, var->list_node) == 0)
	  skip_cache = false;
#endif
	var->UpdatedTo = BITMAP_ALLOC(&workVar_obstack);



	#if(GET_MORE_ACCURATE == false)
	bitmap_copy(var->UpdatedTo, get_pta_solution (expr->var));
	var->mustPointsTo = MAY_INFO;
	#else
	struct CheckPoint *check_ptr;

	p.id = expr->var;
	p.gsi = gsi;
	p.node = start_node;

	if(!derefTab)
		derefTab = htab_create (0, trans_hash_deref, trans_eq_deref, NULL);

	if(derefDepth != 0){
		check_ptr = lookup_deref(org_p);

		if(check_ptr != NULL){
			if(dump_file){
				fprintf(dump_file, "deref recursion elimination\n");
				fprintf(dump_file, "roll back\n");
			}
	//		gcc_assert(0);
			rollBackFlag = true;
			bitmap_clear(var->UpdatedTo);
			var->mustPointsTo = MAY_INFO;
			var->weakUpdateFlag = false;
			// special treatment for global initialized variables //
			bitmap_clear_bit(var->UpdatedTo, nothing_id);
			bitmap_clear_bit(var->UpdatedTo, anything_id);
			bitmap_clear_bit(var->UpdatedTo, readonly_id);
			bitmap_clear_bit(var->UpdatedTo, escaped_id);
			bitmap_clear_bit(var->UpdatedTo, nonlocal_id);
			bitmap_clear_bit(var->UpdatedTo, storedanything_id);
			bitmap_clear_bit(var->UpdatedTo, integer_id);
#if(USE_LIST_NODE)
			list_node_free(var->list_node);
#endif
			return var;

		}
	}else{
		check_ptr = lookup_deref(org_p);
		if(check_ptr != NULL){
	//		gcc_assert(0);
			if(dump_file){
				fprintf(dump_file, "deref recursion elimination\n");
			}
			rollBackFlag = false;
			bitmap_copy(var->UpdatedTo, get_pta_solution (expr->var));
			var->mustPointsTo = MAY_INFO;
			var->weakUpdateFlag = false;
			// special treatment for global initialized variables //
			bitmap_clear_bit(var->UpdatedTo, nothing_id);
			bitmap_clear_bit(var->UpdatedTo, anything_id);
			bitmap_clear_bit(var->UpdatedTo, readonly_id);
			bitmap_clear_bit(var->UpdatedTo, escaped_id);
			bitmap_clear_bit(var->UpdatedTo, nonlocal_id);
			bitmap_clear_bit(var->UpdatedTo, storedanything_id);
			bitmap_clear_bit(var->UpdatedTo, integer_id);
#if(USE_LIST_NODE)
			list_node_free(var->list_node);
#endif
			return var;
		}
	}

#if(TEST_ANSWER_BY)
    g_level = 4;
#endif

#if(TEST2 == true)
#if(USE_LIST_NODE)	
	if(!skip_cache)
#endif
	if((reuse_var = lookup_var(org_p)) != NULL){
		if(reuse_var->level == BOOTSTRAP4){
			if(reuse == false){
				reuse = true;
				fprintf(stdout, "reuse depth = %d\n", derefDepth);
			}

#if(USE_LIST_NODE)
            gcc_assert(var->list_node == NULL);
#endif
			
			bitmap tmp = var->UpdatedTo;
			*var = *reuse_var;
			var->UpdatedTo = tmp;
        	bitmap_copy(var->UpdatedTo, reuse_var->UpdatedTo);	

            //copy_var(var, reuse_var);
			/*
			var->mustPointsTo = reuse_var->mustPointsTo;
			var->unknownFlag = reuse_var->unknownFlag;
			var->weakUpdateFlag = reuse_var->weakUpdateFlag;
			bitmap_copy(var->UpdatedTo, reuse_var->UpdatedTo);	
			*/
			return var;
		}
	}
#endif
	derefDepth ++;
	alloc_deref(org_p);

	if(dump_file)
	fprintf(dump_file, "derefDepth = %d\n", derefDepth);



	if(dump_file)
		fprintf(dump_file, "Trying to find a more accurate result for *(%s)\n", get_pta_name(expr->var));

    var->level = 0;
    var->id = expr->var;
	var->gsi = org_p.gsi;
    var->node = start_node;
	var->workVar = BITMAP_ALLOC(&workVar_obstack);

    calculate_pt_level(var, BOOTSTRAP4);

	BITMAP_FREE(var->workVar);

	derefDepth --;

	if(rollBackFlag == false){
		dealloc_deref(org_p);
	}
	if(derefDepth == 0){
		if(rollBackFlag == true){
			if(dump_file){
				fprintf(dump_file, "set to Anderson's result %s(%d)\n", get_pta_name(expr->var), expr->var);
				dump_bitmap_elements(dump_file, get_pta_solution (expr->var), '[', "\t\tpta", ']');
			}
			rollBackFlag = false;
			bitmap_copy(var->UpdatedTo, get_pta_solution (expr->var));
			var->mustPointsTo = MAY_INFO;
			// special treatment for global initialized variables //
			bitmap_clear_bit(var->UpdatedTo, nothing_id);
			bitmap_clear_bit(var->UpdatedTo, anything_id);
			bitmap_clear_bit(var->UpdatedTo, readonly_id);
			bitmap_clear_bit(var->UpdatedTo, escaped_id);
			bitmap_clear_bit(var->UpdatedTo, nonlocal_id);
			bitmap_clear_bit(var->UpdatedTo, storedanything_id);
			bitmap_clear_bit(var->UpdatedTo, integer_id);
		}
	}
#if(TEST2 == true)
	if(rollBackFlag == false){
#if(USE_LIST_NODE)	
	if(!skip_cache)
#endif
	  {
#if(TEST_ANSWER_BY)
          g_level = 4;
#endif
		if(reuse_var == NULL)
			reuse_var = alloc_var(org_p);
#if(USE_LIST_NODE)	
        gcc_assert(var->list_node == NULL);
#endif

		BITMAP_FREE(reuse_var->workVar);
		BITMAP_FREE(reuse_var->UpdatedTo);
		*reuse_var = *var;
		reuse_var->workVar = BITMAP_ALLOC(NULL);
		reuse_var->UpdatedTo = BITMAP_ALLOC(NULL);
		bitmap_copy(reuse_var->UpdatedTo, var->UpdatedTo);
		/*
			reuse_var->mustAlias = var->mustAlias;
			reuse_var->mustPointsTo = var->mustPointsTo;
			reuse_var->unknownFlag = var->unknownFlag;
			reuse_var->weakUpdateFlag = var->weakUpdateFlag;
		bitmap_clear(reuse_var->workVar);
		bitmap_copy(reuse_var->UpdatedTo, var->UpdatedTo);
		*/
		//copy_var(reuse_var, var);
	  }
	//	fprintf(stderr, "\t record \t");
	//print_gimple_stmt(stderr, stmt, 0, 0);
	}
#endif
	#endif
	list_node_free(var->list_node);
	return var;
}

static void
solve_simple_stmt(struct cgraph_node *node, gimple_stmt_iterator gsi, struct TraceVar *var, bitmap workVar, enum bootstrap_mode mode) {
	int i;
	gimple stmt;
	struct constraint *c;
	bitmap UpdatedTo;
	
	UpdatedTo = var->UpdatedTo;
	stmt = gsi_stmt(gsi);

	for (i = gsi.ptr->constraints_end-1; i >= gsi.ptr->constraints_start; i--){
		struct constraint_expr lhs, rhs;
		bitmap lhs_deref;
		bitmap rhs_deref;
		bitmap_iterator bi;
		unsigned int j;

		c = &all_constraints[i];

//if(is_gimple_call (stmt))
//dump_stmt_and_constraint(dump_file, stmt, i, c, CONSTRAINTS);

		lhs = c->lhs;
		rhs = c->rhs;
		if(rhs.type == ADDRESSOF && (rhs.var <= integer_id && rhs.var != nothing_id))
			continue;
		// *x = ?
		if(lhs.type == DEREF){
			if(lhs.offset == UNKNOWN_OFFSET){
				lhs_deref = get_pta_solution (lhs.var);
			}else if(lhs.offset != 0){
				struct variable_info *v = get_varinfo (lhs.var);
				HOST_WIDE_INT fieldoffset = v->offset + lhs.offset;

				if (v->is_full_var)
					fieldoffset = v->offset;
				v = first_vi_for_offset (v, fieldoffset);
				/* If the access is outside of the variable we can ignore it.  */
				if (!v){
					if(dump_file)
						fprintf(dump_file, "outside of the variable\n");
					lhs_deref = get_pta_solution(0);
					lhs.var = 0;
				}else{
					lhs_deref = get_pta_solution(v->id);
					lhs.var = v->id;
				}
			}else{
				lhs_deref = get_pta_solution (lhs.var);
			}

			if(bitmap_intersect_p(lhs_deref, workVar)){

				// try to find more accurate result //
				struct TraceVar *var_deref;
				var_deref = get_more_accurate_deref(node, &(lhs), gsi, mode, var->list_node);
				if(rollBackFlag == true){
					bitmap_clear(workVar);
					bitmap_clear(var->workVar);
				}
				
				if(bitmap_intersect_p(var_deref->UpdatedTo, workVar)){
					if(lhs.offset == UNKNOWN_OFFSET)
						var->unknownFlag = true;
					if(!has_exact_pointsto(var_deref->mustPointsTo)){
//						var->mustAliasFlag = false;
						var->weakUpdateFlag = true;
						if(dump_file)
							fprintf(dump_file, "weakUpdateFlag = true(lhs.type == DEREF)\n");
					}else if(!strcmp(get_pta_name(var_deref->mustPointsTo), "HEAP")){
						var->weakUpdateFlag = true;
						if(dump_file)
							fprintf(dump_file, "weakUpdateFlag = true(*lhs is HEAP)\n");
					}else{
    						bitmap_clear_bit(workVar, var_deref->mustPointsTo);
						if(var_deref->unknownFlag)
							var->unknownFlag = true;
					}
					if(dump_file)
						fprintf(dump_file, "\n\ncontinuing doing previous analysis\n");


					if(dump_file){
						dump_solution_for_var(dump_file, lhs.var);
						fprintf(dump_file, "\teffective statement(%s:%d):\n", current_function_decl, gimple_lineno(stmt));
						
						dump_stmt_and_constraint(dump_file, stmt, i, c, ALL);
					}

					// *x = *y
					if(rhs.type == DEREF){
						if(rhs.offset == UNKNOWN_OFFSET){
							var->unknownFlag = true;
							bitmap_ior_into(UpdatedTo, get_pta_solution (rhs.var));	
							bitmap_and_into(UpdatedTo, get_pta_solution(var->id));
//							bitmap_xor_into(To, UpdatedTo);
							gcc_assert(0);
						}else if(rhs.offset != 0){
							if(dump_file)
								fprintf(dump_file, "\tnot support yet(rhs.offset!=0, '*x=*y'): offset = %ld\n", rhs.offset);
							gcc_assert(0);
						}else{
							if(dump_file)
								fprintf(dump_file, "not test yet\n");
							rhs_deref = get_pta_solution (rhs.var);
							EXECUTE_IF_IN_NONNULL_BITMAP (rhs_deref, 0, j, bi){
								if(bitmap_intersect_p(get_pta_solution (j), get_pta_solution(var->id))){
									bitmap_set_bit(workVar, j);
								}
							}
							gcc_assert(0);
						}
					// *x = &y
					}else if(rhs.type == ADDRESSOF){
						if(dump_file)
							fprintf(dump_file, "(*x=&y)\n");
//kkk						bitmap_clear_bit(To, rhs.var);
						bitmap_set_bit(UpdatedTo, rhs.var);
						
						gcc_assert(0);
					// *x = y
					}else{	// rhs.type == SCALAR
						if(rhs.offset == UNKNOWN_OFFSET){
							if(dump_file)
								fprintf(dump_file, "\trhs.offset = UNKNOWN\n", rhs.offset);
							if(bitmap_intersect_p(get_pta_solution(rhs.var), get_pta_solution(var->id))){
								var->unknownFlag = true;
								bitmap_set_bit(workVar, rhs.var);
								dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
							}
						}else if(rhs.offset != 0){
							struct variable_info *v = get_varinfo (rhs.var);
							HOST_WIDE_INT fieldoffset = v->offset + rhs.offset;

							if (v->is_full_var)
								fieldoffset = v->offset;
							v = first_vi_for_offset (v, fieldoffset);
							// If the access is outside of the variable we can ignore it. //
							if (v){
								dump_solution_for_var(dump_file, v->id);
								if(bitmap_intersect_p(get_pta_solution(v->id), get_pta_solution(var->id))){
									bitmap_set_bit(workVar, v->id);
									dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
								}
							}
						}else{
							if(bitmap_intersect_p(get_pta_solution(rhs.var), get_pta_solution(var->id))){
								bitmap_set_bit(workVar, rhs.var);
								dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
							}
						}
					}
				}
				BITMAP_FREE(var_deref->UpdatedTo);
				free(var_deref);
			}

		}else if(lhs.type == ADDRESSOF){
			if(dump_file)
				fprintf(dump_file, "impossible\n");
			gcc_assert(0);
		}else{	// lhs.type == SCALAR    x = ?
			if(lhs.offset == UNKNOWN_OFFSET){
				var->unknownFlag = true;
			}else if(lhs.offset != 0){
				struct variable_info *v = get_varinfo (lhs.var);
				HOST_WIDE_INT fieldoffset = v->offset + lhs.offset;

				if (v->is_full_var)
					fieldoffset = v->offset;
				v = first_vi_for_offset (v, fieldoffset);
				/* If the access is outside of the variable we can ignore it.  */
				if (!v){
					if(dump_file)
						fprintf(dump_file, "outside of the variable\n");
					lhs.var = 0;
				}else{
					lhs.var = v->id;
				}
			}

			if(bitmap_bit_p(workVar, lhs.var)){
				if(dump_file){
				  fprintf(dump_file, "\teffective statement(%s:%d):\n", current_function_decl, gimple_lineno(stmt));
					dump_stmt_and_constraint(dump_file, stmt, i, c, ALL);
				}

				enum gimple_code stmt_code = gimple_code (stmt);
   				tree op0;
				enum tree_code code;
				if(stmt_code == GIMPLE_ASSIGN){
					op0 = gimple_assign_lhs (stmt);
					code = TREE_CODE(op0);
				}else if(stmt_code == GIMPLE_CALL){
					op0 = gimple_call_lhs (stmt);
					if(op0)
						code = TREE_CODE(op0);
					else
						code = SSA_NAME;
				}else if(stmt_code == GIMPLE_RETURN){
				  op0 = gimple_return_retval (stmt);
				  // if(op0)
				    code = SSA_NAME;
				}else{
					print_gimple_stmt(stderr, stmt, 0, 0);
					print_tree_code(stderr, op0);
					gcc_assert(0);
				}
				if(code == ARRAY_REF || code == COMPONENT_REF || code == MEM_REF){
				}else if(code == SSA_NAME){
					bitmap_clear_bit(workVar, lhs.var);
				}else{
				  /*					print_gimple_stmt(stderr, stmt, 0, 0);
					print_tree_code(stderr, op0);
					gcc_assert(0);
				  */
				}

				if(lhs.offset != 0){
					if(dump_file)
						fprintf(dump_file, "\tnot support yet(lhs.offset!=0, x = ?): offset = %ld\n", lhs.offset);
					gcc_assert(0);
				}else{
					// x = *y
					if(rhs.type == DEREF){
						if(rhs.offset == UNKNOWN_OFFSET){
							var->unknownFlag = true;
						}else if(rhs.offset != 0){
							struct variable_info *v = get_varinfo (rhs.var);
							HOST_WIDE_INT fieldoffset = v->offset + rhs.offset;

							if (v->is_full_var)
								fieldoffset = v->offset;
							v = first_vi_for_offset (v, fieldoffset);
							// If the access is outside of the variable we can ignore it. //
							if (!v)
								rhs.var = 0;
							else
								rhs.var = v->id;
							if(dump_file)
								fprintf(dump_file, "\tbaseID = %s(%d)\n", get_pta_name(v->id), v->id);
						}
						rhs_deref = get_pta_solution (rhs.var);
						bool effectFlag = false;
						EXECUTE_IF_IN_NONNULL_BITMAP (rhs_deref, 0, j, bi){
							if(bitmap_intersect_p(get_pta_solution (j), get_pta_solution(var->id))){
								effectFlag = true;
								break;
							}
						}
						if(effectFlag == true){
							struct TraceVar *var_deref;
							var_deref = get_more_accurate_deref(node, &(c->rhs), gsi, mode, var->list_node);
							if(rollBackFlag == true){
								bitmap_clear(workVar);
								bitmap_clear(var->workVar);
							}
							if(!has_exact_pointsto(var_deref->mustPointsTo)){
//								var->mustAliasFlag = false;
								if(var_deref->weakUpdateFlag == true){
									var->weakUpdateFlag = true;
									if(dump_file)
										fprintf(dump_file, "weakUpdateFlag = true(x = *y)\n");
								}
							}else{
								if(var_deref->unknownFlag)
									var->unknownFlag = true;
							}
							rhs_deref = var_deref->UpdatedTo;
							if(dump_file)
								fprintf(dump_file, "\n\ncontinuing doing previous analysis\n");
							EXECUTE_IF_IN_NONNULL_BITMAP (rhs_deref, 0, j, bi){
								if(bitmap_intersect_p(get_pta_solution (j), get_pta_solution(var->id))){
									bitmap_set_bit(workVar, j);
								}
							}
							BITMAP_FREE(var_deref->UpdatedTo);
							free(var_deref);

						}else{
//							var->mustAliasFlag = false;
						}
					// x = &y
					}else if(rhs.type == ADDRESSOF){
						bitmap_set_bit(UpdatedTo, rhs.var);
						dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
						dump_bitmap_elements(dump_file, UpdatedTo, '{', "\t\tUpdatedTo", '}');
					// x = y
					}else{	// rhs.type == SCALAR
						if(rhs.offset == UNKNOWN_OFFSET){
							var->unknownFlag = true;
							if(dump_file)
								fprintf(dump_file, "\trhs.offset = UNKNOWN\n", rhs.offset);
							//gcc_assert(bitmap_intersect_p(get_pta_solution(rhs.var), get_pta_solution(var->id)));
							if(bitmap_intersect_p(get_pta_solution(rhs.var), get_pta_solution(var->id))){
								bitmap_set_bit(workVar, rhs.var);
								dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
							}
						}else if(rhs.offset != 0){
							struct variable_info *v = get_varinfo (rhs.var);
							HOST_WIDE_INT fieldoffset = v->offset + rhs.offset;

							if (v->is_full_var)
								fieldoffset = v->offset;
							v = first_vi_for_offset (v, fieldoffset);
							// If the access is outside of the variable we can ignore it. //
							if (v){
								if(dump_file)
									fprintf(dump_file, "\trhs.offset = %ld\n", rhs.offset);
								dump_solution_for_var(dump_file, v->id);
								//gcc_assert(bitmap_intersect_p(get_pta_solution(v->id), get_pta_solution(var->id)));
								if(bitmap_intersect_p(get_pta_solution(rhs.var), get_pta_solution(var->id))){
									bitmap_set_bit(workVar, v->id);
									dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
								}
							}
						}else{
							//gcc_assert(bitmap_intersect_p(get_pta_solution(rhs.var), get_pta_solution(var->id)));
							if(bitmap_intersect_p(get_pta_solution(rhs.var), get_pta_solution(var->id))){
								bitmap_set_bit(workVar, rhs.var);
								dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
							}
						}
					}
				}
			}

		}
		// special treatment for global initialized variables //
		bitmap_clear_bit(workVar, nothing_id);
		bitmap_clear_bit(workVar, anything_id);
		bitmap_clear_bit(workVar, readonly_id);
		bitmap_clear_bit(workVar, escaped_id);
		bitmap_clear_bit(workVar, nonlocal_id);
		bitmap_clear_bit(workVar, storedanything_id);
		bitmap_clear_bit(workVar, integer_id);
	}
}

static inline bool 
is_indirect_call(gimple stmt){
	if(is_gimple_call(stmt))
		if(TREE_CODE(gimple_call_fn(stmt)) == SSA_NAME)
			return true;
	return false;
}

static bool 
solve_call_stmt(gimple_stmt_iterator gsi, bitmap workVar, struct variable_info *callee_vi, bool flag){
	int i;
	bool return_do_flag = false;
	gimple stmt = gsi_stmt(gsi);
	if(dump_file){
		fprintf(dump_file, "\tstatement with function pointer:\n");
		dump_stmt_and_constraint(dump_file, stmt, 0, NULL, STMT);
	}
	for (i = gsi.ptr->constraints_end-1; i >= gsi.ptr->constraints_start; i--){
		struct constraint_expr lhs, rhs;
		struct constraint *c;

		c = &all_constraints[i];
		dump_stmt_and_constraint(dump_file, stmt, i, c, CONSTRAINTS);
		lhs = c->lhs;
		rhs = c->rhs;
		if(lhs.type == DEREF && lhs.offset >= fi_parm_base && rhs.type == SCALAR && rhs.offset == 0){
			if(flag == AFTER){
				struct variable_info *vi_args;
				gcc_assert(callee_vi);
				vi_args = find_varinfo_for_func(callee_vi, lhs.offset);
				if(vi_args != NULL){
					if(dump_file)
						fprintf(dump_file, "!!! vi_args->id = %s(%d)\n", get_pta_name(vi_args->id), vi_args->id);
					if(bitmap_bit_p(workVar, vi_args->id)){
						bitmap_clear_bit(workVar, vi_args->id);
						bitmap_set_bit(workVar, rhs.var);
						if(dump_file){

						  fprintf(dump_file, "\teffective statement(%s:%d):\n", current_function_decl, gimple_lineno(stmt));
							dump_stmt_and_constraint(dump_file, stmt, i, c, ALL);
							dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
						}
					}
				}
			}
		}else if(lhs.type == SCALAR && lhs.offset == 0 && rhs.type == DEREF && rhs.offset == fi_result){
			if(flag == BEFORE){
				if(bitmap_bit_p(workVar, lhs.var)){
					bitmap_clear_bit(workVar, lhs.var);
					return_do_flag = true;
					if(dump_file){
					  fprintf(dump_file, "\teffective statement(%s:%d):\n", current_function_decl, gimple_lineno(stmt));
						dump_stmt_and_constraint(dump_file, stmt, i, c, ALL);
						dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
					}
				}
			}
		}else{
			if(rhs.type == ADDRESSOF && (rhs.var <= integer_id && rhs.var != nothing_id)){
//			if(rhs.type == ADDRESSOF){
				if(lhs.type != SCALAR)
					gcc_assert(0);
				if(bitmap_bit_p(workVar, lhs.var)){
					bitmap_clear_bit(workVar, lhs.var);
					bitmap_set_bit(workVar, rhs.var);
				}
			}else{
				if(dump_file){
					fprintf(dump_file, "ignore: ");	
					dump_stmt_and_constraint(dump_file, stmt, i, c, CONSTRAINTS);
				}
			}
		}
	}
	return return_do_flag;
}

static void
resolve_function_call(struct cgraph_node *node, struct cgraph_node *new_node, struct function *func, struct variable_info *vi, gimple_stmt_iterator gsi, struct TraceVar *var, struct workBB_func_rep *workFunc, bitmap workVar, enum bootstrap_mode mode) {
	struct variable_info *vi_return;
	struct variable_info *vi_clobbers;
	bitmap UpdatedTo;
	gimple stmt = gsi_stmt(gsi);
	bitmap func_clobbers;

	UpdatedTo = var->UpdatedTo;
	vi_return = find_varinfo_for_func(vi, fi_result);
	if(vi_return){
		if(bitmap_bit_p(workVar, vi_return->id)){
			if(dump_file){
				fprintf(dump_file, "\n\teffective function(%s):\n", cgraph_node_name(new_node));
				dump_stmt_and_constraint(dump_file, stmt, 0, NULL, STMT);
				fprintf(dump_file, "\t\t");
				dump_solution_for_var(dump_file, vi_return->id);
			}
			if(mode == CALLEE_OFF_CALLER_ON || mode == CALLEE_OFF_CALLER_OFF){
				var->mustAliasFlag = false;
				var->weakUpdateFlag = true;
				if(dump_file)
					fprintf(dump_file, "weakUpdateFlag = true (return)\n");
				bitmap_clear_bit(workVar, vi_return->id);
				bitmap_ior_into(UpdatedTo, find_solution_for_func(vi, fi_result));	
				bitmap_and_into(UpdatedTo, get_pta_solution(var->id));
//				bitmap_xor_into(To, UpdatedTo);
				dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
				dump_bitmap_elements(dump_file, UpdatedTo, '{', "\t\tUpdatedTo", '}');		
			}else{	// CALLEE_ON
				gcc_assert(workFunc != NULL);
				if(bitmap_ior_into(workFunc[new_node->uid].exit_old_workVar, workVar)){
					bitmap workVar_ptr = var->workVar;
					if(dump_file)
						fprintf(dump_file, "\n*** Entering the fucntion %s:\n", cgraph_node_name (new_node));
					var->workVar = workVar;
					push_cfun (func);
					gimple_stmt_iterator new_gsi = gsi_last_bb(EXIT_BLOCK_PTR_FOR_FUNCTION(func));
#if(USE_LIST_NODE)
					list_node_push(var->list_node, stmt);
					//					dump_list_node(stderr, var->list_node);
#endif
					bootstrap_caller_off(new_node, new_gsi, var, workFunc, false, mode);
#if(USE_LIST_NODE)
					gimple tmp;
					list_node_pop(var->list_node, tmp);
					//					dump_list_node(stderr, var->list_node);
#endif

					var->workVar = workVar_ptr;
					pop_cfun ();
					if(dump_file)
						fprintf(dump_file, "\n*** Back to the fucntion %s:", cgraph_node_name (node));
					// scan the constraints again to finish this statement of function //
					if(!rollBackFlag){
						if(is_indirect_call(stmt))
							solve_call_stmt(gsi, workVar, vi, AFTER);
						else
							solve_simple_stmt(node, gsi, var, workVar, mode);
					}
					return;
				}
			}
		}
	}

	func_clobbers = find_solution_for_func(vi, fi_clobbers);
	vi_clobbers = find_varinfo_for_func(vi, fi_clobbers);
	if(vi_clobbers){
		bitmap_iterator bi;
		unsigned int i;

		bitmap tmp = BITMAP_ALLOC(&workVar_obstack);
		bitmap_and(tmp, get_pta_solution(vi_clobbers->id), workVar);
#if(ONLY_BT4 == false)
		if(!bitmap_empty_p(tmp)){
#endif
			if(dump_file)
				fprintf(dump_file, "\n\teffective function(%s):\n", cgraph_node_name(new_node));
			dump_stmt_and_constraint(dump_file, stmt, 0, NULL, STMT);
			if(mode == CALLEE_OFF_CALLER_ON || mode == CALLEE_OFF_CALLER_OFF){
				var->mustAliasFlag = false;
				var->weakUpdateFlag = true;
				if(dump_file)
					fprintf(dump_file, "weakUpdateFlag = true (clobbers)\n");
				if(dump_file)
					fprintf(dump_file, "\t\t!!! clobbers check !!! ");
				dump_solution_for_var(dump_file, vi_clobbers->id);
				bitmap_xor_into(workVar, tmp);
				EXECUTE_IF_IN_NONNULL_BITMAP (tmp, 0, i, bi){
					bitmap_ior_into(UpdatedTo, get_pta_solution (i));
				}
				bitmap_and_into(UpdatedTo, get_pta_solution(var->id));
			}else{	// CALLEE_ON
				if(bitmap_ior_into(workFunc[new_node->uid].exit_old_workVar, workVar)){
					bitmap workVar_ptr = var->workVar;
					if(dump_file)
						fprintf(dump_file, "\n*** Entering the fucntion %s:\n", cgraph_node_name (new_node));
					//fixed bug: var->workVar = workVar;
					var->workVar = workVar;
					push_cfun (func);
					gimple_stmt_iterator new_gsi = gsi_last_bb(EXIT_BLOCK_PTR_FOR_FUNCTION(func));
#if(USE_LIST_NODE)
					list_node_push(var->list_node, stmt);
					// 					dump_list_node(stderr, var->list_node);
#endif
					bootstrap_caller_off(new_node,	new_gsi, var, workFunc, false, mode);
#if(USE_LIST_NODE)
					gimple tmp;
					list_node_pop(var->list_node, tmp);
					//					dump_list_node(stderr, var->list_node);
#endif

					var->workVar = workVar_ptr;
					pop_cfun ();
					if(dump_file)
						fprintf(dump_file, "\n*** Back to the fucntion %s:", cgraph_node_name (node));
					// scan the constraints again to finish this statement of function //
					if(!rollBackFlag){
						if(is_indirect_call(stmt))
							solve_call_stmt(gsi, workVar, vi, AFTER);
						else
							solve_simple_stmt(node, gsi, var, workVar, mode);
					}
				}
			}
#if(ONLY_BT4 == false)
		}
#endif
		BITMAP_FREE(tmp);
	}
}

static void 
scan_stmt(struct cgraph_node *node, gimple_stmt_iterator gsi, struct TraceVar *var, struct workBB_func_rep *workFunc, bitmap workVar, enum bootstrap_mode mode) {
	int i;
	gimple stmt;
	struct constraint *c;
	bitmap UpdatedTo;
	
	UpdatedTo = var->UpdatedTo;
	stmt = gsi_stmt(gsi);
	
//dump_stmt_and_constraint(dump_file, stmt, 0, NULL, STMT);
	if (gimple_code (stmt) == GIMPLE_PHI){
		bool workFlag = false;
		bitmap clearSet = BITMAP_ALLOC(&workVar_obstack);

		for (i = gsi.ptr->constraints_start; i < gsi.ptr->constraints_end; i++){
			struct constraint_expr lhs, rhs;
			c = &all_constraints[i];
			lhs = c->lhs;
			rhs = c->rhs;

			if(lhs.type == DEREF){
				// TODO: skip //
//				print_gimple_stmt(dump_file, stmt, 0, 0);
				if(dump_file)
					fprintf(dump_file, "Not support yet for the phi statement that is DEREF type in lhs.\n");
				dump_stmt_and_constraint(dump_file, stmt, i, c, ALL);
				gcc_assert(0);
			}else if(lhs.type == ADDRESSOF){
				if(dump_file)
					fprintf(dump_file, "impossible\n");
				gcc_assert(0);
			}else if(lhs.type != SCALAR){
				if(dump_file)
					fprintf(dump_file, "!!!??? %d\n", lhs.type);
				gcc_assert(0);
			}

			if(bitmap_bit_p(workVar, lhs.var)){
				workFlag = true;
//				var->mustAliasFlag = false;
				bitmap_set_bit(clearSet, lhs.var);
				if(dump_file)
					fprintf(dump_file, "\n\teffective phi statement:\n");
				dump_stmt_and_constraint(dump_file, stmt, i, c, ALL);
				if(rhs.type == SCALAR){
					if(bitmap_intersect_p( get_pta_solution(rhs.var), get_pta_solution(var->id))){
						bitmap_set_bit(workVar, rhs.var);
						dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
					}
				}else if(rhs.type == ADDRESSOF){
					bitmap_set_bit(UpdatedTo, rhs.var);
					dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
					dump_bitmap_elements(dump_file, UpdatedTo, '{', "\t\tUpdatedTo", '}');
				}else{
					if(dump_file)
						fprintf(dump_file, "Not support yet for the phi statement that is DEREF type in rhs.\n");
					gcc_assert(0);
				}
			}
		}
		bitmap_xor_into(workVar, clearSet);
		if(workFlag)
			dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');

		BITMAP_FREE(clearSet);
		return;
	}

	bool return_do_flag = false;
	// Do not do solve_simple_stmt if it is an indirect call //
	if(!is_gimple_call (stmt))
		solve_simple_stmt(node, gsi, var, workVar, mode);
	else if(TREE_CODE(gimple_call_fn(stmt)) != SSA_NAME) // is not an indirect call
		solve_simple_stmt(node, gsi, var, workVar, mode);
	else{	// is an indirect call
		return_do_flag = solve_call_stmt(gsi, workVar, NULL, BEFORE);
	}


	// Check if the statement is a function call after scanning the constraints
	if(is_gimple_call (stmt) && !rollBackFlag){
		struct function *func;
		struct cgraph_node *new_node;
		struct variable_info *vi, *new_vi, *vi_return;
		bitmap pta = NULL;
		tree fndecl;
		
		// indirect call //
		if(is_indirect_call(stmt)){
			fndecl = gimple_call_fn(stmt);
			bitmap old_workVar = BITMAP_ALLOC(&workVar_obstack);
			bitmap new_workVar = BITMAP_ALLOC(&workVar_obstack);
			bitmap_copy(old_workVar, workVar);
			vi = lookup_vi_for_tree(fndecl);
			if(vi){
				pta = get_pta_solution(vi->id);
				//gcc_assert(0);
				for (new_node = cgraph_nodes; new_node && !rollBackFlag; new_node = new_node->next) {
					new_vi = lookup_vi_for_tree(new_node->decl);
					if(new_vi){
						if (bitmap_bit_p (pta, new_vi->id)) {
							// TODO: set mustAliasFlag = false is too conservative //
							var->mustAliasFlag = false;
							bitmap_copy(workVar, old_workVar);
							if(dump_file)
								fprintf(dump_file, "indirect call (%s)->(%s)\n", cgraph_node_name(node), cgraph_node_name(new_node));
							func = DECL_STRUCT_FUNCTION (new_node->decl);
							if(return_do_flag == true){
								vi_return = find_varinfo_for_func(new_vi, fi_result);
								if(!vi_return)
									gcc_assert(0);
								bitmap_set_bit(workVar, vi_return->id);
							}
							resolve_function_call(node, new_node, func, new_vi, gsi, var, workFunc, workVar, mode);
							bitmap_ior_into(new_workVar, workVar);
						}
					}
				}
				bitmap_copy(workVar, new_workVar);
			}else{
				if(dump_file)
					fprintf(dump_file, "Not sure at all.\n");
//				gcc_assert(0);
			}
			BITMAP_FREE(old_workVar);
			BITMAP_FREE(new_workVar);

			// direct call //
		}else{
			fndecl = gimple_call_fndecl (stmt);
			new_node = cgraph_node(fndecl);
			vi = lookup_vi_for_tree(fndecl);
			func = DECL_STRUCT_FUNCTION (fndecl);
			resolve_function_call(node, new_node, func, vi, gsi, var, workFunc, workVar, mode);
		}
	}
}

static void 
scan_bb(struct cgraph_node *node, gimple_stmt_iterator gsi, struct TraceVar *var, struct workBB_func_rep * workFunc, bitmap workVar, enum bootstrap_mode mode) {
	basic_block bb = gsi.bb;
	edge e;
	edge_iterator ei;

	bitmap old_workVar = BITMAP_ALLOC(&workVar_obstack);
	bitmap old_UpdatedTo = BITMAP_ALLOC(&workVar_obstack);
	bitmap_copy(old_workVar, workVar);
	bitmap_copy(old_UpdatedTo, var->UpdatedTo);


//	if(dump_file)
//		fprintf (dump_file, "\n<basic block %d, loop depth %d>\n", bb->index, bb->loop_depth);

	if (dump_file && (dump_flags & TDF_DETAILS)){
		fprintf (dump_file, "\tBB: Predecessors: ");
		FOR_EACH_EDGE (e, ei, bb->preds)
			dump_edge_info (dump_file, e, 0);
		fprintf (dump_file, "\n");
		dump_bitmap_elements(dump_file, workVar, '[', "\t\tworkVar", ']');
		dump_bitmap_elements(dump_file, var->UpdatedTo, '{', "\t\tUpdatedTo", '}');

	}

	for(/*gsi = gsi_last_bb(bb)*/; !gsi_end_p (gsi)/* && !bitmap_empty_p(workVar)*/; gsi_prev (&gsi) ){
		if(rollBackFlag == true){
			bitmap_clear(var->workVar);
			bitmap_clear(workVar);
		}
		scan_stmt(node, gsi, var, workFunc, workVar, mode);
	}

    for (gsi = gsi_last (phi_nodes (bb)); !gsi_end_p (gsi); gsi_prev (&gsi)) {
		if(rollBackFlag == true){
			bitmap_clear(var->workVar);
			bitmap_clear(workVar);
		}

		gimple phi = gsi_stmt (gsi);
		//print_gimple_stmt(dump_file, phi, 0, 0);
		if (is_gimple_reg (gimple_phi_result (phi))){
			scan_stmt(node, gsi, var, workFunc, workVar, mode);
		}
	}

	if (dump_file && (dump_flags & TDF_DETAILS)){
		if(bitmap_equal_p(old_workVar, workVar)){
			fprintf (dump_file, "\t### %-11s: no changed ###\n", "workVar");
		}else{
			dump_bitmap_elements(dump_file, workVar, '[', "\t### workVar", ']');
		}

		if(bitmap_equal_p(old_UpdatedTo, var->UpdatedTo)){
			fprintf (dump_file, "\t### %-11s: no changed ###\n", "UpdatedTo");
		}else{
			dump_bitmap_elements(dump_file, var->UpdatedTo, '{', "\t### UpdatedTo", '}');
		}
	}

	BITMAP_FREE(old_workVar);
	BITMAP_FREE(old_UpdatedTo);
}

static void 
max_heapify(struct workBB_func_rep **queue, int i, int heap_size) {
	int left, right, largest;
	struct workBB_func_rep *tmp;
	left = HEAP_LEFT(i);
	right = HEAP_RIGHT(i);
	if(left <= heap_size-1 && queue[left]->depth > queue[i]->depth)
		largest = left;
	else
		largest = i;
	if(right <= heap_size-1 && queue[right]->depth > queue[largest]->depth)
		largest = right;
	if(largest != i){
		tmp = queue[i]; queue[i] = queue[largest]; queue[largest] = tmp;
		max_heapify(queue, largest, heap_size);
	}
}

static void 
queue_insert(struct workBB_func_rep **queue, struct workBB_func_rep *item, int *heap_size) {
	int index;
	struct workBB_func_rep *tmp;

	if(item->inQueue == false){
		queue[*heap_size] = item;
		index = *heap_size;
		while(index > 0 && queue[HEAP_PARENT(index)]->depth < queue[index]->depth){
			tmp = queue[index]; queue[index] = queue[HEAP_PARENT(index)]; queue[HEAP_PARENT(index)] = tmp;
			index = HEAP_PARENT(index);
		}
		(*heap_size) ++;
	}
	item->inQueue = true;
}

static struct workBB_func_rep *
queue_extract_max(struct workBB_func_rep **queue, int *heap_size) {
	struct workBB_func_rep *max;
	if(*heap_size < 1)
		return NULL;
	max = queue[0];
	queue[0] = queue[*heap_size-1];
	(*heap_size) --;
	max_heapify(queue, 0, *heap_size);
	max->inQueue = false;
	return max;
}

// calcualte dom_depth for each bb of the function //
static int
calculate_dom_depth(struct cgraph_node *node) {
	int max_index = 0;
	VEC(basic_block, heap) *bbs = NULL;
	unsigned i;
	basic_block bb, start_bb;
	int depth = 0;
	unsigned next_level_start;

	unsigned int dir = CDI_DOMINATORS - 1;
	struct function *func = DECL_STRUCT_FUNCTION (node->decl);

	start_bb = ENTRY_BLOCK_PTR_FOR_FUNCTION(func)->next_bb;
//	if(dump_file)
//		fprintf (dump_file, "%s's dominator tree:\n", cgraph_node_name (node));
	calculate_dominance_info (CDI_DOMINATORS);

	bb = start_bb;
	i = 0;
	VEC_safe_push (basic_block, heap, bbs, bb);
	next_level_start = 1; /* = VEC_length (basic_block, bbs); */
	bb->dom[dir]->depth = depth++;
	//fprintf(dump_file, "<bb %d>: depth %d\n", bb->index, bb->dom[dir]->depth);

	do{
		basic_block son;
		bb = VEC_index (basic_block, bbs, i++);
		//fprintf(dump_file, "<bb %d> : depth %d\n", bb->index, bb->dom[dir]->depth);
		for (son = first_dom_son (CDI_DOMINATORS, bb); son; son = next_dom_son (CDI_DOMINATORS, son)){
			son->dom[dir]->depth = depth;
			//fprintf(dump_file, "        => <bb %d>: depth %d\n", son->index, son->dom[dir]->depth);
			VEC_safe_push (basic_block, heap, bbs, son);
		}

		if (i == next_level_start){
			next_level_start = VEC_length (basic_block, bbs);
			depth ++;
		}
	}
	while (i < next_level_start);

	VEC_free(basic_block, heap, bbs);

	dump_dominator_tree(dump_file, start_bb, depth);

	FOR_EACH_BB_FN (bb, func){
		if(bb->index > max_index)
			max_index = bb->index;
	}
	return max_index;
}

static struct CallList *
create_new_call_site(struct workBB_func_rep *currentFunc, struct TraceVar *var, gimple call_stmt, struct cgraph_node *calleeNode){
	struct CallList *callSite;
	callSite = XNEW(struct CallList);
	callSite->var = XNEW(struct TraceVar);
	*(callSite->var) = *var;
#if(USE_LIST_NODE)
	callSite->var->list_node = NULL;
	list_node_copy(callSite->var->list_node, var->list_node);
#endif
	callSite->var->workVar = BITMAP_ALLOC(&workVar_obstack);
	bitmap_copy(callSite->var->workVar, var->workVar);
	callSite->call_stmt = call_stmt;
	//fprintf(dump_file, "prepare %p:\n", &callSite->var->workVar);
	//dump_bitmap_elements(dump_file, callSite->var->workVar, '[', "!!! workVar", ']');
	VEC_safe_push(CallList_t, heap, currentFunc->callList, callSite);
	callSite->calleeNode = calleeNode;

	return callSite;
}

release_call_site(CallList_t callSite){
#if(USE_LIST_NODE)
  list_node_free(callSite->var->list_node);
#endif

	BITMAP_FREE(callSite->var->workVar);
	free(callSite->var);
	free(callSite);
}

static unsigned int 
find(unsigned int rep, struct disjointedSet *array){
	if(array[rep].rep != rep){
		return array[rep].rep = find(array[rep].rep, array);
	}else{
		return rep;
	}
}

static unsigned int 
unite(unsigned int root, unsigned int from, struct disjointedSet *array){
	struct resultInfo *head;
	struct resultInfo *tail;
	if(root != from){
		if(array[root].head == NULL){
			head = array[from].head;
			tail = array[from].tail;
		}else{
			head = array[root].head;
			if(array[from].tail == NULL){
				tail = array[root].tail;
			}else{
				(array[root].tail)->next = array[from].head;
				array[root].tail = array[from].tail;
			}
		}
		array[from].rep = root;
	}
	return root;
}

// check if a contains in b //
static inline bool
bitmap_contains_in(bitmap a, bitmap b){
	bitmap tmp = BITMAP_ALLOC(&workVar_obstack);
	bitmap_and(tmp, a, b);
	if(bitmap_equal_p(tmp, a)){
		BITMAP_FREE(tmp);
		return true;
	}else{
		BITMAP_FREE(tmp);
		return false;
	}
}
#if(USE_PRE_RESULT)
struct preList *
add_to_result_list(struct cgraph_node *checkNode, struct TraceVar *var){
	int i, j;
	struct disjointedSet *preResult;
	struct resultInfo *info;
	struct resultInfo *info_tmp;
	unsigned int root = 0;
	bool try_again = false;
	bitmap old_UpdatedTo = BITMAP_ALLOC(&workVar_obstack);
	bitmap after_workVar = BITMAP_ALLOC(&workVar_obstack);
	bitmap test_workVar = BITMAP_ALLOC(&workVar_obstack);
	bitmap acc_workVar = BITMAP_ALLOC(&workVar_obstack);

	

	if(dom[checkNode->uid].preResult == NULL){
		dom[checkNode->uid].preResult = XCNEWVEC(struct disjointedSet, var_range);
	}
	preResult = dom[checkNode->uid].preResult;

	bitmap_iterator bi;
	root = 0;
	unsigned int from;
	EXECUTE_IF_IN_NONNULL_BITMAP (var->workVar, 0, i, bi){
		if(preResult[i].rep == 0){
			preResult[i].rep = i;
		}
		if(root == 0){
			root = find(i, preResult);
			if(root > var_range){
				gcc_assert(0);
			}
		}else{
			from = find(i, preResult); 
			if(from > var_range){
				gcc_assert(0);
			}
			root = unite(root, from, preResult);
		}
	}

	for(info = preResult[root].head; info; info = info->next){
		if(var->mustAliasFlag == true){
			if(bitmap_equal_p(info->before_workVar, var->workVar)){
				if(info->mustPointsTo != TRY_AGAIN){
				//if(has_exact_pointsto(info->mustPointsTo)){
					var->mustPointsTo = info->mustPointsTo;	
//					gcc_assert(bitmap_single_bit_set_p(info->before_workVar));
					bitmap_ior_into(after_workVar, info->after_workVar);
					bitmap_ior_into(var->UpdatedTo, info->UpdatedTo);
					bitmap_ior_into(acc_workVar, info->before_workVar);
				}else{
					try_again = true;
				}
				break;
			}
		}else{
			bitmap_and(test_workVar, info->before_workVar, var->workVar);
			if(bitmap_equal_p(info->before_workVar, test_workVar)){
				bitmap_ior_into(after_workVar, info->after_workVar);
				bitmap_ior_into(var->UpdatedTo, info->UpdatedTo);
				bitmap_ior_into(acc_workVar, info->before_workVar);
				if(bitmap_equal_p(var->workVar, acc_workVar))
					break;
			}
		}
	}
	bitmap_xor_into(var->workVar, acc_workVar);
	BITMAP_FREE(acc_workVar);
	if(bitmap_empty_p(var->workVar)){
		bitmap_copy(var->workVar, after_workVar);
		if(dump_file){
			fprintf(dump_file, "\nresult:\n");
			fprintf (dump_file, "\t### workVar = { ");
			dump_bitmap_var(dump_file, var->workVar);
			fprintf (dump_file, "} ###\n");
			fprintf (dump_file, "\t### UpdatedTo = { ");
			dump_bitmap_var(dump_file, var->UpdatedTo);
			fprintf (dump_file, "} ###\n");
			fprintf(dump_file, "\t### mustAlias.id = %s(%d)\n", get_pta_name (var->mustAlias.id), var->mustAlias.id);
			if(var->mustPointsTo == UNKNOWN)
				fprintf(dump_file, "\t### mustPointsTo = UNKNOWN\n");
			else if(var->mustPointsTo == MAY_INFO)
				fprintf(dump_file, "\t### mustPointsTo = MAY_INFO\n");
			else
				fprintf(dump_file, "\t### mustPointsTo = %s(%d)\n", get_pta_name (var->mustPointsTo), var->mustPointsTo);
		}
		BITMAP_FREE(old_UpdatedTo);
		BITMAP_FREE(after_workVar);
		BITMAP_FREE(test_workVar);
		return NULL;
	}

	struct preList *element = XNEW(struct preList);

	if(try_again == false){
		//gcc_assert(info == NULL);
		info_tmp = XNEW(struct resultInfo);
		info_tmp->before_workVar = BITMAP_ALLOC(NULL);
		info_tmp->after_workVar = BITMAP_ALLOC(NULL);
		info_tmp->UpdatedTo = BITMAP_ALLOC(NULL);
		info_tmp->mask = BITMAP_ALLOC(NULL);

//		info = info_tmp;
		bitmap_copy(info_tmp->before_workVar, var->workVar);
		bitmap_copy(info_tmp->mask, var->workVar);
		element->info = info_tmp;
	}else{
		element->info = info;
	}
	bitmap_copy(old_UpdatedTo, var->UpdatedTo);
	bitmap_clear(var->UpdatedTo);
	BITMAP_FREE(test_workVar);

	element->old_UpdatedTo = old_UpdatedTo;
	element->try_again = try_again;
	element->after_workVar = after_workVar;
	element->checkNode = checkNode;
//	element->info = info;
	element->root = root;
	return element;
}
#endif
static inline bool
is_constrained(gimple constrained_call_stmt){
  if(constrained_call_stmt == NULL)
    return false;
  else
    return true;
}

static void
bootstrap_caller_on(struct workBB_func_rep **priority_queue, int *queue_size, struct TraceVar *var, struct workBB_func_rep *workFunc, struct cgraph_node *checkNode, enum bootstrap_mode mode){
	struct cgraph_node *node;
	struct function *func;
	struct cgraph_edge *edge;
	struct workBB_func_rep *currentFunc;
	struct CallList *callSite;
	struct edgeList *list;

	gcc_assert(rollBackFlag == false);
	//gcc_assert(derefDepth == 0);
	VEC(preList_t, heap) *result_list = NULL;

	if(dump_file){
		fprintf(dump_file, "starting with node = %s\n", cgraph_node_name(checkNode));
		dump_bitmap_elements(dump_file, var->workVar, '{', "\t### start_workVar", '}');
		
		fprintf(dump_file, "\t### mustAlias.id = %s(%d)\n", get_pta_name (var->mustAlias.id), var->mustAlias.id);
		fprintf(dump_file, "mustAliasFlag = %d\n", var->mustAliasFlag);
		if(var->mustPointsTo == UNKNOWN)
			fprintf(dump_file, "\t### mustPointsTo = UNKNOWN\n");
		else if(var->mustPointsTo == MAY_INFO)
			fprintf(dump_file, "\t### mustPointsTo = MAY_INFO\n");
		else
			fprintf(dump_file, "\t### mustPointsTo = %s(%d)\n", get_pta_name (var->mustPointsTo), var->mustPointsTo);
	}

#if(USE_LIST_NODE)
	gimple constrained_call_stmt;
	list_node_pop(var->list_node, constrained_call_stmt);
	bool progress = false;
#endif


	#if(USE_PRE_RESULT)

	if(!flag_ipa_no_pre){
#if(USE_LIST_NODE)
	  if(!is_constrained(constrained_call_stmt))
#endif
      {
          struct preList *element;
          element = add_to_result_list(checkNode, var);

          if(element == NULL)
              return;
          else
              VEC_safe_push(preList_t, heap, result_list, element);
      }
	}
	#endif
	
	cnt[mode] ++;


	init_workFunc(workFunc);
	// Put the current function's callers in the queue //
	for(edge = checkNode->callers; edge; edge = edge->next_caller){
#if(USE_LIST_NODE)
		if(constrained_call_stmt != NULL && constrained_call_stmt != edge->call_stmt)
		  continue;
		// find constrained call statement or not constrain at all
		progress = true;
#endif
		currentFunc = &workFunc[edge->caller->uid];
		callSite = create_new_call_site(currentFunc, var, edge->call_stmt, checkNode);
		queue_insert(priority_queue, currentFunc, queue_size);
	}
	
	for(list = checkNode->possibleCaller; list; list = list->next){
#if(USE_LIST_NODE)
		if(constrained_call_stmt != NULL && constrained_call_stmt != list->edge->call_stmt)
		  continue;
		// find constrained call statement or not constrain at all
		progress = true;
#endif

		currentFunc = &workFunc[list->edge->caller->uid];
		callSite = create_new_call_site(currentFunc, var, list->edge->call_stmt, checkNode);
		queue_insert(priority_queue, currentFunc, queue_size);
	}

#if(USE_LIST_NODE)
        // TODO needs to be checked.
//	gcc_assert(progress == true);
#endif

	while(currentFunc = queue_extract_max(priority_queue, queue_size)){
	if(rollBackFlag == false){
		unsigned int tmpMustAlias;
		bool first_callsite = true;
		gimple_stmt_iterator gsi;
		node = (struct cgraph_node *)currentFunc->ptr;
		if(dump_file)
			fprintf(dump_file, "current function (%s):\n", cgraph_node_name(node));
		func = DECL_STRUCT_FUNCTION (node->decl);
		push_cfun(func);

		bitmap_clear(currentFunc->workVar);
		while(!VEC_empty(CallList_t, currentFunc->callList)){
			if(rollBackFlag == false){
				callSite = VEC_pop(CallList_t, currentFunc->callList);
				if(is_indirect_call(callSite->call_stmt)){
					solve_call_stmt(gsi_for_stmt(callSite->call_stmt), callSite->var->workVar, lookup_vi_for_tree(callSite->calleeNode->decl), AFTER); /*kobill*/
				}else{
					solve_simple_stmt(node, gsi_for_stmt(callSite->call_stmt), callSite->var, callSite->var->workVar, mode);
				}
				if(dump_file){
					fprintf(dump_file, "\n\n!!! Call Site:");
					print_gimple_stmt(dump_file, callSite->call_stmt, 0, 0);
					dump_bitmap_elements(dump_file, callSite->var->workVar, '[', "!!! workVar", ']');
				}
				callSite->var->weakUpdateFlag = false;
				gsi = gsi_for_stmt(callSite->call_stmt);
				gsi_prev(&gsi);

				bootstrap_caller_off(node, gsi, callSite->var, workFunc, false, mode);

				gcc_assert(!list_node_compare(callSite->var->list_node, var->list_node));

				if(callSite->var->mustAliasFlag == false)
					var->mustAliasFlag = false;

				if(callSite->var->unknownFlag == true)
					var->unknownFlag = true;

				// if(mustAliasFlag == true) workVar must have exact one element or empty //
				if(callSite->var->mustAliasFlag == true)
					if(bitmap_single_bit_set_p(callSite->var->workVar) || bitmap_empty_p(callSite->var->workVar)){
					}else{
						gcc_assert(0);
					}

				#if(USE_UNSTEABLE)
				unsigned int tmp_id = 0;
				if(callSite->var->mustAliasFlag == true && var->mustAliasFlag == true){
					if(bitmap_single_bit_set_p(callSite->var->workVar))
						tmp_id = bitmap_first_set_bit(callSite->var->workVar);
					else if(bitmap_single_bit_set_p(callSite->var->UpdatedTo))
						tmp_id = bitmap_first_set_bit(callSite->var->UpdatedTo);
					else
						var->mustAliasFlag = false;

					if(first_callsite){
						first_callsite = false;
						tmpMustAlias = tmp_id;
					}else{
						if(tmpMustAlias != tmp_id)
							var->mustAliasFlag = false;
					}
				}
				#endif

			
				if(callSite->var->weakUpdateFlag == true)
					var->weakUpdateFlag = true;
				bitmap_ior_into(currentFunc->workVar, callSite->var->workVar);

				release_call_site(callSite);
			}else{
				callSite = VEC_pop(CallList_t, currentFunc->callList);
				release_call_site(callSite);
			}
		}
		VEC_free(CallList_t, heap, currentFunc->callList);



		// add other call sites to the call list
		bitmap_copy(var->workVar, currentFunc->workVar);
		if(bitmap_ior_into(currentFunc->old_workVar, currentFunc->workVar) && !bitmap_empty_p(currentFunc->workVar)){
			#if(USE_UNSTEABLE)
			if(*queue_size == 0){
				if(var->mustAliasFlag == true){
					if(dump_file)
						fprintf(dump_file, "updating mustAlias\n");
					var->mustAlias.id = tmpMustAlias;
					var->mustAlias.gsi = gsi_last_bb(BASIC_BLOCK(2));
					//var->mustAlias.gsi.bb = EXIT_BLOCK_PTR_FOR_FUNCTION(func);
					var->mustAlias.node = node;
				}
			}
			#endif

#if(USE_LIST_NODE)
			list_node_pop(var->list_node, constrained_call_stmt);
			progress = false;
#endif

			#if(USE_PRE_RESULT)
			if(!flag_ipa_no_pre){
#if(USE_LIST_NODE)
	  if(!is_constrained(constrained_call_stmt))
#endif

			  if(*queue_size == 0){
			    if(var->mustAliasFlag == false){
			      struct preList *element;
			      element = add_to_result_list(node, var);
			      if(element != NULL){
				VEC_safe_push(preList_t, heap, result_list, element);
			      }
			    }
			  }
			}
			#endif

			// Put the current function's callers in the queue //
			for(edge = node->callers; edge; edge = edge->next_caller){
#if(USE_LIST_NODE)
			  if(constrained_call_stmt != NULL && constrained_call_stmt != edge->call_stmt)
			    continue;
			  // find constrained call statement or not constrain at all
			  progress = true;
#endif

				currentFunc = &workFunc[edge->caller->uid];
				callSite = create_new_call_site(currentFunc, var, edge->call_stmt, node);
				queue_insert(priority_queue, currentFunc, queue_size);
			}
			for(list = node->possibleCaller; list; list = list->next){
#if(USE_LIST_NODE)
			  if(constrained_call_stmt != NULL && constrained_call_stmt != list->edge->call_stmt)
			    continue;
			  // find constrained call statement or not constrain at all
			  progress = true;
#endif
				currentFunc = &workFunc[list->edge->caller->uid];
				callSite = create_new_call_site(currentFunc, var, list->edge->call_stmt, node);
				queue_insert(priority_queue, currentFunc, queue_size);
			}
#if(USE_LIST_NODE)
			gcc_assert(progress == true);
#endif

		}

		pop_cfun();
	}else{
		while(!VEC_empty(CallList_t, currentFunc->callList)){
			callSite = VEC_pop(CallList_t, currentFunc->callList);
			release_call_site(callSite);
		}
		VEC_free(CallList_t, heap, currentFunc->callList);
	}
	}

	if(var->mustAliasFlag && bitmap_single_bit_set_p(var->UpdatedTo))
		var->mustPointsTo = bitmap_first_set_bit(var->UpdatedTo);
	else
		var->mustPointsTo = MAY_INFO;

	#if(USE_PRE_RESULT)
	if(!flag_ipa_no_pre){
		struct preList *element;
	int i;
	FOR_EACH_VEC_ELT_REVERSE(preList_t, result_list, i, element){
//	for (i = VEC_length(preList_t, result_list) ; VEC_iterate(preList_t, result_list, i, element); i--){
		struct disjointedSet *preResult = dom[element->checkNode->uid].preResult;
		unsigned int root = element->root;
		struct resultInfo *info = element->info;
		bitmap old_UpdatedTo = element->old_UpdatedTo;
		bitmap after_workVar = element->after_workVar;
		if(rollBackFlag == false && (mode == BOOTSTRAP4 || var->weakUpdateFlag == false)){
			if(element->try_again == false){
				struct resultInfo *info_tmp, *pre_ptr = NULL;
				
				for(info_tmp = preResult[root].head; info_tmp; ){
					if(bitmap_contains_in(info->mask, info_tmp->mask))
						bitmap_xor_into(info_tmp->mask, info->mask);
					// redundency: delete it //
					if(bitmap_empty_p(info_tmp->mask)){
						if(pre_ptr == NULL){
							preResult[root].head = info_tmp->next;
						}else{
							pre_ptr->next = info_tmp->next;
						}
						BITMAP_FREE(info_tmp->before_workVar);
						BITMAP_FREE(info_tmp->after_workVar);
						BITMAP_FREE(info_tmp->UpdatedTo);
						BITMAP_FREE(info_tmp->mask);
						free(info_tmp);
						if(pre_ptr == NULL){
							info_tmp = preResult[root].head;
						}else{
							info_tmp = pre_ptr->next;
						}
						continue;
					}else{
						pre_ptr = info_tmp;
					}
					info_tmp = info_tmp->next;
				}
				info->next = NULL;
				if(preResult[root].head == NULL){
					preResult[root].head = info;
					preResult[root].tail = info;
				}else{
					(preResult[root].tail)->next = info;
					preResult[root].tail = info;
				}
				bitmap_copy(info->after_workVar, var->workVar);
				bitmap_copy(info->UpdatedTo, var->UpdatedTo);
				info->mustPointsTo = var->mustPointsTo;
				if(!has_exact_pointsto(info->mustPointsTo))
					info->mustPointsTo = TRY_AGAIN;
			}else{
				info->mustPointsTo = var->mustPointsTo;
			}
		}else{
			if(element->try_again == false){
				BITMAP_FREE(info->before_workVar);
				BITMAP_FREE(info->after_workVar);
				BITMAP_FREE(info->UpdatedTo);
				BITMAP_FREE(info->mask);
				free(info);
			}
		}
		bitmap_ior_into(var->workVar, after_workVar);
		bitmap_ior_into(var->UpdatedTo, old_UpdatedTo);
		BITMAP_FREE(old_UpdatedTo);
		BITMAP_FREE(after_workVar);
		free(element);
	}
	
	VEC_free(preList_t, heap, result_list);
	}
	#endif

	for(node = cgraph_nodes; node; node = node->next){
		BITMAP_FREE(workFunc[node->uid].workVar);
		BITMAP_FREE(workFunc[node->uid].old_workVar);
		BITMAP_FREE(workFunc[node->uid].exit_old_workVar);
	}
}

inline bool
is_only_one_callSite(gimple stmt){
    int cnt = 0;
    struct cgraph_node *node;
	struct cgraph_edge *edge;
	struct edgeList *list;

    if(is_indirect_call(stmt)){
        return false;
    }else{
        node = cgraph_node(gimple_call_fndecl(stmt));
        for(edge = node->callers; edge; edge = edge->next_caller){
            cnt++;
        }
    }
    if(cnt == 1)
        return true;
    else
        return false;
}
/*
inline void
simplify_callString(VEC(gimple, heap) *callString){
    int i;
    gimple stmt;
    for (i = 0; VEC_iterate(gimple, callString, i, stmt); i++){
        if(is_only_one_callSite(stmt)){
            VEC_block_remove(gimple, callString, 0, 1);
        }else{
            return;
        }
    }
    }*/
#define simplify_callString(des, src){                          \
    int i;                                                      \
    bool skip = true;                                           \
    gimple stmt;                                                \
    for (i = 0; VEC_iterate(gimple, src, i, stmt); i++){        \
        if(is_only_one_callSite(stmt) && skip == true){         \
        }else{                                                  \
            skip = false;                                       \
            VEC_safe_push (gimple, heap, des, stmt);            \
        }                                                       \
    }                                                           \
}                                                               \


static void 
bootstrap_caller_off(struct cgraph_node *node, gimple_stmt_iterator gsi, struct TraceVar *var, struct workBB_func_rep *workFunc, bool finalize, enum bootstrap_mode mode) {
	int max_index;
	struct workBB_func_rep *workBB;
	struct workBB_func_rep **priority_queue;
	int queue_size = 0;
	basic_block bb, storePoint = NULL, start_bb = gsi.bb;
	struct function *func = DECL_STRUCT_FUNCTION (node->decl);

	gcc_assert(rollBackFlag == false);

	#if(USE_POST_RESULT)
	bool skipPostResult;
	bool try_again = false;
	int i, j;
	struct disjointedSet *postResult;
	struct resultInfo *info;
#if(USE_LIST_NODE)
    summary_t entry;
#endif
	unsigned int root = 0;
	bitmap old_UpdatedTo = BITMAP_ALLOC(&workVar_obstack);
	bitmap after_workVar = BITMAP_ALLOC(&workVar_obstack);
	if(!flag_ipa_no_post){
		bitmap test_workVar = BITMAP_ALLOC(&workVar_obstack);
		bitmap acc_workVar = BITMAP_ALLOC(&workVar_obstack);

		if(start_bb->index != EXIT_BLOCK){
			skipPostResult = true;
		}else{
			skipPostResult = false;
		}

        VEC(gimple, heap) *tmp = NULL;
        simplify_callString(tmp, var->list_node);
        if(VEC_length(gimple, tmp) > 4)
            skipPostResult = true;
        
		if(skipPostResult == false){
#if(USE_LIST_NODE)
            postResult = NULL;
            for (i = 0; VEC_iterate(summary_t, dom[node->uid].postHead, i, entry); i++){
                if(!list_node_compare(entry->callString, tmp)){
                    postResult = entry->summary;
                    break;
                }
            }

            if(postResult == NULL){
                entry = XNEW(struct callStringSummary);
                VEC_safe_push(summary_t, heap, dom[node->uid].postHead, entry);
                entry->callString = NULL;
                list_node_copy(entry->callString, tmp);
                entry->summary = XCNEWVEC(struct disjointedSet, var_range);
                postResult = entry->summary;
                entry->size = 0;
            }


#else
			if(dom[node->uid].postResult == NULL){
				dom[node->uid].postResult = XCNEWVEC(struct disjointedSet, var_range);
			}
			postResult = dom[node->uid].postResult;
#endif
			bitmap_iterator bi;
			root = 0;
			EXECUTE_IF_IN_NONNULL_BITMAP (var->workVar, 0, i, bi){
				if(postResult[i].rep == 0){
					postResult[i].rep = i;
				}
				if(root == 0){
					root = find(i, postResult);
				}else{
					root = unite(root, find(i, postResult), postResult);
				}
			}

			if(dump_file){
				fprintf(dump_file, "\nbefore caller_off:\n");
				fprintf (dump_file, "\t### workVar = { ");
				dump_bitmap_var(dump_file, var->workVar);
				fprintf (dump_file, "} ###\n");
				fprintf (dump_file, "\t### UpdatedTo = { ");
				dump_bitmap_var(dump_file, var->UpdatedTo);
				fprintf (dump_file, "} ###\n");
				fprintf(dump_file, "\t### mustAlias.id = %s(%d)\n", get_pta_name (var->mustAlias.id), var->mustAlias.id);
				if(var->mustPointsTo == UNKNOWN)
					fprintf(dump_file, "\t### mustPointsTo = UNKNOWN\n");
				else if(var->mustPointsTo == MAY_INFO)
					fprintf(dump_file, "\t### mustPointsTo = MAY_INFO\n");
				else
					fprintf(dump_file, "\t### mustPointsTo = (%d)\n", var->mustPointsTo);
			}


			for(info = postResult[root].head; info; info = info->next){
				if(var->mustAliasFlag == true){
					if(bitmap_equal_p(info->before_workVar, var->workVar)){
						if(info->mustPointsTo == true && bitmap_single_bit_set_p(info->after_workVar)){
							gcc_assert(bitmap_single_bit_set_p(info->before_workVar));
							bitmap_ior_into(after_workVar, info->after_workVar);
							bitmap_ior_into(var->UpdatedTo, info->UpdatedTo);
							bitmap_ior_into(acc_workVar, info->before_workVar);
							var->mustAlias.id = bitmap_first_set_bit(after_workVar);
							var->mustAlias.gsi = gsi_last_bb(BASIC_BLOCK(2));
							var->mustAlias.node = node;
						}else{
							try_again = true;
						}
						break;
					}
				}else{
					bitmap_and(test_workVar, info->before_workVar, var->workVar);
					if(bitmap_equal_p(info->before_workVar, test_workVar)){
						bitmap_ior_into(after_workVar, info->after_workVar);
						bitmap_ior_into(var->UpdatedTo, info->UpdatedTo);
						bitmap_ior_into(acc_workVar, info->before_workVar);
						if(bitmap_equal_p(var->workVar, acc_workVar))
							break;
					}
				}
			}

			bitmap_xor_into(var->workVar, acc_workVar);

			if(dump_file){
				fprintf(dump_file, "\nbegin caller_off:\n");
				fprintf (dump_file, "\t### workVar = { ");
				dump_bitmap_var(dump_file, var->workVar);
				fprintf (dump_file, "} ###\n");
				fprintf (dump_file, "\t### UpdatedTo = { ");
				dump_bitmap_var(dump_file, var->UpdatedTo);
				fprintf (dump_file, "} ###\n");
			}

			if(bitmap_empty_p(var->workVar)){
				bitmap_copy(var->workVar, after_workVar);
				BITMAP_FREE(old_UpdatedTo);
				BITMAP_FREE(after_workVar);
				BITMAP_FREE(test_workVar);

				return;
			}

			if(try_again == false){
				info = XNEW(struct resultInfo);
				info->before_workVar = BITMAP_ALLOC(NULL);
				info->after_workVar = BITMAP_ALLOC(NULL);
				info->UpdatedTo = BITMAP_ALLOC(NULL);
				info->mask = BITMAP_ALLOC(NULL);

				bitmap_copy(info->before_workVar, var->workVar);
				bitmap_copy(info->mask, var->workVar);
			}
		}
		BITMAP_FREE(acc_workVar);
		BITMAP_FREE(test_workVar);
		bitmap_copy(old_UpdatedTo, var->UpdatedTo);
		bitmap_clear(var->UpdatedTo);

        list_node_free(tmp);                
	}
	#endif

	if(dump_file)
		dump_cgraph_node(dump_file, node);

	if(mode == BOOTSTRAP4 || mode == BOOTSTRAP2)
		cnt[BOOTSTRAP2] ++;
	else
		cnt[BOOTSTRAP1] ++;
	max_index = calculate_dom_depth(node);

	//priority_queue = XNEWVEC (struct workBB_func_rep*, n_basic_blocks_for_function(func)+1);
	//workBB = XNEWVEC (struct workBB_func_rep, n_basic_blocks_for_function(func)+10);
	priority_queue = XNEWVEC (struct workBB_func_rep*, max_index + 1);
	workBB = XNEWVEC (struct workBB_func_rep, max_index + 1);

	FOR_EACH_BB_FN (bb, func){
//		workBB[bb->index].ptr = bb;
		workBB[bb->index].id = bb->index;
		workBB[bb->index].depth = bb->dom[0]->depth;
		workBB[bb->index].workVar = BITMAP_ALLOC(&workVar_obstack);
		workBB[bb->index].old_workVar = BITMAP_ALLOC(&workVar_obstack);
		workBB[bb->index].inQueue = false;

	}


	struct workBB_func_rep *currentBB, *finalBB = NULL;
	edge e;
	edge_iterator ei;

	if(start_bb->index == EXIT_BLOCK){
/*		if(workFunc && (mode == CALLEE_ON_CALLER_OFF || mode == CALLEE_ON_CALLER_ON)){
			bitmap_ior_into(workFunc[node->uid].exit_old_workVar, var->workVar);
		}
*/
		if(start_bb->preds != NULL){
			FOR_EACH_EDGE (e, ei, start_bb->preds){
				bb = e->src;
				if (func && bb != ENTRY_BLOCK_PTR){
					bitmap_copy(workBB[bb->index].workVar, var->workVar);
					queue_insert(priority_queue, &workBB[bb->index], &queue_size);
				}
			}
			currentBB = queue_extract_max(priority_queue, &queue_size);
			//gsi = gsi_last_bb((basic_block) currentBB->ptr);
			gsi = gsi_last_bb(BASIC_BLOCK(currentBB->id));
		}else{
			currentBB = NULL;
			//finalBB = &workBB[start_bb->index];
			bitmap_clear(var->workVar);
		}
	}else{
		bitmap_copy(workBB[start_bb->index].workVar, var->workVar);
		queue_insert(priority_queue, &workBB[start_bb->index], &queue_size);
		currentBB = queue_extract_max(priority_queue, &queue_size);
	}

	if(currentBB != NULL){
	do{
		scan_bb(node, gsi, var, workFunc, currentBB->workVar, mode);
		finalBB = currentBB;
		if(queue_size == 0){
/*			bitmap tmp = BITMAP_ALLOC(&workVar_obstack);
			bitmap_and(tmp, var->To, var->UpdatedTo);
			bitmap_xor_into(var->To, tmp);
			BITMAP_FREE(tmp);
*/
			if(bitmap_empty_p(currentBB->workVar)){
				if(var->mustAliasFlag == true && bitmap_single_bit_set_p(var->UpdatedTo))
					var->mustPointsTo = bitmap_first_set_bit(var->UpdatedTo);
				break;
			}else if(var->mustAliasFlag == true && bitmap_single_bit_set_p(var->workVar) && bitmap_empty_p(var->UpdatedTo) && finalize == true){
				storePoint = BASIC_BLOCK(currentBB->id);
				if(bitmap_single_bit_set_p(currentBB->workVar)){
					var->mustAlias.id = bitmap_first_set_bit(currentBB->workVar);
					var->mustAlias.gsi = gsi;
					var->mustAlias.node = node;
					if(dump_file)
						fprintf(dump_file, "\t### mustAlias.id = %s(%d)\n", get_pta_name (var->mustAlias.id), var->mustAlias.id);
				}
			}else{
				var->mustAliasFlag = false;
			}
		}

		if(bitmap_ior_into(currentBB->old_workVar, currentBB->workVar)){
//			FOR_EACH_EDGE (e, ei, ((basic_block)currentBB->ptr)->preds){
			FOR_EACH_EDGE (e, ei, (BASIC_BLOCK(currentBB->id))->preds){
				bb = e->src;
				if (func && bb != ENTRY_BLOCK_PTR){
					if(workBB[bb->index].inQueue == true){
						bitmap_ior_into(workBB[bb->index].workVar, currentBB->workVar);
					}else{
						bitmap_copy(workBB[bb->index].workVar, currentBB->workVar);
					}
					queue_insert(priority_queue, &workBB[bb->index], &queue_size);
				}
			}
		}
		if(currentBB = queue_extract_max(priority_queue, &queue_size))
//			gsi = gsi_last_bb((basic_block)currentBB->ptr);
			gsi = gsi_last_bb(BASIC_BLOCK(currentBB->id));

	}while(currentBB);


	bitmap_copy(var->workVar, finalBB->workVar);
	}

	if(rollBackFlag == true){
		if(dump_file){
			fprintf(dump_file, "roll back (caller_off, derefDepth = %d)\n", derefDepth);
		}
		bitmap_clear(var->workVar);
		var->mustPointsTo = MAY_INFO;
	}

	if(!bitmap_empty_p(var->workVar)){
		bitmap_iterator bi;
        unsigned int i, callerCnt;
		bitmap tmp = BITMAP_ALLOC(&workVar_obstack);
		struct cgraph_edge *edge;
		struct edgeList *list;

		for (edge = node->callers, callerCnt = 0; edge; edge = edge->next_caller, callerCnt++);
		for (list = node->possibleCaller; list; list = list->next, callerCnt++);


		if(callerCnt == 0){
			if(dump_file){
				fprintf(dump_file, "\nfinal update:\n");
				if(strcmp(cgraph_node_name (node), "main"))
					fprintf(dump_file, "Warnning: No one calls this function, but it is not main\n");
				else
					fprintf(dump_file, "clear workVar because of main\n");
			}
			bitmap_clear(var->workVar);
			if(var->mustAliasFlag == true)
				var->mustPointsTo = 0;

			// special treatment for global initialized variables //
			bitmap_clear_bit(var->UpdatedTo, nothing_id);
			bitmap_clear_bit(var->UpdatedTo, anything_id);
			bitmap_clear_bit(var->UpdatedTo, readonly_id);
			bitmap_clear_bit(var->UpdatedTo, escaped_id);
			bitmap_clear_bit(var->UpdatedTo, nonlocal_id);
			bitmap_clear_bit(var->UpdatedTo, storedanything_id);
			bitmap_clear_bit(var->UpdatedTo, integer_id);
		}else if(finalize == true){
			//var->weakUpdateFlag = true;
/*			EXECUTE_IF_IN_NONNULL_BITMAP (var->workVar, 0, i, bi){
				bitmap_ior_into(tmp, get_pta_solution (i));
			}
*/
		}

		if(finalize == true){
/*
			bitmap_and_into(tmp, var->To);
			bitmap_ior_into(var->UpdatedTo, tmp);
*/
//			bitmap_xor_into(var->To, var->UpdatedTo);

		}

		BITMAP_FREE(tmp);
	}

	#if(USE_POST_RESULT)

	if(!flag_ipa_no_post){
	if(skipPostResult == false){
		if(rollBackFlag == false && (mode == CALLEE_ON_CALLER_OFF || mode == CALLEE_ON_CALLER_ON)){
#if(USE_LIST_NODE)
            entry->size ++;
#endif
			if(try_again == false){
				struct resultInfo *info_tmp, *pre_ptr = NULL;
				
				for(info_tmp = postResult[root].head; info_tmp; ){
					if(bitmap_contains_in(info->mask, info_tmp->mask))
						bitmap_xor_into(info_tmp->mask, info->mask);
					// redundency: delete it //
					if(bitmap_empty_p(info_tmp->mask)){
						if(pre_ptr == NULL){
							postResult[root].head = info_tmp->next;
						}else{
							pre_ptr->next = info_tmp->next;
						}
#if(USE_LIST_NODE)
                        entry->size --;
#endif
						BITMAP_FREE(info_tmp->before_workVar);
						BITMAP_FREE(info_tmp->after_workVar);
						BITMAP_FREE(info_tmp->UpdatedTo);
						BITMAP_FREE(info_tmp->mask);
						free(info_tmp);

						if(pre_ptr == NULL){
							info_tmp = postResult[root].head;
						}else{
							info_tmp = pre_ptr->next;
						}
						continue;
					}else{
						pre_ptr = info_tmp;
					}
					info_tmp = info_tmp->next;
				}
				info->next = NULL;
				if(postResult[root].head == NULL){
					postResult[root].head = info;
					postResult[root].tail = info;
				}else{
					(postResult[root].tail)->next = info;
					postResult[root].tail = info;
				}
				bitmap_copy(info->after_workVar, var->workVar);
				bitmap_copy(info->UpdatedTo, var->UpdatedTo);
				
			}
			// Actually, mustPointsTo for post result is to represent mustAliasFlag //
			// I used this because of reusing the data structure //
			if(var->mustAliasFlag == true){
				info->mustPointsTo = true;
			}else{
				info->mustPointsTo = false;
			}
		}else{
			if(try_again == false){
				BITMAP_FREE(info->before_workVar);
				BITMAP_FREE(info->after_workVar);
				BITMAP_FREE(info->UpdatedTo);
				BITMAP_FREE(info->mask);
				free(info);
			}					
		}
	}
	bitmap_ior_into(var->workVar, after_workVar);
	bitmap_ior_into(var->UpdatedTo, old_UpdatedTo);
	}
	BITMAP_FREE(old_UpdatedTo);
	BITMAP_FREE(after_workVar);
	#endif

	if(var->mustAliasFlag == false)
		var->mustPointsTo = MAY_INFO;
	if(dump_file){
		fprintf(dump_file, "\nresult:\n");
		fprintf (dump_file, "\t### workVar = { ");
		dump_bitmap_var(dump_file, var->workVar);
		fprintf (dump_file, "} ###\n");
		fprintf (dump_file, "\t### UpdatedTo = { ");
		dump_bitmap_var(dump_file, var->UpdatedTo);
		fprintf (dump_file, "} ###\n");
		fprintf(dump_file, "\t### mustAlias.id = %s(%d)\n", get_pta_name (var->mustAlias.id), var->mustAlias.id);
		if(var->mustPointsTo == UNKNOWN)
			fprintf(dump_file, "\t### mustPointsTo = UNKNOWN\n");
		else if(var->mustPointsTo == MAY_INFO)
			fprintf(dump_file, "\t### mustPointsTo = MAY_INFO\n");
		else
			fprintf(dump_file, "\t### mustPointsTo = %s(%d)\n", get_pta_name (var->mustPointsTo), var->mustPointsTo);
	}

	FOR_EACH_BB_FN (bb, func){
		BITMAP_FREE(workBB[bb->index].workVar);
		BITMAP_FREE(workBB[bb->index].old_workVar);
	}


	free(workBB);
	free(priority_queue);

}


static void
get_main_node(void){
	struct cgraph_node *node;
	if(main_node == NULL)
	for (node = cgraph_nodes; node; node = node->next){
		struct function *func;
		basic_block bb;
		tree old_func_decl;
		
		// Nodes without a body are not interesting.  //
        if (!gimple_has_body_p (node->decl) || node->clone_of)
            continue;

		func = DECL_STRUCT_FUNCTION (node->decl);
		old_func_decl = current_function_decl;
		push_cfun (func);
		current_function_decl = node->decl;

		if(flag_shadow_profiling){
			if(!strcmp(cgraph_node_name (node), "exec_main"))
				main_node = node;
		}else{
			if(!strcmp(cgraph_node_name (node), "main"))
				main_node = node;
		}


		current_function_decl = old_func_decl;
		pop_cfun ();

	}
}


/* Return true if two variable table entries are the same. */
static int
trans_eq_var (const void *p1, const void *p2) {
	const struct TraceVar *ve1 = (const struct TraceVar *) p1;
	const struct TraceVar *ve2 = (const struct TraceVar *) p2;

	if (ve1->id != ve2->id)
		return false;

	if (ve1->gsi.ptr != ve2->gsi.ptr)
		return false;

	if (ve1->gsi.bb != ve2->gsi.bb)
		return false;

	if (ve1->gsi.seq != ve2->gsi.seq)
		return false;

#if(TEST_ANSWER_BY)
	if (ve1->level != ve2->level)
		return false;
#endif


	if (ve1->node != ve2->node)
		return false;

	return true;
}

/* Return the hash value for a variable.  */
static hashval_t
trans_hash_var (const void *p) {
	const struct TraceVar *ve = (const struct TraceVar *) p;
	//const TraceVar_t ve = (const TraceVar_t) p;
	//return htab_hash_pointer((PTR)ve->id);
	return ve->id;
}

static inline TraceVar_t
lookup_var(struct CheckPoint p) {
    void **slot;
	struct TraceVar var;

	var.id = p.id;
	var.gsi = p.gsi;
	var.node = p.node;

#if(TEST_ANSWER_BY)
    var.level = g_level;
#endif

    slot = htab_find_slot (VarTab, &var, NO_INSERT);
    if (!slot)
        return NULL;
	return ((TraceVar_t)*slot);
}

static inline TraceVar_t
alloc_var(struct CheckPoint p) {
	void **slot;
	struct TraceVar *var;
	if((var = lookup_var(p)) == NULL){
		var = XNEW(struct TraceVar);
#if(USE_LIST_NODE)
		var->list_node = NULL;
#endif
        varcnt ++;
#if(TEST_ANSWER_BY)
        var->level = g_level;
#else
		var->level = 0;
#endif
		var->id = p.id;
		var->gsi = p.gsi;
		var->node = p.node;
		var->workVar = BITMAP_ALLOC(NULL);
		var->UpdatedTo = BITMAP_ALLOC(NULL);
		VEC_safe_push(TraceVar_t, heap, reuse_var, var);
		slot = htab_find_slot (VarTab, var, INSERT);
		*slot = var;

	}
	return var;
}

static inline void
local_free(TraceVar_t var1, TraceVar_t var2, bitmap To){
	BITMAP_FREE(To);
	if(var1->id >= var_range){
		BITMAP_FREE(var1->workVar);
		free(var1);
	}
	if(var2->id >= var_range){
		BITMAP_FREE(var2->workVar);
		free(var2);
	}
}

static inline enum alias_result
check_pair_by_bootstrapping(enum alias_result answer, struct CheckPoint p1, struct CheckPoint p2, bool *continue_flag) {
	bitmap To1, To2;
	TraceVar_t var1, var2;
	unsigned int id1 = p1.id;
	unsigned int id2 = p2.id;
	bitmap To = BITMAP_ALLOC(&workVar_obstack);

	if(dump_file){
		fprintf (dump_file, "check ");
		if(id1 >= var_range)
			fprintf(dump_file, "%s(%d), ", get_pta_name (id1 - var_range), id1 - var_range);
		else
			fprintf(dump_file, "*%s(%d), ", get_pta_name (id1), id1);

		if(id2 >= var_range)
			fprintf(dump_file, "%s(%d)\n", get_pta_name (id2 - var_range), id2 - var_range);
		else
			fprintf(dump_file, "*%s(%d)\n", get_pta_name (id2), id2);
	}


	if(answer == MAY_ALIAS){
		bitmap_iterator bi;
		int i;
		bitmap UpdatedTo1 = BITMAP_ALLOC(&workVar_obstack);
		bitmap UpdatedTo2 = BITMAP_ALLOC(&workVar_obstack);
		if(p1.id >= var_range){
			var1 = XNEW(struct TraceVar);
			var1->id = p1.id;
			var1->weakUpdateFlag = false;
			var1->mustAlias.id = p1.id;
			var1->mustAlias.gsi = p1.gsi;
			var1->mustAlias.node = p1.node;
			var1->mustPointsTo = p1.id - var_range;
			var1->workVar = BITMAP_ALLOC(NULL);
			var1->UpdatedTo = UpdatedTo1;
			bitmap_set_bit(UpdatedTo1, p1.id - var_range);
		}else{
			var1 = lookup_var(p1);
			bitmap_copy(UpdatedTo1, var1->UpdatedTo);
			EXECUTE_IF_IN_NONNULL_BITMAP (var1->workVar, 0, i, bi){
				bitmap_ior_into(UpdatedTo1, get_pta_solution (i));
			}
		}
		if(p2.id >= var_range){
			var2 = XNEW(struct TraceVar);
			var2->id = p2.id;
			var2->weakUpdateFlag = false;
			var2->mustAlias.id = p2.id;
			var2->mustAlias.gsi = p2.gsi;
			var2->mustAlias.node = p2.node;
			var2->mustPointsTo = p2.id - var_range;
			var2->workVar = BITMAP_ALLOC(NULL);
			var2->UpdatedTo = UpdatedTo2;
			bitmap_set_bit(UpdatedTo2, p2.id - var_range);
		}else{
			var2 = lookup_var(p2);
			bitmap_copy(UpdatedTo2, var2->UpdatedTo);
			EXECUTE_IF_IN_NONNULL_BITMAP (var2->workVar, 0, i, bi){
				bitmap_ior_into(UpdatedTo2, get_pta_solution (i));
			}
		}
		bitmap_and(To, UpdatedTo1, UpdatedTo2);
		BITMAP_FREE(UpdatedTo1);
		BITMAP_FREE(UpdatedTo2);
		if(!bitmap_empty_p(To)){
			if(dump_file){
				fprintf(dump_file, "\tvar1->mustAlias.id = (%d),\tvar2->mustAlias.id = (%d)\n", var1->mustAlias.id, var2->mustAlias.id);
				fprintf(dump_file, "\tvar1->mustPointsTo = (%d), \tvar2->mustPointsTo = (%d)\n", var1->mustPointsTo, var2->mustPointsTo);
				dump_bitmap_elements(dump_file, var1->workVar, '{', "\t\tvar1->workVar", '}');
				dump_bitmap_elements(dump_file, var2->workVar, '{', "\t\tvar2->workVar", '}');
			}
			if(bitmap_single_bit_set_p(To) && bitmap_first_set_bit(To) == 0){
				if(dump_file)
					fprintf(dump_file, "\tMAY_ALIAS => MUST_NOT_ALIAS\n");
				local_free(var1, var2, To);

				return MUST_NOT_ALIAS;			
			}
//			if(var1->mustPointsTo == var2->mustPointsTo && has_exact_pointsto(var1->mustPointsTo) && var1->unknownFlag == false && var2->unknownFlag == false){
			if(bitmap_single_bit_set_p(var1->UpdatedTo) && bitmap_equal_p(var1->UpdatedTo, var2->UpdatedTo) && bitmap_first_set_bit(var1->UpdatedTo) > 0){
				if(dump_file)
					fprintf(dump_file, "\tMAY_ALIAS => MUST_ALIAS\n");
				local_free(var1, var2, To);
				return MUST_ALIAS;				
			}
#if(MUST_TEST == false)
			else if(var1->mustAlias.id == var2->mustAlias.id){
				if(var1->mustAlias.node == var2->mustAlias.node && var1->mustAlias.gsi.bb == var2->mustAlias.gsi.bb){
					if(dump_file)
						fprintf(dump_file, "\tMAY_ALIAS => MUST_ALIAS\n");
					local_free(var1, var2, To);
					return MUST_ALIAS;				
				}else{
					if(dump_file)
						fprintf(dump_file, "\tThe same mustAlias.id but not the same location\n");
				}
			}
#endif
			if((var1->weakUpdateFlag == true && var1->id < var_range) || (var2->weakUpdateFlag == true && var2->id < var_range) || !bitmap_empty_p(var1->workVar) || !bitmap_empty_p(var2->workVar))
				*continue_flag = true;
			dump_bitmap_elements(dump_file, To, '{', "\t\tTo", '}');
			if(dump_file)
				fprintf(dump_file, "\t! MAY_ALIAS !\n");
			//if(var1->mustPointsTo == UNKNOWN || var1->mustPointsTo == MAY_INFO)
//			bitmap_ior_into(var1->To, To);
			//if(var2->mustPointsTo == UNKNOWN || var2->mustPointsTo == MAY_INFO)
//			bitmap_ior_into(var2->To, To);
			local_free(var1, var2, To);
			return MAY_ALIAS;
		}else{
			dump_bitmap_elements(dump_file, var1->UpdatedTo, '{', "\t\tvar1->UpdatedTo", '}');
			dump_bitmap_elements(dump_file, var2->UpdatedTo, '{', "\t\tvar2->UpdatedTo", '}');
			if(dump_file)
				fprintf(dump_file, "\tMAY_ALIAS => MUST_NOT_ALIAS\n");
			local_free(var1, var2, To);
            return MUST_NOT_ALIAS;			
		}
	}
	if(dump_file)
		fprintf(dump_file, "\tno change\n");
	BITMAP_FREE(To);
	return answer;
}

static inline bool 
check_result(struct CheckPairVar *pairs, int mode) {
	bool continue_flag = false;
	int i, j;
	enum alias_result answer;

	if(dump_file)
		fprintf(dump_file, "\n\nChecking again:\n");

    for(i = 0; i < pairs->num; i++){
		answer = pairs->answer[i];
        pairs->answer[i] = check_pair_by_bootstrapping(pairs->answer[i], pairs->p1[i], pairs->p2[i], &continue_flag);
		if(dump_file)
			fprintf(dump_file, "\n");
    }
	return continue_flag;
}

static inline void
pt_level1(struct TraceVar *var){
    gcc_assert(var->level < BOOTSTRAP1);

    push_cfun(DECL_STRUCT_FUNCTION (var->node->decl));
    if(dump_file)
        fprintf(dump_file, "\n\n\n*** BOOTSTRAP1\n*** CALLEE_OFF_CALLER_OFF for %s(%d)\n", get_pta_name (var->id), var->id);	
    var->mustAliasFlag = true;
    var->weakUpdateFlag = false;
    var->unknownFlag = false;
    var->mustAlias.id = var->id;	
    var->mustAlias.gsi = var->gsi;
    var->mustAlias.node = var->node;
    var->mustPointsTo = UNKNOWN;
    bitmap_set_bit (var->workVar, var->id);
    gcc_assert(derefDepth == 0);
    bootstrap_caller_off(var->node, var->gsi, var, NULL, true, CALLEE_OFF_CALLER_OFF);
    pop_cfun();
    if(var->weakUpdateFlag == false)
        var->level = BOOTSTRAP2;
    else
        var->level = BOOTSTRAP1;
}

static inline void
pt_level2(struct TraceVar *var){
    gcc_assert(var->level < BOOTSTRAP2);

    struct workBB_func_rep *workFunc;
    struct cgraph_node *node;
    workFunc = XNEWVEC (struct workBB_func_rep, cgraph_max_uid+1);
    init_workFunc(workFunc);

    bitmap_clear(var->UpdatedTo);
    push_cfun(DECL_STRUCT_FUNCTION (var->node->decl));
    if(dump_file)
        fprintf(dump_file, "\n\n\n*** BOOTSTRAP2\n*** CALLEE_ON_CALLER_OFF for %s(%d)\n", get_pta_name (var->id), var->id);

    var->mustAliasFlag = true;
    var->weakUpdateFlag = false;
    var->unknownFlag = false;
    var->mustAlias.id = var->id;	
    var->mustAlias.gsi = var->gsi;
    var->mustAlias.node = var->node;
    var->mustPointsTo = UNKNOWN;
    bitmap_clear(var->workVar);
    bitmap_set_bit (var->workVar, var->id);

    bootstrap_caller_off(var->node, var->gsi, var, workFunc, true, CALLEE_ON_CALLER_OFF);
    var->level = BOOTSTRAP2;
    pop_cfun();

    for(node = cgraph_nodes; node; node = node->next){
        BITMAP_FREE(workFunc[node->uid].workVar);
        BITMAP_FREE(workFunc[node->uid].old_workVar);
        BITMAP_FREE(workFunc[node->uid].exit_old_workVar);
    }
    free(workFunc);
}

static inline void
pt_level4(struct TraceVar *var){
    gcc_assert(var->level == BOOTSTRAP2);
         
    int Func_queue_size = 0;
    struct workBB_func_rep **Func_queue;
    struct workBB_func_rep *workFunc;
    Func_queue = XNEWVEC (struct workBB_func_rep*, cgraph_max_uid+1);
    workFunc = XNEWVEC (struct workBB_func_rep, cgraph_max_uid+1);

    if(dump_file)
        fprintf(dump_file, "\n\n\n*** BOOTSTRAP4\n*** CALLEE_ON_CALLER_ON for %s(%d)\n", get_pta_name (var->id), var->id);	
    if(!bitmap_empty_p(var->workVar)){
        bootstrap_caller_on(Func_queue, &Func_queue_size, var, workFunc, var->node, CALLEE_ON_CALLER_ON);
    }

    if(dump_file){
        fprintf(dump_file, "\nCALLER_ON_CALLEE_ON result:\n");
        fprintf (dump_file, "\t### workVar = { ");
        dump_bitmap_var(dump_file, var->workVar);
        fprintf (dump_file, "} ###\n");
        fprintf (dump_file, "\t### UpdatedTo = { ");
        dump_bitmap_var(dump_file, var->UpdatedTo);
        fprintf (dump_file, "} ###\n");
        if(var->mustPointsTo == UNKNOWN)
            fprintf(dump_file, "\t### mustPointsTo = UNKNOWN\n");
        else if(var->mustPointsTo == MAY_INFO)
            fprintf(dump_file, "\t### mustPointsTo = MAY_INFO\n");
        else
            fprintf(dump_file, "\t### mustPointsTo = %s(%d)\n", get_pta_name (var->mustPointsTo), var->mustPointsTo);
    }
    var->level = BOOTSTRAP4;
    free(Func_queue);
    free(workFunc);
//    BITMAP_FREE(var->workVar);
}

static inline void
calculate_pt_level(struct TraceVar *var, unsigned int level){
    gcc_assert(var->id < var_range);

    // previous calculated level >= required level
    if(var->level >= level)
        return;

    if(level == BOOTSTRAP1){
        pt_level1(var);
        return;
    }else if(level == BOOTSTRAP2){
        pt_level2(var);            
        return;
    }else if(level == BOOTSTRAP4){
        if(var->level < BOOTSTRAP2)
            pt_level2(var);
        pt_level4(var);
    }else{
        gcc_unreachable();
    }
}

static int
main_bootstrapping(struct CheckPairVar *pairs) {
	struct TraceVar *var1, *var2;
	struct TraceVar *var;
	bool continue_flag;
	int i, j;	
	struct timeval start, end;
	long seconds, useconds;

#if(TEST_ANSWER_BY)
    g_level = 0;
#endif

	if(pairs->p1[0].id < var_range){
		if((var1 = lookup_var(pairs->p1[0])) == NULL){
			var1 = alloc_var(pairs->p1[0]);
		}
		VEC_safe_push(TraceVar_t, heap, trace_var, var1);
	}
	if(pairs->p2[0].id < var_range){
		if((var2 = lookup_var(pairs->p2[0])) == NULL){
			var2 = alloc_var(pairs->p2[0]);
		}
		VEC_safe_push(TraceVar_t, heap, trace_var, var2);
	}

#if(ONLY_BT4 == false)
	// ************************** Bootstrap1 Begin ************************** //
	gettimeofday(&start, NULL);
	for (i = 0; VEC_iterate(TraceVar_t, trace_var, i, var); i++){
        gcc_assert(derefDepth == 0);
#if(TEST_ANSWER_BY)
        g_level = 1;
        struct CheckPoint p;
        p.id = var->id;
        p.gsi = var->gsi;
        p.node = var->node;
        if(lookup_var(p) != NULL)
            continue;
        else{
            var = alloc_var(p);
            var->level = 0;
        }
#endif

        calculate_pt_level(var, BOOTSTRAP1);
#if(TEST_ANSWER_BY)
        var->level = 1;
#endif

	}

#if(TEST_ANSWER_BY)
    g_level = 1;
#endif
	// check again //
	continue_flag = check_result(pairs, BOOTSTRAP1);

	gettimeofday(&end, NULL);
	seconds  = end.tv_sec  - start.tv_sec;
	useconds = end.tv_usec - start.tv_usec;
	timer[BOOTSTRAP1] += (((seconds) * 1000 + useconds/1000.0) + 0.5);

	if(continue_flag == false){
		return BOOTSTRAP1;
	}
	// ************************** Bootstrap1 End ************************** //


	// ************************* Bootstrap2 Begin ************************* //
	gettimeofday(&start, NULL);
	// trace again //
	for (i = 0; VEC_iterate(TraceVar_t, trace_var, i, var); i++){ 
        gcc_assert(derefDepth == 0);
#if(TEST_ANSWER_BY)
        g_level = 2;
        struct CheckPoint p;
        p.id = var->id;
        p.gsi = var->gsi;
        p.node = var->node;
        if(lookup_var(p) != NULL)
            continue;
        else{
            var = alloc_var(p);
            var->level = 1;
        }
#endif
        calculate_pt_level(var, BOOTSTRAP2);
#if(TEST_ANSWER_BY)
        var->level = 2;
#endif
	}

#if(TEST_ANSWER_BY)
    g_level = 2;
#endif
	// check again //
	continue_flag = check_result(pairs, BOOTSTRAP2);

	gettimeofday(&end, NULL);
	seconds  = end.tv_sec  - start.tv_sec;
    useconds = end.tv_usec - start.tv_usec;
	timer[BOOTSTRAP2] += (((seconds) * 1000 + useconds/1000.0) + 0.5);

	if(continue_flag == false){
		return BOOTSTRAP2;
	}
	// ************************** Bootstrap2 End ************************** //
#endif


	// ************************* Bootstrap4 Begin ************************* //
	gettimeofday(&start, NULL);

	for (i = 0; VEC_iterate(TraceVar_t, trace_var, i, var); i++){ 
        gcc_assert(derefDepth == 0);
#if(TEST_ANSWER_BY)
        g_level = 4;
        struct CheckPoint p;
        p.id = var->id;
        p.gsi = var->gsi;
        p.node = var->node;
        if(lookup_var(p) != NULL)
            continue;
        else{
            var = alloc_var(p);
            var->level = 0;
        }
#endif
        calculate_pt_level(var, BOOTSTRAP4);
#if(TEST_ANSWER_BY)
        var->level = 4;
#endif
	}

#if(TEST_ANSWER_BY)
    g_level = 4;
#endif
	// check again //
	continue_flag = check_result(pairs, BOOTSTRAP4);

	if(continue_flag == true){
		if(dump_file)
			fprintf(dump_file, "After the analysis, it still have may information: need more accurate analysis!\n");
	}

	gettimeofday(&end, NULL);
	seconds  = end.tv_sec  - start.tv_sec;
	useconds = end.tv_usec - start.tv_usec;
	timer[BOOTSTRAP4] += (((seconds) * 1000 + useconds/1000.0) + 0.5);

	return BOOTSTRAP4;
	// ************************** Bootstrap4 End ************************** //
}

static void 
free_list(struct disjointedSet *array){
    unsigned int i, root;
	struct resultInfo *info, *info_tmp;

    for(i = 0; i < var_range; i++){
        if(array[i].rep == 0)
            continue;
        root = find(i, array);
        for(info = array[root].head; info; info = info_tmp){
//	for(info = rep->head; info; info = info_tmp){
            BITMAP_FREE(info->before_workVar);
            BITMAP_FREE(info->after_workVar);
            BITMAP_FREE(info->UpdatedTo);
            BITMAP_FREE(info->mask);
            info_tmp = info->next;
            free(info);
        }
        array[root].head = NULL;
        array[root].tail = NULL;
//        rep->head = NULL;
//        rep->tail = NULL;
    }
}


#if(USE_LIST_NODE)
static void
delete_summary(void){
	struct cgraph_node *node;
	struct disjointedSet *postResult;
	struct disjointedSet *preResult;
	unsigned int i, j;
	for(node = cgraph_nodes; node; node = node->next){
#if(USE_POST_RESULT)
        if(!flag_ipa_no_post){
            summary_t entry;
            VEC(summary_t, heap) *tmp;
            for (i = 0; VEC_iterate(summary_t, dom[node->uid].postHead, i, entry); i++){
//                if(entry->size > 20){
                fprintf(stderr, "deleting %d\n", VEC_length(summary_t, dom[node->uid].postHead));
                    postResult = entry->summary;
                    free_list(postResult);


//                    VEC_block_remove(summary_t, dom[node->uid].postHead, i, 1);

                    list_node_free(entry->callString);
                    free(entry->summary);
                    free(entry);
//                }
            }
            VEC_free(summary_t, heap, dom[node->uid].postHead);
        }
#endif
    }
}
#endif

/*
static void
delete_summary(void){
	struct cgraph_node *node;
	struct disjointedSet *postResult;
	struct disjointedSet *preResult;
	unsigned int i;
	for(node = cgraph_nodes; node; node = node->next){
#if(USE_POST_RESULT)
	if(!flag_ipa_no_post){
		if(dom[node->uid].postResult != NULL){
			postResult = dom[node->uid].postResult;
			for(i = 0; i < var_range; i++){
				free_list(&postResult[find(i, postResult)]);
			}
			free(dom[node->uid].postResult);
			dom[node->uid].postResult = NULL;
		}
	}
#endif
#if(USE_PRE_RESULT)
	if(!flag_ipa_no_pre){
		if(dom[node->uid].preResult != NULL){
			preResult = dom[node->uid].preResult;
			for(i = 0; i < var_range; i++){
				free_list(&preResult[find(i, preResult)]);
			}
			free(dom[node->uid].preResult);
			dom[node->uid].preResult = NULL;
		}
	}
#endif
    }
}
*/
enum answerby
ipa_pta_pair_bootstrapping (struct CheckPairVar * pairs, int memop1, int memop2) {
    struct cgraph_node *node;
    bool continue_flag;
	unsigned int i;
	enum answerby bsresult;

    FILE *old_dump_file;
    old_dump_file = dump_file;

	if(flag_ipa_pta_pair != NULL)
		dump_file = fopen ("mydumpfile.txt", "a");
	else
		dump_file = NULL;

    init_bootstrap();

	if(!VarTab)
		VarTab = htab_create (pairs->num * 2, trans_hash_var, trans_eq_var, NULL);


	if(pairs->p1[0].id >= var_range && pairs->p2[0].id >= var_range)
		continue_flag = false;
	else{
        continue_flag = true;
    }

    if(continue_flag == true){
		if(main_node == NULL){
			FILE *old_file = dump_file;
			int cnt;

#if(TEST_ANSWER_BY)
            flag_ipa_no_pre = true;
            flag_ipa_no_post = true;
#endif


			dump_file = fopen ("mydumpfile.txt", "a");
			if(dump_file){
				fprintf(dump_file, "\n\nPrint pta solution again to make sure that it passes to the bootstrapping.\n");
				fprintf(dump_file, "var_range = %d\n", var_range);
			}
			for(i = 0; i < var_range; i++){

				if(dump_file)
					fprintf (dump_file, "%s(%d) = { ", bsvars[i].name, i);

				unsigned int j;
				bitmap_iterator bi;

				if(dump_file){
					EXECUTE_IF_IN_NONNULL_BITMAP (bsvars[i].solution, 0, j, bi){
						fprintf (dump_file, "%s", bsvars[j].name);
						fprintf (dump_file, "(%d) ", j);
					}
					fprintf (dump_file, "}\n");
				}
			}
			fprintf(stdout, "var_range = %d\n", var_range);
			get_main_node();
			cnt = calcualte_the_number_of_pointers();
			fprintf(stderr, "POINTERS = %d\n", cnt);
            totalcnt = cnt;
			calculate_dom_depth_for_call_graph();
			dump_file = old_file;
		}

        pairs->answer[0] = MAY_ALIAS;
		bsresult = main_bootstrapping(pairs);
		if(dump_file)
			fprintf(dump_file, "\n\n======================================\n\n");
    }else{
		bsresult = ANDERSON;
		if(pairs->p1[0].id == pairs->p2[0].id)
			pairs->answer[0] = MUST_ALIAS;
		else
			pairs->answer[0] = MUST_NOT_ALIAS;
    }
	release_bootstrap();

	if(dump_file)
		fprintf(dump_file, "\tanswered by : %d\n", bsresult);

#if(USE_LIST_NODE)
	struct TraceVar *var;
	for (i = 0; VEC_iterate(TraceVar_t, trace_var, i, var); i++){
	  if(var->id < var_range && var->list_node != NULL){
	    list_node_free(var->list_node);
	  }
	}
#endif

	VEC_free(TraceVar_t, heap, trace_var);
//    delete_summary();
/*
	if(VEC_length(TraceVar_t, reuse_var) > 300){
		fprintf(stderr, "release space\n");
		delete_summary();
		//release_bootstrap();
		htab_delete(VarTab);
		VarTab = NULL;
	}
*/

	if(flag_ipa_pta_pair != NULL)
		fclose(dump_file);
    dump_file = old_dump_file;
	return bsresult;
}
