/* yices interface */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tree.h"
#include "target.h"
#include "gimple.h"
#include "cgraph.h"
#include "tree-flow.h"
#include "tree-pass.h"
#include "flags.h"
#include "timevar.h"
#include "diagnostic.h"
#include "params.h"
#include "tree-dump.h"
#include "tree-pretty-print.h"

/* TODO: modify configure system to generate this marco in config.h */
#define HAVE_YICES_C_H

#ifdef HAVE_YICES_C_H

#include "yices_c.h"

/* internal interface */

#define DEBUG_SYMBOLIC_YICES 0
#define YICES_BITFIELD 0

#if DEBUG_SYMBOLIC_YICES
#define yices_gcc_assert(expr) gcc_assert(expr)
#else
#define yices_gcc_assert(expr) 0
#endif

#if DEBUG_SYMBOLIC_YICES
#define symee_assert(expr,fprintf_args)                                 \
  ((void)(expr ? 0: (fprintf fprintf_args, yices_gcc_assert (expr), 0)))
#else
#define symee_assert(expr,fprintf_args)
#endif

static yices_expr make_var_from_decl_name (yices_context ctx, char *name);
static char* make_yices_name (const char* name);
static char* make_yices_type_name (tree ttype);
static yices_type make_yices_type (yices_context ctx, tree ttype);
static yices_expr make_yices_decl (yices_context ctx, tree decl);
static yices_expr make_yices_var_from_decl (yices_context ctx, tree decl);
static yices_expr make_yices_expr_tcc_exceptional (yices_context ctx, tree expr);
static yices_expr make_yices_expr_tcc_constant (yices_context ctx, tree expr);
static yices_expr make_yices_expr_tcc_type (yices_context ctx, tree expr);
static yices_expr make_yices_expr_tcc_declaration (yices_context ctx, tree expr);
static yices_expr make_yices_expr_tcc_reference (yices_context ctx, tree expr);
static yices_expr make_yices_expr_tcc_comparison (yices_context ctx, tree expr);
static yices_expr make_yices_expr_tcc_unary (yices_context ctx, tree expr);
static yices_expr make_yices_expr_tcc_binary (yices_context ctx, tree expr);
static yices_expr make_yices_expr_tcc_satement (yices_context ctx, tree expr);
static yices_expr make_yices_expr_tcc_vl_exp (yices_context ctx, tree expr);
static yices_expr make_yices_expr_tcc_expression (yices_context ctx, tree expr);

static yices_expr make_yices_expr (yices_context ctx, tree expr);

static inline yices_expr
make_op0 (yices_context ctx, tree expr)
{
  return make_yices_expr (ctx, TREE_OPERAND (expr, 0));
}

static inline yices_expr
make_op1 (yices_context ctx, tree expr)
{
  return make_yices_expr (ctx, TREE_OPERAND (expr, 0));
}

static inline yices_expr
make_op2 (yices_context ctx, tree expr)
{
  return make_yices_expr (ctx, TREE_OPERAND (expr, 0));
}

static yices_expr emit_yices_expr_from_tree (yices_context ctx, tree expr);
static bool search_in_ref (tree expr, tree lhs);
static inline bool check_symbol_version (tree a, tree b);


#define WRAP2ARGS_NAME(NAME) NAME##2
#define WRAP2ARGS_DECL(NAME)                                            \
  static yices_expr WRAP2ARGS_NAME (NAME) (yices_context ctx, yices_expr a1, yices_expr a2);
#define WRAP2ARGS_DEF(NAME)                     \
  static yices_expr                                                     \
  WRAP2ARGS_NAME (NAME) (yices_context ctx, yices_expr a1, yices_expr a2) \
  {                                                                     \
                        yices_expr args[2] = {a1, a2};                  \
                        return NAME (ctx, args, 2);                     \
  }

WRAP2ARGS_DECL (yices_mk_sum)
WRAP2ARGS_DECL (yices_mk_sub)
WRAP2ARGS_DECL (yices_mk_mul)
WRAP2ARGS_DECL (yices_mk_and)
WRAP2ARGS_DECL (yices_mk_or)

typedef yices_expr (*yices_unary_function) (yices_context, yices_expr);
typedef yices_expr (*yices_binary_function) (yices_context, yices_expr, yices_expr);

static void* yices_functions [MAX_TREE_CODES] = {
  [ERROR_MARK] = 0,
  [IDENTIFIER_NODE] = 0,
  [TREE_LIST] = 0,
  [TREE_VEC] = 0,
  [BLOCK] = 0,
  [OFFSET_TYPE] = 0,
  [ENUMERAL_TYPE] = 0,
  [BOOLEAN_TYPE] = 0,
  [INTEGER_TYPE] = 0,
  [REAL_TYPE] = 0,
  [POINTER_TYPE] = 0,
  [REFERENCE_TYPE] = 0,
  [NULLPTR_TYPE] = 0,
  [FIXED_POINT_TYPE] = 0,
  [COMPLEX_TYPE] = 0,
  [VECTOR_TYPE] = 0,
  [ARRAY_TYPE] = 0,
  [RECORD_TYPE] = 0,
  [UNION_TYPE] = 0,
  [QUAL_UNION_TYPE] = 0,
  [VOID_TYPE] = 0,
  [FUNCTION_TYPE] = 0,
  [METHOD_TYPE] = 0,
  [LANG_TYPE] = 0,
  [INTEGER_CST] = 0,
  [REAL_CST] = 0,
  [FIXED_CST] = 0,
  [COMPLEX_CST] = 0,
  [VECTOR_CST] = 0,
  [STRING_CST] = 0,
  [FUNCTION_DECL] = 0,
  [LABEL_DECL] = 0,
  [FIELD_DECL] = 0,
  [VAR_DECL] = 0,
  [CONST_DECL] = 0,
  [PARM_DECL] = 0,
  [TYPE_DECL] = 0,
  [RESULT_DECL] = 0,
  [DEBUG_EXPR_DECL] = 0,
  [NAMESPACE_DECL] = 0,
  [IMPORTED_DECL] = 0,
  [TRANSLATION_UNIT_DECL] = 0,
  [COMPONENT_REF] = 0,
  [BIT_FIELD_REF] = 0,
  [REALPART_EXPR] = 0,
  [IMAGPART_EXPR] = 0,
  [ARRAY_REF] = 0,
  [ARRAY_RANGE_REF] = 0,
  [INDIRECT_REF] = 0,
  [OBJ_TYPE_REF] = 0,
  [CONSTRUCTOR] = 0,
  [COMPOUND_EXPR] = 0,
  [MODIFY_EXPR] = 0,
  [INIT_EXPR] = 0,
  [TARGET_EXPR] = 0,
  [COND_EXPR] = 0,
  [VEC_COND_EXPR] = 0,
  [BIND_EXPR] = 0,
  [CALL_EXPR] = 0,
  [WITH_CLEANUP_EXPR] = 0,
  [CLEANUP_POINT_EXPR] = 0,
  [PLACEHOLDER_EXPR] = 0,
  [PLUS_EXPR] = WRAP2ARGS_NAME (yices_mk_sum),
  [MINUS_EXPR] = WRAP2ARGS_NAME (yices_mk_sub),
  [MULT_EXPR] = WRAP2ARGS_NAME (yices_mk_mul),
  [POINTER_PLUS_EXPR] = WRAP2ARGS_NAME (yices_mk_sum),
  [TRUNC_DIV_EXPR] = 0,
  [CEIL_DIV_EXPR] = 0,
  [FLOOR_DIV_EXPR] = 0,
  [ROUND_DIV_EXPR] = 0,
  [TRUNC_MOD_EXPR] = 0,
  [CEIL_MOD_EXPR] = 0,
  [FLOOR_MOD_EXPR] = 0,
  [ROUND_MOD_EXPR] = 0,
  [RDIV_EXPR] = 0,
  [EXACT_DIV_EXPR] = 0,
  [FIX_TRUNC_EXPR] = 0,
  [FLOAT_EXPR] = 0,
  [NEGATE_EXPR] = 0,
  [MIN_EXPR] = 0,
  [MAX_EXPR] = 0,
  [ABS_EXPR] = 0,
  [LSHIFT_EXPR] = 0, //yices_mk_bv_shift_left0,
  [RSHIFT_EXPR] = 0, //yices_mk_bv_shift_right0,
  [LROTATE_EXPR] = 0, //yices_mk_bv_shift_left0,
  [RROTATE_EXPR] = 0, //yices_mk_bv_shift_right0,
  [BIT_IOR_EXPR] = 0,
  [BIT_XOR_EXPR] = 0, //yices_mk_bv_xor,
  [BIT_AND_EXPR] = 0, //yices_mk_bv_and,
  [BIT_NOT_EXPR] = 0, //yices_mk_bv_not,
  [TRUTH_ANDIF_EXPR] = 0,
  [TRUTH_ORIF_EXPR] = 0,
  [TRUTH_AND_EXPR] = WRAP2ARGS_NAME (yices_mk_and),
  [TRUTH_OR_EXPR] = WRAP2ARGS_NAME (yices_mk_or),
  [TRUTH_XOR_EXPR] = 0,
  [TRUTH_NOT_EXPR] = yices_mk_not,
  [LT_EXPR] = yices_mk_lt,
  [LE_EXPR] = yices_mk_le,
  [GT_EXPR] = yices_mk_gt,
  [GE_EXPR] = yices_mk_ge,
  [EQ_EXPR] = yices_mk_eq,
  [NE_EXPR] = yices_mk_diseq,
  [UNORDERED_EXPR] = 0,
  [ORDERED_EXPR] = 0,
  [UNLT_EXPR] = yices_mk_lt,
  [UNLE_EXPR] = yices_mk_le,
  [UNGT_EXPR] = yices_mk_gt,
  [UNGE_EXPR] = yices_mk_ge,
  [UNEQ_EXPR] = yices_mk_eq,
  [LTGT_EXPR] = yices_mk_diseq,
  [RANGE_EXPR] = 0,
  [PAREN_EXPR] = 0,
  [CONVERT_EXPR] = 0,
  [ADDR_SPACE_CONVERT_EXPR] = 0,
  [FIXED_CONVERT_EXPR] = 0,
  [NOP_EXPR] = 0,
  [NON_LVALUE_EXPR] = 0,
  [VIEW_CONVERT_EXPR] = 0,
  [COMPOUND_LITERAL_EXPR] = 0,
  [SAVE_EXPR] = 0,
  [ADDR_EXPR] = 0,
  [FDESC_EXPR] = 0,
  [COMPLEX_EXPR] = 0,
  [CONJ_EXPR] = 0,
  [PREDECREMENT_EXPR] = 0,
  [PREINCREMENT_EXPR] = 0,
  [POSTDECREMENT_EXPR] = 0,
  [POSTINCREMENT_EXPR] = 0,
  [VA_ARG_EXPR] = 0,
  [TRY_CATCH_EXPR] = 0,
  [TRY_FINALLY_EXPR] = 0,
  [DECL_EXPR] = 0,
  [LABEL_EXPR] = 0,
  [GOTO_EXPR] = 0,
  [RETURN_EXPR] = 0,
  [EXIT_EXPR] = 0,
  [LOOP_EXPR] = 0,
  [SWITCH_EXPR] = 0,
  [CASE_LABEL_EXPR] = 0,
  [ASM_EXPR] = 0,
  [SSA_NAME] = 0,
  [CATCH_EXPR] = 0,
  [EH_FILTER_EXPR] = 0,
  [SCEV_KNOWN] = 0,
  [SCEV_NOT_KNOWN] = 0,
  [POLYNOMIAL_CHREC] = 0,
  [STATEMENT_LIST] = 0,
  [ASSERT_EXPR] = 0,
  [TREE_BINFO] = 0,
  [WITH_SIZE_EXPR] = 0,
  [REALIGN_LOAD_EXPR] = 0,
  [TARGET_MEM_REF] = 0,
  [MEM_REF] = 0,
  [OMP_PARALLEL] = 0,
  [OMP_TASK] = 0,
  [OMP_FOR] = 0,
  [OMP_SECTIONS] = 0,
  [OMP_SINGLE] = 0,
  [OMP_SECTION] = 0,
  [OMP_MASTER] = 0,
  [OMP_ORDERED] = 0,
  [OMP_CRITICAL] = 0,
  [OMP_ATOMIC] = 0,
  [OMP_CLAUSE] = 0,
  [REDUC_MAX_EXPR] = 0,
  [REDUC_MIN_EXPR] = 0,
  [REDUC_PLUS_EXPR] = 0,
  [DOT_PROD_EXPR] = 0,
  [WIDEN_SUM_EXPR] = 0,
  [WIDEN_MULT_EXPR] = 0,
  [WIDEN_MULT_PLUS_EXPR] = 0,
  [WIDEN_MULT_MINUS_EXPR] = 0,
  [FMA_EXPR] = 0,
  [VEC_LSHIFT_EXPR] = 0,
  [VEC_RSHIFT_EXPR] = 0,
  [VEC_WIDEN_MULT_HI_EXPR] = 0,
  [VEC_WIDEN_MULT_LO_EXPR] = 0,
  [VEC_UNPACK_HI_EXPR] = 0,
  [VEC_UNPACK_LO_EXPR] = 0,
  [VEC_UNPACK_FLOAT_HI_EXPR] = 0,
  [VEC_UNPACK_FLOAT_LO_EXPR] = 0,
  [VEC_PACK_TRUNC_EXPR] = 0,
  [VEC_PACK_SAT_EXPR] = 0,
  [VEC_PACK_FIX_TRUNC_EXPR] = 0,
  [VEC_EXTRACT_EVEN_EXPR] = 0,
  [VEC_EXTRACT_ODD_EXPR] = 0,
  [VEC_INTERLEAVE_HIGH_EXPR] = 0,
  [VEC_INTERLEAVE_LOW_EXPR] = 0,
  [PREDICT_EXPR] = 0,
  [OPTIMIZATION_NODE] = 0,
  [TARGET_OPTION_NODE] = 0,
  [SYMEE_DECL] = 0,
  [SYMEE_NEWSYM] = 0,
  [SYMEE_ASSIGN] = 0,
  [SYMEE_DELTA] = 0,
  [SYMEE_GAMMA] = 0,
  [SYMEE_MU] = 0,
  [SYMEE_DIRECT_SUM] = 0,
  [SYMEE_THETA] = 0,
  [SYMEE_RHO] = 0,
};

#define YICES_FUNCTION(CODE)                    \
  (yices_functions[CODE])


static yices_expr make_ERROR_MARK (yices_context ctx, tree expr);
static yices_expr make_IDENTIFIER_NODE (yices_context ctx, tree expr);
static yices_expr make_TREE_LIST (yices_context ctx, tree expr);
static yices_expr make_TREE_VEC (yices_context ctx, tree expr);
static yices_expr make_BLOCK (yices_context ctx, tree expr);
static yices_expr make_OFFSET_TYPE (yices_context ctx, tree expr);
static yices_expr make_ENUMERAL_TYPE (yices_context ctx, tree expr);
static yices_expr make_BOOLEAN_TYPE (yices_context ctx, tree expr);
static yices_expr make_INTEGER_TYPE (yices_context ctx, tree expr);
static yices_expr make_REAL_TYPE (yices_context ctx, tree expr);
static yices_expr make_POINTER_TYPE (yices_context ctx, tree expr);
static yices_expr make_REFERENCE_TYPE (yices_context ctx, tree expr);
static yices_expr make_NULLPTR_TYPE (yices_context ctx, tree expr);
static yices_expr make_FIXED_POINT_TYPE (yices_context ctx, tree expr);
static yices_expr make_COMPLEX_TYPE (yices_context ctx, tree expr);
static yices_expr make_VECTOR_TYPE (yices_context ctx, tree expr);
static yices_expr make_ARRAY_TYPE (yices_context ctx, tree expr);
static yices_expr make_RECORD_TYPE (yices_context ctx, tree expr);
static yices_expr make_UNION_TYPE (yices_context ctx, tree expr);
static yices_expr make_QUAL_UNION_TYPE (yices_context ctx, tree expr);
static yices_expr make_VOID_TYPE (yices_context ctx, tree expr);
static yices_expr make_FUNCTION_TYPE (yices_context ctx, tree expr);
static yices_expr make_METHOD_TYPE (yices_context ctx, tree expr);
static yices_expr make_LANG_TYPE (yices_context ctx, tree expr);
static yices_expr make_INTEGER_CST (yices_context ctx, tree expr);
static yices_expr make_REAL_CST (yices_context ctx, tree expr);
static yices_expr make_FIXED_CST (yices_context ctx, tree expr);
static yices_expr make_COMPLEX_CST (yices_context ctx, tree expr);
static yices_expr make_VECTOR_CST (yices_context ctx, tree expr);
static yices_expr make_STRING_CST (yices_context ctx, tree expr);
static yices_expr make_FUNCTION_DECL (yices_context ctx, tree expr);
static yices_expr make_LABEL_DECL (yices_context ctx, tree expr);
static yices_expr make_FIELD_DECL (yices_context ctx, tree expr);
static yices_expr make_VAR_DECL (yices_context ctx, tree expr);
static yices_expr make_CONST_DECL (yices_context ctx, tree expr);
static yices_expr make_PARM_DECL (yices_context ctx, tree expr);
static yices_expr make_TYPE_DECL (yices_context ctx, tree expr);
static yices_expr make_RESULT_DECL (yices_context ctx, tree expr);
static yices_expr make_DEBUG_EXPR_DECL (yices_context ctx, tree expr);
static yices_expr make_NAMESPACE_DECL (yices_context ctx, tree expr);
static yices_expr make_IMPORTED_DECL (yices_context ctx, tree expr);
static yices_expr make_TRANSLATION_UNIT_DECL (yices_context ctx, tree expr);
static yices_expr make_COMPONENT_REF (yices_context ctx, tree expr);
static yices_expr make_BIT_FIELD_REF (yices_context ctx, tree expr);
static yices_expr make_REALPART_EXPR (yices_context ctx, tree expr);
static yices_expr make_IMAGPART_EXPR (yices_context ctx, tree expr);
static yices_expr make_ARRAY_REF (yices_context ctx, tree expr);
static yices_expr make_ARRAY_RANGE_REF (yices_context ctx, tree expr);
static yices_expr make_INDIRECT_REF (yices_context ctx, tree expr);
static yices_expr make_OBJ_TYPE_REF (yices_context ctx, tree expr);
static yices_expr make_CONSTRUCTOR (yices_context ctx, tree expr);
static yices_expr make_COMPOUND_EXPR (yices_context ctx, tree expr);
static yices_expr make_MODIFY_EXPR (yices_context ctx, tree expr);
static yices_expr make_INIT_EXPR (yices_context ctx, tree expr);
static yices_expr make_TARGET_EXPR (yices_context ctx, tree expr);
static yices_expr make_COND_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_COND_EXPR (yices_context ctx, tree expr);
static yices_expr make_BIND_EXPR (yices_context ctx, tree expr);
static yices_expr make_CALL_EXPR (yices_context ctx, tree expr);
static yices_expr make_WITH_CLEANUP_EXPR (yices_context ctx, tree expr);
static yices_expr make_CLEANUP_POINT_EXPR (yices_context ctx, tree expr);
static yices_expr make_PLACEHOLDER_EXPR (yices_context ctx, tree expr);
static yices_expr make_PLUS_EXPR (yices_context ctx, tree expr);
static yices_expr make_MINUS_EXPR (yices_context ctx, tree expr);
static yices_expr make_MULT_EXPR (yices_context ctx, tree expr);
static yices_expr make_POINTER_PLUS_EXPR (yices_context ctx, tree expr);
static yices_expr make_TRUNC_DIV_EXPR (yices_context ctx, tree expr);
static yices_expr make_CEIL_DIV_EXPR (yices_context ctx, tree expr);
static yices_expr make_FLOOR_DIV_EXPR (yices_context ctx, tree expr);
static yices_expr make_ROUND_DIV_EXPR (yices_context ctx, tree expr);
static yices_expr make_TRUNC_MOD_EXPR (yices_context ctx, tree expr);
static yices_expr make_CEIL_MOD_EXPR (yices_context ctx, tree expr);
static yices_expr make_FLOOR_MOD_EXPR (yices_context ctx, tree expr);
static yices_expr make_ROUND_MOD_EXPR (yices_context ctx, tree expr);
static yices_expr make_RDIV_EXPR (yices_context ctx, tree expr);
static yices_expr make_EXACT_DIV_EXPR (yices_context ctx, tree expr);
static yices_expr make_FIX_TRUNC_EXPR (yices_context ctx, tree expr);
static yices_expr make_FLOAT_EXPR (yices_context ctx, tree expr);
static yices_expr make_NEGATE_EXPR (yices_context ctx, tree expr);
static yices_expr make_MIN_EXPR (yices_context ctx, tree expr);
static yices_expr make_MAX_EXPR (yices_context ctx, tree expr);
static yices_expr make_ABS_EXPR (yices_context ctx, tree expr);
static yices_expr make_LSHIFT_EXPR (yices_context ctx, tree expr);
static yices_expr make_RSHIFT_EXPR (yices_context ctx, tree expr);
static yices_expr make_LROTATE_EXPR (yices_context ctx, tree expr);
static yices_expr make_RROTATE_EXPR (yices_context ctx, tree expr);
static yices_expr make_BIT_IOR_EXPR (yices_context ctx, tree expr);
static yices_expr make_BIT_XOR_EXPR (yices_context ctx, tree expr);
static yices_expr make_BIT_AND_EXPR (yices_context ctx, tree expr);
static yices_expr make_BIT_NOT_EXPR (yices_context ctx, tree expr);
static yices_expr make_TRUTH_ANDIF_EXPR (yices_context ctx, tree expr);
static yices_expr make_TRUTH_ORIF_EXPR (yices_context ctx, tree expr);
static yices_expr make_TRUTH_AND_EXPR (yices_context ctx, tree expr);
static yices_expr make_TRUTH_OR_EXPR (yices_context ctx, tree expr);
static yices_expr make_TRUTH_XOR_EXPR (yices_context ctx, tree expr);
static yices_expr make_TRUTH_NOT_EXPR (yices_context ctx, tree expr);
static yices_expr make_LT_EXPR (yices_context ctx, tree expr);
static yices_expr make_LE_EXPR (yices_context ctx, tree expr);
static yices_expr make_GT_EXPR (yices_context ctx, tree expr);
static yices_expr make_GE_EXPR (yices_context ctx, tree expr);
static yices_expr make_EQ_EXPR (yices_context ctx, tree expr);
static yices_expr make_NE_EXPR (yices_context ctx, tree expr);
static yices_expr make_UNORDERED_EXPR (yices_context ctx, tree expr);
static yices_expr make_ORDERED_EXPR (yices_context ctx, tree expr);
static yices_expr make_UNLT_EXPR (yices_context ctx, tree expr);
static yices_expr make_UNLE_EXPR (yices_context ctx, tree expr);
static yices_expr make_UNGT_EXPR (yices_context ctx, tree expr);
static yices_expr make_UNGE_EXPR (yices_context ctx, tree expr);
static yices_expr make_UNEQ_EXPR (yices_context ctx, tree expr);
static yices_expr make_LTGT_EXPR (yices_context ctx, tree expr);
static yices_expr make_RANGE_EXPR (yices_context ctx, tree expr);
static yices_expr make_PAREN_EXPR (yices_context ctx, tree expr);
static yices_expr make_CONVERT_EXPR (yices_context ctx, tree expr);
static yices_expr make_ADDR_SPACE_CONVERT_EXPR (yices_context ctx, tree expr);
static yices_expr make_FIXED_CONVERT_EXPR (yices_context ctx, tree expr);
static yices_expr make_NOP_EXPR (yices_context ctx, tree expr);
static yices_expr make_NON_LVALUE_EXPR (yices_context ctx, tree expr);
static yices_expr make_VIEW_CONVERT_EXPR (yices_context ctx, tree expr);
static yices_expr make_COMPOUND_LITERAL_EXPR (yices_context ctx, tree expr);
static yices_expr make_SAVE_EXPR (yices_context ctx, tree expr);
static yices_expr make_ADDR_EXPR (yices_context ctx, tree expr);
static yices_expr make_FDESC_EXPR (yices_context ctx, tree expr);
static yices_expr make_COMPLEX_EXPR (yices_context ctx, tree expr);
static yices_expr make_CONJ_EXPR (yices_context ctx, tree expr);
static yices_expr make_PREDECREMENT_EXPR (yices_context ctx, tree expr);
static yices_expr make_PREINCREMENT_EXPR (yices_context ctx, tree expr);
static yices_expr make_POSTDECREMENT_EXPR (yices_context ctx, tree expr);
static yices_expr make_POSTINCREMENT_EXPR (yices_context ctx, tree expr);
static yices_expr make_VA_ARG_EXPR (yices_context ctx, tree expr);
static yices_expr make_TRY_CATCH_EXPR (yices_context ctx, tree expr);
static yices_expr make_TRY_FINALLY_EXPR (yices_context ctx, tree expr);
static yices_expr make_DECL_EXPR (yices_context ctx, tree expr);
static yices_expr make_LABEL_EXPR (yices_context ctx, tree expr);
static yices_expr make_GOTO_EXPR (yices_context ctx, tree expr);
static yices_expr make_RETURN_EXPR (yices_context ctx, tree expr);
static yices_expr make_EXIT_EXPR (yices_context ctx, tree expr);
static yices_expr make_LOOP_EXPR (yices_context ctx, tree expr);
static yices_expr make_SWITCH_EXPR (yices_context ctx, tree expr);
static yices_expr make_CASE_LABEL_EXPR (yices_context ctx, tree expr);
static yices_expr make_ASM_EXPR (yices_context ctx, tree expr);
static yices_expr make_SSA_NAME (yices_context ctx, tree expr);
static yices_expr make_CATCH_EXPR (yices_context ctx, tree expr);
static yices_expr make_EH_FILTER_EXPR (yices_context ctx, tree expr);
static yices_expr make_SCEV_KNOWN (yices_context ctx, tree expr);
static yices_expr make_SCEV_NOT_KNOWN (yices_context ctx, tree expr);
static yices_expr make_POLYNOMIAL_CHREC (yices_context ctx, tree expr);
static yices_expr make_STATEMENT_LIST (yices_context ctx, tree expr);
static yices_expr make_ASSERT_EXPR (yices_context ctx, tree expr);
static yices_expr make_TREE_BINFO (yices_context ctx, tree expr);
static yices_expr make_WITH_SIZE_EXPR (yices_context ctx, tree expr);
static yices_expr make_REALIGN_LOAD_EXPR (yices_context ctx, tree expr);
static yices_expr make_TARGET_MEM_REF (yices_context ctx, tree expr);
static yices_expr make_MEM_REF (yices_context ctx, tree expr);
static yices_expr make_OMP_PARALLEL (yices_context ctx, tree expr);
static yices_expr make_OMP_TASK (yices_context ctx, tree expr);
static yices_expr make_OMP_FOR (yices_context ctx, tree expr);
static yices_expr make_OMP_SECTIONS (yices_context ctx, tree expr);
static yices_expr make_OMP_SINGLE (yices_context ctx, tree expr);
static yices_expr make_OMP_SECTION (yices_context ctx, tree expr);
static yices_expr make_OMP_MASTER (yices_context ctx, tree expr);
static yices_expr make_OMP_ORDERED (yices_context ctx, tree expr);
static yices_expr make_OMP_CRITICAL (yices_context ctx, tree expr);
static yices_expr make_OMP_ATOMIC (yices_context ctx, tree expr);
static yices_expr make_OMP_CLAUSE (yices_context ctx, tree expr);
static yices_expr make_REDUC_MAX_EXPR (yices_context ctx, tree expr);
static yices_expr make_REDUC_MIN_EXPR (yices_context ctx, tree expr);
static yices_expr make_REDUC_PLUS_EXPR (yices_context ctx, tree expr);
static yices_expr make_DOT_PROD_EXPR (yices_context ctx, tree expr);
static yices_expr make_WIDEN_SUM_EXPR (yices_context ctx, tree expr);
static yices_expr make_WIDEN_MULT_EXPR (yices_context ctx, tree expr);
static yices_expr make_WIDEN_MULT_PLUS_EXPR (yices_context ctx, tree expr);
static yices_expr make_WIDEN_MULT_MINUS_EXPR (yices_context ctx, tree expr);
static yices_expr make_FMA_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_LSHIFT_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_RSHIFT_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_WIDEN_MULT_HI_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_WIDEN_MULT_LO_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_UNPACK_HI_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_UNPACK_LO_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_UNPACK_FLOAT_HI_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_UNPACK_FLOAT_LO_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_PACK_TRUNC_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_PACK_SAT_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_PACK_FIX_TRUNC_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_EXTRACT_EVEN_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_EXTRACT_ODD_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_INTERLEAVE_HIGH_EXPR (yices_context ctx, tree expr);
static yices_expr make_VEC_INTERLEAVE_LOW_EXPR (yices_context ctx, tree expr);
static yices_expr make_PREDICT_EXPR (yices_context ctx, tree expr);
static yices_expr make_OPTIMIZATION_NODE (yices_context ctx, tree expr);
static yices_expr make_TARGET_OPTION_NODE (yices_context ctx, tree expr);
static yices_expr make_SYMEE_DECL (yices_context ctx, tree expr);
static yices_expr make_SYMEE_NEWSYM (yices_context ctx, tree expr);
static yices_expr make_SYMEE_ASSIGN (yices_context ctx, tree expr);
static yices_expr make_SYMEE_DELTA (yices_context ctx, tree expr);
static yices_expr make_SYMEE_GAMMA (yices_context ctx, tree expr);
static yices_expr make_SYMEE_MU (yices_context ctx, tree expr);
static yices_expr make_SYMEE_DIRECT_SUM (yices_context ctx, tree expr);
static yices_expr make_SYMEE_THETA (yices_context ctx, tree expr);
static yices_expr make_SYMEE_RHO (yices_context ctx, tree expr);


typedef yices_expr (*make_function_t) (yices_context, tree);

static make_function_t make_functions [MAX_TREE_CODES] = {
  [ERROR_MARK] = make_ERROR_MARK,
  [IDENTIFIER_NODE] = make_IDENTIFIER_NODE,
  [TREE_LIST] = make_TREE_LIST,
  [TREE_VEC] = make_TREE_VEC,
  [BLOCK] = make_BLOCK,
  [OFFSET_TYPE] = make_OFFSET_TYPE,
  [ENUMERAL_TYPE] = make_ENUMERAL_TYPE,
  [BOOLEAN_TYPE] = make_BOOLEAN_TYPE,
  [INTEGER_TYPE] = make_INTEGER_TYPE,
  [REAL_TYPE] = make_REAL_TYPE,
  [POINTER_TYPE] = make_POINTER_TYPE,
  [REFERENCE_TYPE] = make_REFERENCE_TYPE,
  [NULLPTR_TYPE] = make_NULLPTR_TYPE,
  [FIXED_POINT_TYPE] = make_FIXED_POINT_TYPE,
  [COMPLEX_TYPE] = make_COMPLEX_TYPE,
  [VECTOR_TYPE] = make_VECTOR_TYPE,
  [ARRAY_TYPE] = make_ARRAY_TYPE,
  [RECORD_TYPE] = make_RECORD_TYPE,
  [UNION_TYPE] = make_UNION_TYPE,
  [QUAL_UNION_TYPE] = make_QUAL_UNION_TYPE,
  [VOID_TYPE] = make_VOID_TYPE,
  [FUNCTION_TYPE] = make_FUNCTION_TYPE,
  [METHOD_TYPE] = make_METHOD_TYPE,
  [LANG_TYPE] = make_LANG_TYPE,
  [INTEGER_CST] = make_INTEGER_CST,
  [REAL_CST] = make_REAL_CST,
  [FIXED_CST] = make_FIXED_CST,
  [COMPLEX_CST] = make_COMPLEX_CST,
  [VECTOR_CST] = make_VECTOR_CST,
  [STRING_CST] = make_STRING_CST,
  [FUNCTION_DECL] = make_FUNCTION_DECL,
  [LABEL_DECL] = make_LABEL_DECL,
  [FIELD_DECL] = make_FIELD_DECL,
  [VAR_DECL] = make_VAR_DECL,
  [CONST_DECL] = make_CONST_DECL,
  [PARM_DECL] = make_PARM_DECL,
  [TYPE_DECL] = make_TYPE_DECL,
  [RESULT_DECL] = make_RESULT_DECL,
  [DEBUG_EXPR_DECL] = make_DEBUG_EXPR_DECL,
  [NAMESPACE_DECL] = make_NAMESPACE_DECL,
  [IMPORTED_DECL] = make_IMPORTED_DECL,
  [TRANSLATION_UNIT_DECL] = make_TRANSLATION_UNIT_DECL,
  [COMPONENT_REF] = make_COMPONENT_REF,
  [BIT_FIELD_REF] = make_BIT_FIELD_REF,
  [REALPART_EXPR] = make_REALPART_EXPR,
  [IMAGPART_EXPR] = make_IMAGPART_EXPR,
  [ARRAY_REF] = make_ARRAY_REF,
  [ARRAY_RANGE_REF] = make_ARRAY_RANGE_REF,
  [INDIRECT_REF] = make_INDIRECT_REF,
  [OBJ_TYPE_REF] = make_OBJ_TYPE_REF,
  [CONSTRUCTOR] = make_CONSTRUCTOR,
  [COMPOUND_EXPR] = make_COMPOUND_EXPR,
  [MODIFY_EXPR] = make_MODIFY_EXPR,
  [INIT_EXPR] = make_INIT_EXPR,
  [TARGET_EXPR] = make_TARGET_EXPR,
  [COND_EXPR] = make_COND_EXPR,
  [VEC_COND_EXPR] = make_VEC_COND_EXPR,
  [BIND_EXPR] = make_BIND_EXPR,
  [CALL_EXPR] = make_CALL_EXPR,
  [WITH_CLEANUP_EXPR] = make_WITH_CLEANUP_EXPR,
  [CLEANUP_POINT_EXPR] = make_CLEANUP_POINT_EXPR,
  [PLACEHOLDER_EXPR] = make_PLACEHOLDER_EXPR,
  [PLUS_EXPR] = make_PLUS_EXPR,
  [MINUS_EXPR] = make_MINUS_EXPR,
  [MULT_EXPR] = make_MULT_EXPR,
  [POINTER_PLUS_EXPR] = make_POINTER_PLUS_EXPR,
  [TRUNC_DIV_EXPR] = make_TRUNC_DIV_EXPR,
  [CEIL_DIV_EXPR] = make_CEIL_DIV_EXPR,
  [FLOOR_DIV_EXPR] = make_FLOOR_DIV_EXPR,
  [ROUND_DIV_EXPR] = make_ROUND_DIV_EXPR,
  [TRUNC_MOD_EXPR] = make_TRUNC_MOD_EXPR,
  [CEIL_MOD_EXPR] = make_CEIL_MOD_EXPR,
  [FLOOR_MOD_EXPR] = make_FLOOR_MOD_EXPR,
  [ROUND_MOD_EXPR] = make_ROUND_MOD_EXPR,
  [RDIV_EXPR] = make_RDIV_EXPR,
  [EXACT_DIV_EXPR] = make_EXACT_DIV_EXPR,
  [FIX_TRUNC_EXPR] = make_FIX_TRUNC_EXPR,
  [FLOAT_EXPR] = make_FLOAT_EXPR,
  [NEGATE_EXPR] = make_NEGATE_EXPR,
  [MIN_EXPR] = make_MIN_EXPR,
  [MAX_EXPR] = make_MAX_EXPR,
  [ABS_EXPR] = make_ABS_EXPR,
  [LSHIFT_EXPR] = make_LSHIFT_EXPR,
  [RSHIFT_EXPR] = make_RSHIFT_EXPR,
  [LROTATE_EXPR] = make_LROTATE_EXPR,
  [RROTATE_EXPR] = make_RROTATE_EXPR,
  [BIT_IOR_EXPR] = make_BIT_IOR_EXPR,
  [BIT_XOR_EXPR] = make_BIT_XOR_EXPR,
  [BIT_AND_EXPR] = make_BIT_AND_EXPR,
  [BIT_NOT_EXPR] = make_BIT_NOT_EXPR,
  [TRUTH_ANDIF_EXPR] = make_TRUTH_ANDIF_EXPR,
  [TRUTH_ORIF_EXPR] = make_TRUTH_ORIF_EXPR,
  [TRUTH_AND_EXPR] = make_TRUTH_AND_EXPR,
  [TRUTH_OR_EXPR] = make_TRUTH_OR_EXPR,
  [TRUTH_XOR_EXPR] = make_TRUTH_XOR_EXPR,
  [TRUTH_NOT_EXPR] = make_TRUTH_NOT_EXPR,
  [LT_EXPR] = make_LT_EXPR,
  [LE_EXPR] = make_LE_EXPR,
  [GT_EXPR] = make_GT_EXPR,
  [GE_EXPR] = make_GE_EXPR,
  [EQ_EXPR] = make_EQ_EXPR,
  [NE_EXPR] = make_NE_EXPR,
  [UNORDERED_EXPR] = make_UNORDERED_EXPR,
  [ORDERED_EXPR] = make_ORDERED_EXPR,
  [UNLT_EXPR] = make_UNLT_EXPR,
  [UNLE_EXPR] = make_UNLE_EXPR,
  [UNGT_EXPR] = make_UNGT_EXPR,
  [UNGE_EXPR] = make_UNGE_EXPR,
  [UNEQ_EXPR] = make_UNEQ_EXPR,
  [LTGT_EXPR] = make_LTGT_EXPR,
  [RANGE_EXPR] = make_RANGE_EXPR,
  [PAREN_EXPR] = make_PAREN_EXPR,
  [CONVERT_EXPR] = make_CONVERT_EXPR,
  [ADDR_SPACE_CONVERT_EXPR] = make_ADDR_SPACE_CONVERT_EXPR,
  [FIXED_CONVERT_EXPR] = make_FIXED_CONVERT_EXPR,
  [NOP_EXPR] = make_NOP_EXPR,
  [NON_LVALUE_EXPR] = make_NON_LVALUE_EXPR,
  [VIEW_CONVERT_EXPR] = make_VIEW_CONVERT_EXPR,
  [COMPOUND_LITERAL_EXPR] = make_COMPOUND_LITERAL_EXPR,
  [SAVE_EXPR] = make_SAVE_EXPR,
  [ADDR_EXPR] = make_ADDR_EXPR,
  [FDESC_EXPR] = make_FDESC_EXPR,
  [COMPLEX_EXPR] = make_COMPLEX_EXPR,
  [CONJ_EXPR] = make_CONJ_EXPR,
  [PREDECREMENT_EXPR] = make_PREDECREMENT_EXPR,
  [PREINCREMENT_EXPR] = make_PREINCREMENT_EXPR,
  [POSTDECREMENT_EXPR] = make_POSTDECREMENT_EXPR,
  [POSTINCREMENT_EXPR] = make_POSTINCREMENT_EXPR,
  [VA_ARG_EXPR] = make_VA_ARG_EXPR,
  [TRY_CATCH_EXPR] = make_TRY_CATCH_EXPR,
  [TRY_FINALLY_EXPR] = make_TRY_FINALLY_EXPR,
  [DECL_EXPR] = make_DECL_EXPR,
  [LABEL_EXPR] = make_LABEL_EXPR,
  [GOTO_EXPR] = make_GOTO_EXPR,
  [RETURN_EXPR] = make_RETURN_EXPR,
  [EXIT_EXPR] = make_EXIT_EXPR,
  [LOOP_EXPR] = make_LOOP_EXPR,
  [SWITCH_EXPR] = make_SWITCH_EXPR,
  [CASE_LABEL_EXPR] = make_CASE_LABEL_EXPR,
  [ASM_EXPR] = make_ASM_EXPR,
  [SSA_NAME] = make_SSA_NAME,
  [CATCH_EXPR] = make_CATCH_EXPR,
  [EH_FILTER_EXPR] = make_EH_FILTER_EXPR,
  [SCEV_KNOWN] = make_SCEV_KNOWN,
  [SCEV_NOT_KNOWN] = make_SCEV_NOT_KNOWN,
  [POLYNOMIAL_CHREC] = make_POLYNOMIAL_CHREC,
  [STATEMENT_LIST] = make_STATEMENT_LIST,
  [ASSERT_EXPR] = make_ASSERT_EXPR,
  [TREE_BINFO] = make_TREE_BINFO,
  [WITH_SIZE_EXPR] = make_WITH_SIZE_EXPR,
  [REALIGN_LOAD_EXPR] = make_REALIGN_LOAD_EXPR,
  [TARGET_MEM_REF] = make_TARGET_MEM_REF,
  [MEM_REF] = make_MEM_REF,
  [OMP_PARALLEL] = make_OMP_PARALLEL,
  [OMP_TASK] = make_OMP_TASK,
  [OMP_FOR] = make_OMP_FOR,
  [OMP_SECTIONS] = make_OMP_SECTIONS,
  [OMP_SINGLE] = make_OMP_SINGLE,
  [OMP_SECTION] = make_OMP_SECTION,
  [OMP_MASTER] = make_OMP_MASTER,
  [OMP_ORDERED] = make_OMP_ORDERED,
  [OMP_CRITICAL] = make_OMP_CRITICAL,
  [OMP_ATOMIC] = make_OMP_ATOMIC,
  [OMP_CLAUSE] = make_OMP_CLAUSE,
  [REDUC_MAX_EXPR] = make_REDUC_MAX_EXPR,
  [REDUC_MIN_EXPR] = make_REDUC_MIN_EXPR,
  [REDUC_PLUS_EXPR] = make_REDUC_PLUS_EXPR,
  [DOT_PROD_EXPR] = make_DOT_PROD_EXPR,
  [WIDEN_SUM_EXPR] = make_WIDEN_SUM_EXPR,
  [WIDEN_MULT_EXPR] = make_WIDEN_MULT_EXPR,
  [WIDEN_MULT_PLUS_EXPR] = make_WIDEN_MULT_PLUS_EXPR,
  [WIDEN_MULT_MINUS_EXPR] = make_WIDEN_MULT_MINUS_EXPR,
  [FMA_EXPR] = make_FMA_EXPR,
  [VEC_LSHIFT_EXPR] = make_VEC_LSHIFT_EXPR,
  [VEC_RSHIFT_EXPR] = make_VEC_RSHIFT_EXPR,
  [VEC_WIDEN_MULT_HI_EXPR] = make_VEC_WIDEN_MULT_HI_EXPR,
  [VEC_WIDEN_MULT_LO_EXPR] = make_VEC_WIDEN_MULT_LO_EXPR,
  [VEC_UNPACK_HI_EXPR] = make_VEC_UNPACK_HI_EXPR,
  [VEC_UNPACK_LO_EXPR] = make_VEC_UNPACK_LO_EXPR,
  [VEC_UNPACK_FLOAT_HI_EXPR] = make_VEC_UNPACK_FLOAT_HI_EXPR,
  [VEC_UNPACK_FLOAT_LO_EXPR] = make_VEC_UNPACK_FLOAT_LO_EXPR,
  [VEC_PACK_TRUNC_EXPR] = make_VEC_PACK_TRUNC_EXPR,
  [VEC_PACK_SAT_EXPR] = make_VEC_PACK_SAT_EXPR,
  [VEC_PACK_FIX_TRUNC_EXPR] = make_VEC_PACK_FIX_TRUNC_EXPR,
  [VEC_EXTRACT_EVEN_EXPR] = make_VEC_EXTRACT_EVEN_EXPR,
  [VEC_EXTRACT_ODD_EXPR] = make_VEC_EXTRACT_ODD_EXPR,
  [VEC_INTERLEAVE_HIGH_EXPR] = make_VEC_INTERLEAVE_HIGH_EXPR,
  [VEC_INTERLEAVE_LOW_EXPR] = make_VEC_INTERLEAVE_LOW_EXPR,
  [PREDICT_EXPR] = make_PREDICT_EXPR,
  [OPTIMIZATION_NODE] = make_OPTIMIZATION_NODE,
  [TARGET_OPTION_NODE] = make_TARGET_OPTION_NODE,
  [SYMEE_DECL] = make_SYMEE_DECL,
  [SYMEE_NEWSYM] = make_SYMEE_NEWSYM,
  [SYMEE_ASSIGN] = make_SYMEE_ASSIGN,
  [SYMEE_DELTA] = make_SYMEE_DELTA,
  [SYMEE_GAMMA] = make_SYMEE_GAMMA,
  [SYMEE_MU] = make_SYMEE_MU,
  [SYMEE_DIRECT_SUM] = make_SYMEE_DIRECT_SUM,
  [SYMEE_THETA] = make_SYMEE_THETA,
  [SYMEE_RHO] = make_SYMEE_RHO,
};

#define MAKE_FUNCTION(CODE)                     \
  make_functions [CODE]


WRAP2ARGS_DEF (yices_mk_sum)
WRAP2ARGS_DEF (yices_mk_sub)
WRAP2ARGS_DEF (yices_mk_mul)
WRAP2ARGS_DEF (yices_mk_and)
WRAP2ARGS_DEF (yices_mk_or)


static yices_expr
make_ERROR_MARK (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_IDENTIFIER_NODE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TREE_LIST (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TREE_VEC (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_BLOCK (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OFFSET_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ENUMERAL_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_BOOLEAN_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_INTEGER_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_REAL_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_POINTER_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_REFERENCE_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_NULLPTR_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FIXED_POINT_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_COMPLEX_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VECTOR_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ARRAY_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_RECORD_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_UNION_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_QUAL_UNION_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VOID_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FUNCTION_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_METHOD_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_LANG_TYPE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_INTEGER_CST (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_REAL_CST (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FIXED_CST (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_COMPLEX_CST (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VECTOR_CST (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_STRING_CST (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FUNCTION_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_LABEL_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FIELD_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VAR_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_CONST_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_PARM_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TYPE_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_RESULT_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_DEBUG_EXPR_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_NAMESPACE_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_IMPORTED_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRANSLATION_UNIT_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_COMPONENT_REF (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_BIT_FIELD_REF (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_REALPART_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_IMAGPART_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ARRAY_REF (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ARRAY_RANGE_REF (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_INDIRECT_REF (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OBJ_TYPE_REF (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_CONSTRUCTOR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_COMPOUND_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_MODIFY_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_INIT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TARGET_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_COND_EXPR (yices_context ctx, tree expr)
{
  yices_expr c = make_op0 (ctx, expr);
  yices_expr t = make_op1 (ctx, expr);
  yices_expr e = make_op2 (ctx, expr);

  if (c && t && e)
    return yices_mk_ite (ctx, c, t, e);
  
  return NULL;
}


static yices_expr
make_VEC_COND_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_BIND_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_CALL_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_WITH_CLEANUP_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_CLEANUP_POINT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_PLACEHOLDER_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_PLUS_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_MINUS_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_MULT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_POINTER_PLUS_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRUNC_DIV_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_CEIL_DIV_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FLOOR_DIV_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ROUND_DIV_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRUNC_MOD_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_CEIL_MOD_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FLOOR_MOD_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ROUND_MOD_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_RDIV_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_EXACT_DIV_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FIX_TRUNC_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FLOAT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_NEGATE_EXPR (yices_context ctx, tree expr)
{
  yices_expr args [2] = {yices_mk_num (ctx, 0),
                         make_yices_expr (ctx, TREE_OPERAND (expr, 0))};

  return yices_mk_sub (ctx, args, 2);
}


static yices_expr
make_MIN_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_MAX_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ABS_EXPR (yices_context ctx, tree expr)
{
  yices_expr t = make_yices_expr (ctx, TREE_OPERAND (expr, 0));
  yices_expr zero = yices_mk_num (ctx, 0);
  if (!t || !zero)
    return NULL;
      
  yices_expr c = yices_mk_ge (ctx, t, zero);
  yices_expr sub_args[2] = {zero, t};
  yices_expr e = yices_mk_sub (ctx, sub_args, 2);
  if (!c || !e)
    return NULL;
  
  yices_expr abs = yices_mk_ite (ctx, c, t, e);

  return abs;
}


static yices_expr
make_LSHIFT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_RSHIFT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_LROTATE_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_RROTATE_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_BIT_IOR_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_BIT_XOR_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_BIT_AND_EXPR (yices_context ctx, tree expr)
{
  return NULL;
  
  char name[4096];
  get_expr_string (expr, name);
  yices_expr x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
  yices_expr y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
  yices_expr z = make_var_from_decl_name (ctx, name);
  if (!x || !y || !z)
    return NULL;
  // yices_expr e = yices_mk_bv_and (ctx, x, y);	/* x & y */
  yices_mk_le (ctx, z, x);
  yices_mk_le (ctx, z, y);
  
  return z;

  return NULL;
}


static yices_expr
make_BIT_NOT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRUTH_ANDIF_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRUTH_ORIF_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRUTH_AND_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRUTH_OR_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRUTH_XOR_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRUTH_NOT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_LT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_LE_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_GT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_GE_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_EQ_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_NE_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_UNORDERED_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ORDERED_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_UNLT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_UNLE_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_UNGT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_UNGE_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_UNEQ_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_LTGT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_RANGE_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_PAREN_EXPR (yices_context ctx, tree expr)
{
  return make_yices_expr (ctx, TREE_OPERAND (expr, 0));
}


static yices_expr
make_CONVERT_EXPR (yices_context ctx, tree expr)
{
  return make_yices_expr (ctx, TREE_OPERAND (expr, 0));
}


static yices_expr
make_ADDR_SPACE_CONVERT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FIXED_CONVERT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_NOP_EXPR (yices_context ctx, tree expr)
{
  return make_yices_expr (ctx, TREE_OPERAND (expr, 0));
}


static yices_expr
make_NON_LVALUE_EXPR (yices_context ctx, tree expr)
{
  return make_yices_expr (ctx, TREE_OPERAND (expr, 0));
}


static yices_expr
make_VIEW_CONVERT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_COMPOUND_LITERAL_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SAVE_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ADDR_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FDESC_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_COMPLEX_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_CONJ_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_PREDECREMENT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_PREINCREMENT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_POSTDECREMENT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_POSTINCREMENT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VA_ARG_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRY_CATCH_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TRY_FINALLY_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_DECL_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_LABEL_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_GOTO_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_RETURN_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_EXIT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_LOOP_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SWITCH_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_CASE_LABEL_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ASM_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static char lname[1000000];

static yices_expr
make_SSA_NAME (yices_context ctx, tree expr)
{

  int len = get_expr_string (expr, lname);

  symee_assert (len < 1024, (stderr, "too short name buffer\n"));

  char* yname = make_yices_name (lname);
  yices_var_decl ydecl = yices_get_var_decl_from_name (ctx, yname);
  if (!ydecl) {
    yices_type ytype = make_yices_type (ctx, TREE_TYPE (expr));
    ydecl = yices_mk_var_decl (ctx, yname, ytype);
  }

  if (ydecl)
    return yices_mk_var_from_decl (ctx, ydecl);

  return NULL;
}


static yices_expr
make_CATCH_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_EH_FILTER_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SCEV_KNOWN (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SCEV_NOT_KNOWN (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_POLYNOMIAL_CHREC (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_STATEMENT_LIST (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_ASSERT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TREE_BINFO (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_WITH_SIZE_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_REALIGN_LOAD_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TARGET_MEM_REF (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_MEM_REF (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_PARALLEL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_TASK (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_FOR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_SECTIONS (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_SINGLE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_SECTION (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_MASTER (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_ORDERED (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_CRITICAL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_ATOMIC (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OMP_CLAUSE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_REDUC_MAX_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_REDUC_MIN_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_REDUC_PLUS_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_DOT_PROD_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_WIDEN_SUM_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_WIDEN_MULT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_WIDEN_MULT_PLUS_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_WIDEN_MULT_MINUS_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_FMA_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_LSHIFT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_RSHIFT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_WIDEN_MULT_HI_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_WIDEN_MULT_LO_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_UNPACK_HI_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_UNPACK_LO_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_UNPACK_FLOAT_HI_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_UNPACK_FLOAT_LO_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_PACK_TRUNC_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_PACK_SAT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_PACK_FIX_TRUNC_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_EXTRACT_EVEN_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_EXTRACT_ODD_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_INTERLEAVE_HIGH_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_VEC_INTERLEAVE_LOW_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_PREDICT_EXPR (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_OPTIMIZATION_NODE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_TARGET_OPTION_NODE (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SYMEE_DECL (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SYMEE_NEWSYM (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SYMEE_ASSIGN (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SYMEE_DELTA (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SYMEE_GAMMA (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SYMEE_MU (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SYMEE_DIRECT_SUM (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SYMEE_THETA (yices_context ctx, tree expr)
{
  return NULL;
}


static yices_expr
make_SYMEE_RHO (yices_context ctx, tree expr)
{
  return NULL;
}


/* end of ... */


static yices_expr
default_make_yices_expr (yices_context ctx, tree expr)
{
  make_function_t func = MAKE_FUNCTION (TREE_CODE (expr));
  symee_assert (func, (stderr, "no make_function for %s",
                       tree_code_name [TREE_CODE (expr)]));
  return func (ctx, expr);
}


int
get_expr_string (tree expr, char *name)
{
  extern char* print_generic_expr_to_string (tree t, int flags);
  char* expr_text = print_generic_expr_to_string (expr, 0);
  char* p = expr_text;
  char* q = name;
  int real_len = strlen (expr_text);
  
  /* TODO: cascaded symee_rho and symee_direct_sum can be very long */
  symee_assert (real_len < 1000000,
                (stderr, "%s: too long expr string %d\n", __FUNC__, real_len));
  gcc_assert (real_len < 1000000);
  
  while (*p != '\0') {
    if (*p == '$' || *p == '.') {
      *q = '_'; q++;
    }
    else if (*p == '\n') {
      ;
    }
    else {
      *q = *p; q++;
    }

    p++;
  }

  *q = '\0';
  
  XDELETEVEC (expr_text);

  return strlen (name);
}


#if 0
/* name is large enough, return the length of name */

static int
get_expr_string (tree expr, char *name)
{
  FILE *fpw, *fpr;
  int name_len = 0;
  fpw = fopen ("tmp_dump", "w");
  fpr = fopen ("tmp_dump", "r");
  print_generic_stmt (fpw, expr, 0);
  name_len = ftell (fpw);
  fread (name, 1, name_len, fpr);
  fclose (fpw);
  fclose (fpr);
  name_len = name_len - 1;
  name[name_len] = '\0';
  return name_len;
}
#endif


static yices_expr
make_var_from_decl_name (yices_context ctx, char *name)
{
  yices_var_decl xdecl;
  yices_expr x;
  yices_type ty = yices_mk_type (ctx, "int");
  xdecl = yices_get_var_decl_from_name (ctx, name);
  if (!xdecl)
    xdecl = yices_mk_var_decl (ctx, name, ty);
  x = yices_mk_var_from_decl (ctx, xdecl);
  return x;
}


static inline char*
make_yices_name (const char* name)
{
  return (char*) name;
}


static char*
make_yices_type_name (tree ttype)
{
  static const char* namevec[] = {"uninterpreted-type", "bool", "int", "real"};
  int i = 0;
  
  switch (TREE_CODE (ttype)) {
  case BOOLEAN_TYPE:
    i = 1;
    break;

  case ENUMERAL_TYPE:
  case INTEGER_TYPE:
    i = 2;
    break;

  case REAL_TYPE:
    i = 3;
    break;
    
  default:
    break;
  }

  return namevec [i];
}


static yices_type
make_yices_type (yices_context ctx, tree ttype)
{
  
  char *type_name = make_yices_type_name (ttype);
  yices_type ytype = yices_mk_type (ctx, type_name);

  
  return ytype;
}


static yices_var_decl
make_yices_decl (yices_context ctx, tree decl)
{
  yices_type ytype = make_yices_type (ctx, TREE_TYPE (decl));
  char* yname = make_yices_name (IDENTIFIER_POINTER (DECL_NAME (decl)));
  yices_var_decl ydecl = yices_get_var_decl_from_name (ctx, yname);

  if (!ydecl)
    ydecl = yices_mk_var_decl (ctx, yname, ytype);

  return ydecl;
}


static yices_expr
make_yices_var_from_decl (yices_context ctx, tree decl)
{
  yices_var_decl ydecl = make_yices_decl (ctx, decl);
  yices_expr yexpr = yices_mk_var_from_decl (ctx, ydecl);

  return yexpr;
}


static yices_expr
make_yices_expr_tcc_exceptional (yices_context ctx, tree expr)
{
  switch (TREE_CODE (expr)) {
  case ERROR_MARK:
  case IDENTIFIER_NODE:
  case TREE_LIST:
  case TREE_VEC:
  case BLOCK:
  case CONSTRUCTOR:
  case PLACEHOLDER_EXPR:
  case SSA_NAME:
  case STATEMENT_LIST:
  case TREE_BINFO:
  case OMP_CLAUSE:
  case OPTIMIZATION_NODE:
  case TARGET_OPTION_NODE:
  default:
    break;
  }

  return NULL;
}


static yices_expr
make_yices_expr_tcc_constant (yices_context ctx, tree expr)
{
  enum tree_code code = TREE_CODE (expr);
  yices_expr yexpr = NULL;
  
  switch (code)
    {
    case INTEGER_CST:
      yexpr = yices_mk_num (ctx, int_cst_value (expr));
      break;
      
    case REAL_CST:
#if 0
      {
        char string[60];
        REAL_VALUE_TYPE d = TREE_REAL_CST (expr);
        real_to_decimal (string, &d, sizeof (string), 0, 1);
        yexpr = yices_mk_num_from_string (ctx, string);
      }
#endif
      break;

    case FIXED_CST:
    case COMPLEX_CST:
    case VECTOR_CST:
    case STRING_CST:
    default:
      symee_assert (0, (stderr, "NYI: yices can not process %s\n", tree_code_name [code]));
      break;
    }

  
  return yexpr;
}


static yices_expr
make_yices_expr_tcc_reference (yices_context ctx, tree expr)
{
  switch (TREE_CODE (expr)) {
  case COMPONENT_REF:
  case BIT_FIELD_REF:
  case REALPART_EXPR:
  case IMAGPART_EXPR:
  case ARRAY_REF:
  case ARRAY_RANGE_REF:
  case INDIRECT_REF:
  case VIEW_CONVERT_EXPR:
  case TARGET_MEM_REF:
  case MEM_REF:
  default:
    break;
  }
  
  return NULL;
}


static yices_expr
make_yices_expr_tcc_comparison (yices_context ctx, tree expr)
{
  yices_expr ret_yexpr = NULL;
  yices_expr a1 = NULL, a2 = NULL;
  yices_binary_function yfunc = NULL;

  yfunc = YICES_FUNCTION (TREE_CODE (expr));
  
  if (yfunc) {
    a1 = make_yices_expr (ctx, TREE_OPERAND (expr, 0));
    a2 = make_yices_expr (ctx, TREE_OPERAND (expr, 1));
    if (a1 && a2)
      ret_yexpr = yfunc (ctx, a1, a2);
  }

  
  return ret_yexpr;
}


static yices_expr
make_yices_expr_tcc_unary (yices_context ctx, tree expr)
{
  yices_expr ret_yexpr = NULL;
  yices_expr a1 = NULL;
  yices_unary_function yfunc = NULL;


  yfunc = YICES_FUNCTION (TREE_CODE (expr));
  
  if (yfunc) {
    a1 = make_yices_expr (ctx, TREE_OPERAND (expr, 0));
    if (a1)
      ret_yexpr = yfunc (ctx, a1);
  }

  
  return ret_yexpr;
}


static yices_expr
make_yices_expr_tcc_binary (yices_context ctx, tree expr)
{
  yices_expr ret_yexpr = NULL;
  yices_expr a1 = NULL, a2 = NULL;
  yices_binary_function yfunc = NULL;


  yfunc = YICES_FUNCTION (TREE_CODE (expr));
  
  if (yfunc) {
    a1 = make_yices_expr (ctx, TREE_OPERAND (expr, 0));
    a2 = make_yices_expr (ctx, TREE_OPERAND (expr, 1));
    if (a1 && a2)
      ret_yexpr = yfunc (ctx, a1, a2);
  }

  
  return ret_yexpr;
}


static yices_expr
make_yices_expr_tcc_expression (yices_context ctx, tree expr)
{
  enum tree_code code = TREE_CODE (expr);
  switch (code) {
  case OBJ_TYPE_REF:
  case COMPOUND_EXPR:
  case MODIFY_EXPR:
  case INIT_EXPR:
  case TARGET_EXPR:
  case COND_EXPR:
  case VEC_COND_EXPR:
  case BIND_EXPR:
  case WITH_CLEANUP_EXPR:
  case CLEANUP_POINT_EXPR:
  case TRUTH_ANDIF_EXPR:
  case TRUTH_ORIF_EXPR:
    break;

  case TRUTH_AND_EXPR:
  case TRUTH_OR_EXPR:
    return make_yices_expr_tcc_binary (ctx, expr);
    break;

  case TRUTH_XOR_EXPR:
  case TRUTH_NOT_EXPR:
  case COMPOUND_LITERAL_EXPR:
  case SAVE_EXPR:
  case ADDR_EXPR:
  case FDESC_EXPR:
  case PREDECREMENT_EXPR:
  case PREINCREMENT_EXPR:
  case POSTDECREMENT_EXPR:
  case POSTINCREMENT_EXPR:
  case VA_ARG_EXPR:
  case SCEV_KNOWN:
  case SCEV_NOT_KNOWN:
  case POLYNOMIAL_CHREC:
  case ASSERT_EXPR:
  case WITH_SIZE_EXPR:
  case REALIGN_LOAD_EXPR:
  case DOT_PROD_EXPR:
  case WIDEN_MULT_PLUS_EXPR:
  case WIDEN_MULT_MINUS_EXPR:
  case FMA_EXPR:
  case PREDICT_EXPR:
    break;
    
  case SYMEE_NEWSYM:
  case SYMEE_ASSIGN:
  case SYMEE_DELTA:
  case SYMEE_GAMMA:
  case SYMEE_MU:
  case SYMEE_DIRECT_SUM:
  case SYMEE_THETA:
  case SYMEE_RHO:
  default:
    break;
  }
  
  return NULL;
}


static yices_expr
make_yices_expr (yices_context ctx, tree expr)
{
  enum tree_code_class code_class = TREE_CODE_CLASS (TREE_CODE (expr));
  yices_expr yexpr = NULL;
  make_function_t make_func = MAKE_FUNCTION (TREE_CODE (expr));

  if (make_func)
    yexpr = make_func (ctx, expr);

  if (yexpr)
    return yexpr;
  
  switch (code_class) {
  case tcc_exceptional:
    yexpr = make_yices_expr_tcc_exceptional (ctx, expr);
    break;
    
  case tcc_constant:
    yexpr = make_yices_expr_tcc_constant (ctx, expr);
    break;
    
  case tcc_type:
    yexpr = make_yices_type (ctx, expr);
    break;
    
  case tcc_declaration:
    yexpr = make_yices_var_from_decl (ctx, expr);
    break;
    
  case tcc_reference:
    yexpr = make_yices_expr_tcc_reference (ctx, expr);
    break;
    
  case tcc_comparison:
    yexpr = make_yices_expr_tcc_comparison (ctx, expr);
    break;
    
  case tcc_unary:
    yexpr = make_yices_expr_tcc_unary (ctx, expr);
    break;
    
  case tcc_binary:
    yexpr = make_yices_expr_tcc_binary (ctx, expr);
    break;
    
  case tcc_statement:
  case tcc_vl_exp:
    symee_assert (0, (stderr, "NYI: symbolic yices can not process %s\n",
                      TREE_CODE_CLASS_STRING (code_class)));
    break;

  case tcc_expression:
    yexpr = make_yices_expr_tcc_expression (ctx, expr);
    break;
    
  default:
    break;
  }

  if (!yexpr)
    yexpr = emit_yices_expr_from_tree (ctx, expr);

  symee_assert (yexpr, (stderr, "can not convert %s into yices expression\n",
                        tree_code_name [TREE_CODE (expr)]));
  
  return yexpr;
}


static char name[1000000];

/* If taken_addr==1, emit the address of the tree.
   address of variable p : __addr_p
   dereference of p : __deref_p */

static yices_expr
emit_yices_expr_from_tree (yices_context ctx, tree expr)
{

  yices_type ty = yices_mk_type (ctx, "int");
  yices_expr x;
  yices_expr y;
  yices_expr z;
  yices_expr args[3];
  const char *addr_prefix = "&";
  int addr_prefix_len = strlen (addr_prefix);

  switch (TREE_CODE (expr))
    {
    case INTEGER_CST:
      {
	x = yices_mk_num (ctx, int_cst_value (expr));
	return x;
      }

    case SSA_NAME:
      {
        get_expr_string (expr, name);
	x = make_var_from_decl_name (ctx, name);
	return x;
      }

    case VAR_DECL:
    case PARM_DECL:
      {
	get_expr_string (expr, name);
	x = make_var_from_decl_name (ctx, name);
	return x;

      }
#if 0
    case ADDR_EXPR:
      {
	get_expr_string (expr, name);
	x = make_var_from_decl_name (ctx, name);
	return x;
      }

    case MEM_REF:
      {
	get_expr_string (expr, name);
	x = make_var_from_decl_name (ctx, name);
	return x;
      }

    case ARRAY_REF:
      {
	get_expr_string (expr, name);
	x = make_var_from_decl_name (ctx, name);
	return x;


      }

    case COMPONENT_REF:
      {
	get_expr_string (expr, name);
	x = make_var_from_decl_name (ctx, name);
	return x;
      }
#endif
    case PLUS_EXPR:
    case POINTER_PLUS_EXPR:
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	args[0] = x;
	args[1] = y;
	yices_expr e = yices_mk_sum (ctx, args, 2);	/* x + y */
	return e;

      }

    case MINUS_EXPR:
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	args[0] = x;
	args[1] = y;
	yices_expr e = yices_mk_sub (ctx, args, 2);	/* x - y */
	return e;

      }

    case MULT_EXPR:
      {
	//                      return NULL;
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	args[0] = x;
	args[1] = y;
	yices_expr e = yices_mk_mul (ctx, args, 2);	/* x * y */
	return e;
      }
#if YICES_BITFIELD
    case BIT_NOT_EXPR:
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	if (!x)
	  return NULL;
	yices_expr e = yices_mk_bv_not (ctx, x);	/* ~x */
	return e;
      }

    case BIT_IOR_EXPR:
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	yices_expr e = yices_mk_bv_or (ctx, x, y);	/* x | y */
	return e;
      }

    case BIT_XOR_EXPR:
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	yices_expr e = yices_mk_bv_xor (ctx, x, y);	/* x ^ y */
	return e;
      }

    case BIT_AND_EXPR:
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	yices_expr e = yices_mk_bv_and (ctx, x, y);	/* x & y */
	return e;
      }

    case BIT_IOR_EXPR:
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	yices_expr e = yices_mk_bv_or (ctx, x, y);	/* x ^ y */
	return e;
      }
#endif
    case NEGATE_EXPR:
      {
	x = yices_mk_num (ctx, 0);
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	if (!x || !y)
	  return NULL;
	args[0] = x;
	args[1] = y;
	yices_expr e = yices_mk_sub (ctx, args, 2);	/* 0 - x */
	return e;
      }


    case EQ_EXPR:
      /* x == y */
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	return yices_mk_eq (ctx, x, y);
      }
      break;

    case NE_EXPR:
      /* x != y ==> !(x == y) */
      {
	yices_expr z = NULL;
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	z = yices_mk_eq (ctx, x, y);
	return yices_mk_not (ctx, z);
      }
      break;

    case GT_EXPR:
      /* x > y */
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	return yices_mk_gt (ctx, x, y);
      }
      break;

    case GE_EXPR:
      /* x >= y */
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	return yices_mk_ge (ctx, x, y);
      }
      break;

    case LT_EXPR:
      /* x < y */
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	return yices_mk_lt (ctx, x, y);
      }
      break;

    case LE_EXPR:
      /* x < y */
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	return yices_mk_le (ctx, x, y);
      }
      break;

    case TRUTH_NOT_EXPR:
      /* !x */
      {
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	if (!x)
	  return NULL;
	return yices_mk_not (ctx, x);
      }
      break;

    case TRUTH_OR_EXPR:
      /* x || y */
      {
	yices_expr args[2];
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	args[0] = x;
	args[1] = y;
	return yices_mk_or (ctx, args, 2);
      }
      break;

    case TRUTH_AND_EXPR:
      /* x && y */
      {
	yices_expr args[2];
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y)
	  return NULL;
	args[0] = x;
	args[1] = y;
	return yices_mk_and (ctx, args, 2);
      }
      break;

    case NOP_EXPR:
    case CONVERT_EXPR:
      return emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));

    case EXACT_DIV_EXPR:
    case TRUNC_DIV_EXPR:
    case TRUNC_MOD_EXPR:
    case RSHIFT_EXPR:
    case LSHIFT_EXPR:
      return NULL;

    case COND_EXPR:
      {
	yices_expr cond =
	  emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 2));
	if (!x || !y || !cond)
	  return NULL;
	return yices_mk_ite (ctx, cond, x, y);	/* (if cond x y) */
      }

    case MAX_EXPR:
      {
	tree gt_expr = build2 (GT_EXPR, boolean_type_node,
			       TREE_OPERAND (expr, 0),
			       TREE_OPERAND (expr, 1));
	yices_expr cond = emit_yices_expr_from_tree (ctx, gt_expr);
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y || !cond)
	  return NULL;
	return yices_mk_ite (ctx, cond, x, y);	/* (if cond x y) */
      }

    case MIN_EXPR:
      {
	tree lt_expr = build2 (LT_EXPR, boolean_type_node,
			       TREE_OPERAND (expr, 0),
			       TREE_OPERAND (expr, 1));
	yices_expr cond = emit_yices_expr_from_tree (ctx, lt_expr);
	x = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 0));
	y = emit_yices_expr_from_tree (ctx, TREE_OPERAND (expr, 1));
	if (!x || !y || !cond)
	  return NULL;
	return yices_mk_ite (ctx, cond, x, y);	/* (if cond x y) */
      }

    default:
      {
        if (dump_file && (dump_flags & TDF_DETAILS))
          fprintf (dump_file, "symee: yices can not process tree code %s\n",
                   tree_code_name [TREE_CODE (expr)]);

        return NULL;
      }
      break;

    }

  return NULL;
}


/* search lhs in expr */

static bool
search_in_ref (tree expr, tree lhs)
{

  if (operand_equal_p (expr, lhs, 0))
    return true;

  if (TREE_CODE (expr) == ADDR_EXPR)
    return false;

  bool found = false;
  int i;
  int n = TREE_OPERAND_LENGTH (expr);
  for (i = 0; i < n; i++)
    {
      tree opnd = TREE_OPERAND (expr, i);
      if (!opnd)
	continue;
      if (operand_equal_p (opnd, lhs, 0))
	{
	  return true;
	}
      else if (search_in_ref (opnd, lhs))
	found = true;
    }

  return found;

}


/* check whether symbols in A all appear in B */

static inline bool
check_symbol_version (tree a, tree b)
{
  switch (TREE_CODE (a))
    {
      /* atomic symbol */
    case VAR_DECL:
    case PARM_DECL:
    case SSA_NAME:
    case ADDR_EXPR:
    case INDIRECT_REF:
    case MEM_REF:
    case ARRAY_REF:
    case COMPONENT_REF:
      return search_in_ref (b, a);

    case INTEGER_CST:
      return true;

    default:
      {
	int i;
	int n = TREE_OPERAND_LENGTH (a);
	for (i = 0; i < n; i++)
	  {
	    tree opnd = TREE_OPERAND (a, i);
	    if (!opnd)
	      continue;
	    if (!check_symbol_version (opnd, b))
	      return false;
	  }

	return true;
      }
    }
}


#define RECURRENCE_STATISTICS 1

#ifdef RECURRENCE_STATISTICS

struct symee_yices_stats {
  int num_const_true;
  int num_const_true_succ;

  int num_const_false;
  int num_const_false_succ;
  
  int num_equal;
  int num_equal_succ;
};

struct symee_yices_stats ystats;

int flag_symee_yices_stats = 1;

void
symee_yices_stats_start (void)
{
  memset (&ystats, 0, sizeof (struct symee_yices_stats));
}


void
symee_yices_stats_print (FILE* fp)
{
  fprintf (fp, "symee_yices_stats:");
  fprintf (fp, " const_true %d -> %d", ystats.num_const_true, ystats.num_const_true_succ);
  fprintf (fp, " const_false %d -> %d", ystats.num_const_false, ystats.num_const_false_succ);
  fprintf (fp, " equal %d -> %d", ystats.num_equal, ystats.num_equal_succ);
  fprintf (fp, "\n");
}


#define SYMEE_YICES_STATS_INC(field)            \
  if (flag_symee_yices_stats)                   \
    ystats.field++;


#else
void symee_yices_stats_start (void) { return; }
void symee_yices_stats_print (FILE *fp) { return; }
#define SYMEE_YICES_STATS_INC(field)
#endif


/* Invoke SMT Solver YICES to prove whether the runtime value of a equals to that of b*/
extern bool
symee_value_equal_p (tree a, tree b)
{
  if (operand_equal_p (a, b, 0))
    return true;

  /* if A and B contains different symbols, return false */
  if (!check_symbol_version (a, b) || !check_symbol_version (b, a))
    {;
    }				//return false;

  bool result = false;
  yices_context ctx = yices_mk_context ();
  yices_expr x = emit_yices_expr_from_tree (ctx, a);
  yices_expr y = emit_yices_expr_from_tree (ctx, b);

  if (!x || !y)
    return false;

  yices_expr e = yices_mk_diseq (ctx, x, y);
  yices_assert (ctx, e);
  if (yices_check (ctx) == l_false)
    result = true;
  yices_del_context (ctx);
  return result;
}


/* Invoke SMT Solver YICES to prove whether the runtime address of a less than that of b*/
extern bool
symee_value_less_p (tree a, tree b)
{
  if (operand_equal_p (a, b, 0))
    return false;

  /* if A and B contains different symbols, return false */
  if (!check_symbol_version (a, b) || !check_symbol_version (b, a))
    return false;

  bool result = false;
  yices_context ctx = yices_mk_context ();
  yices_expr x = emit_yices_expr_from_tree (ctx, a);
  yices_expr y = emit_yices_expr_from_tree (ctx, b);

  if (!x || !y)
    return false;

  yices_expr e = yices_mk_ge (ctx, x, y);
  yices_assert (ctx, e);
  if (yices_check (ctx) == l_false)
    result = true;
  yices_del_context (ctx);
  return result;
}


/* Invoke SMT Solver YICES to prove whether the runtime address of a less than or equals to that of b*/
static bool
value_less_or_equal_p (tree a, tree b)
{

  if (operand_equal_p (a, b, 0))
    return true;

  /* if A and B contains different symbols, return false */
  if (!check_symbol_version (a, b) || !check_symbol_version (b, a))
    return false;

  bool result = false;
  yices_context ctx = yices_mk_context ();
  yices_expr x = emit_yices_expr_from_tree (ctx, a);
  yices_expr y = emit_yices_expr_from_tree (ctx, b);

  if (!x || !y)
    return false;

  yices_expr e = yices_mk_gt (ctx, x, y);
  yices_assert (ctx, e);
  if (yices_check (ctx) == l_false)
    result = true;
  yices_del_context (ctx);
  return result;
}


extern bool
symee_always_equal_p (tree a, tree b)
{
  if (operand_equal_p (a, b, 0))
    return true;

  bool result = false;
  yices_context ctx = yices_mk_context ();
  yices_expr x = emit_yices_expr_from_tree (ctx, a);
  yices_expr y = emit_yices_expr_from_tree (ctx, b);

  if (!x || !y)
    return false;

  yices_expr e = yices_mk_diseq (ctx, x, y);
  yices_assert (ctx, e);
  if (yices_check (ctx) == l_false)
    result = true;
  yices_del_context (ctx);
  return result;
}


extern bool
symee_is_const_true_1 (tree a)
{
  bool result = false;
  yices_context ctx = yices_mk_context ();
  yices_expr x;
  yices_expr y;
#if 0
  if (symee_always_equal_p (a, boolean_true_node))
    return true;

  if (symee_always_equal_p (a, boolean_false_node))
    return false;
#endif
  x = make_yices_expr (ctx, a);

  if (!x)
    return false;

  y = yices_mk_not (ctx, x);

  if (!y)
    return false;
  
  yices_assert (ctx, y);

  if (yices_check (ctx) == l_false)
    result = true;

  yices_del_context (ctx);

  return result;
}

extern bool
symee_is_const_true (tree a)
{
  SYMEE_YICES_STATS_INC (num_const_true);
  bool ret = symee_is_const_true_1 (a);
  if (ret)
    SYMEE_YICES_STATS_INC (num_const_true_succ);

  return ret;
}


extern bool
symee_is_const_false_1 (tree a)
{
  bool result = false;
  yices_context ctx = yices_mk_context ();
  yices_expr x;
#if 0
  if (symee_always_equal_p (a, boolean_false_node))
    return true;

  if (symee_always_equal_p (a, boolean_true_node))
    return false;
#endif
  x = make_yices_expr (ctx, a);

  if (!x)
    return false;

  yices_assert (ctx, x);

  if (yices_check (ctx) == l_false)
    result = true;

  yices_del_context (ctx);

  return result;
}


extern bool
symee_is_const_false (tree a)
{
  SYMEE_YICES_STATS_INC (num_const_false);
  bool ret = symee_is_const_false_1 (a);
  if (ret)
    SYMEE_YICES_STATS_INC (num_const_false_succ);

  return ret;
}


extern bool
symee_implies (tree a, tree b)
{
  bool result = false;
  yices_context ctx = yices_mk_context ();
  yices_expr x, y, args[2], imp;

  if (symee_always_equal_p (a, boolean_false_node))
    return true;

  if (symee_always_equal_p (b, boolean_true_node))
    return true;

  if (symee_always_equal_p (b, boolean_false_node))
    return false;

  x = make_yices_expr (ctx, a);
  y = make_yices_expr (ctx, b);
  
  if (!x || !y)
    return false;
  
  args[0] = yices_mk_not (ctx, x);;
  args[1] = y;
  imp = yices_mk_or (ctx, args, 2);
  yices_assert (ctx, yices_mk_not (ctx, imp));

  if (yices_check (ctx) == l_false)
    result = true;

  yices_del_context (ctx);

  return result;
}

#else

extern bool
symee_value_equal_p (tree a, tree b)
{
  return false;
}


extern bool
symee_value_less_p (tree a, tree b)
{
  return false;
}


extern bool
symee_value_less_or_equal_p (tree a, tree b)
{
  return false;
}


extern bool
symee_is_const_true (tree a)
{
  return false;
}


extern bool
symee_is_const_false (tree a)
{
  return false;
}


extern bool
symee_implies (tree a, tree b)
{
  return false;
}

#endif

