/* symbolic-simplify.c -*- c-*- */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tree.h"
#include "target.h"
#include "gimple.h"
#include "cgraph.h"
#include "flags.h"
#include "timevar.h"
#include "diagnostic.h"
#include "params.h"
#include "cfgloop.h"
#include "pointer-set.h"
#include "bitmap.h"
#include "tree-flow.h"
#include "tree-pass.h"
#include "tree-chrec.h"
#include "tree-scalar-evolution.h"
#include "tree-data-ref.h"
#include "tree-pretty-print.h"
#include "tree-dump.h"
#include <string.h>

#include "symbolic-expr-eval.h"


extern tree
symee_simplify_cond_expr_with_condition (tree cond_expr, tree condition)
{
  tree post_condition = TREE_OPERAND (cond_expr, 0);
  tree t1 = build1 (TRUTH_NOT_EXPR, boolean_type_node, condition);
  tree t2 = build2 (TRUTH_OR_EXPR, boolean_type_node, t1, post_condition);

  /* 'condition' -> 'post_condition' */
  tree fold_expr = fold (t2);
  if (fold_expr == boolean_true_node)
    return TREE_OPERAND (cond_expr, 1);

  tree t3 = build2 (TRUTH_NOT_EXPR, boolean_type_node, condition, post_condition);
  tree t4 = build2 (TRUTH_OR_EXPR, boolean_type_node, condition, t3);

  /* 'conditon' -> not 'post_condition' */
  fold_expr = fold (t4);
  if (fold_expr == boolean_false_node)
    return TREE_OPERAND (cond_expr, 2);

  /* by yices */
  if (implies (condition, post_condition))
    return TREE_OPERAND (cond_expr, 1);
  if (implies (condition, t3))
    return TREE_OPERAND (cond_expr, 2);
  
  return cond_expr;
}


extern void
symee_simplify_cond_expr_tree_with_condition (tree expr, tree condition)
{
  
}

