/* symbolic-analysis.h  -*- c -*- */

#ifndef GCC_SYMBOLIC_ANALYSIS_H
#define GCC_SYMBOLIC_ANALYSIS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tree.h"
#include "target.h"
#include "gimple.h"
#include "cgraph.h"
#include "flags.h"
#include "timevar.h"
#include "diagnostic.h"
#include "params.h"
#include "cfgloop.h"
#include "pointer-set.h"
#include "bitmap.h"
#include "tree-flow.h"
#include "tree-pass.h"
#include "tree-chrec.h"
#include "tree-scalar-evolution.h"
#include "tree-data-ref.h"
#include "tree-pretty-print.h"
#include "tree-dump.h"
#include <string.h>

#include "tree-vrp.h"
#include "symbolic-expr-eval.h"
#include "symbolic-yices.h"

/* symee client */


/* alias */
extern unsigned int symee_init_alias (void);
extern void symee_fini_alias (void);
extern bool symee_refs_may_alias_p (tree ref1, tree ref2);
extern bool symee_refs_must_alias_p (tree ref1, tree ref2);
extern bool symee_dr_may_alias_p (struct data_reference *ref1, struct data_reference *ref2);


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* GCC_SYMBOLIC_ANALYSIS_H */

