/* symbolic-alias.cxx */

#include "ipa-check-dependence.h"

extern "C" {
#include "symbolic-expr-eval.h"
}

/* interface to bootstraping alias analysis */

bool
symee_dr_may_alias_p (struct data_reference *ref1,
                      struct data_reference *ref2)
{
  ipa_data_reference_p ipa_dr1 = symee_get_ipa_data_reference_for_tree (ref1->stmt, ref1->ref);
  ipa_data_reference_p ipa_dr2 = symee_get_ipa_data_reference_for_tree (ref2->stmt, ref2->ref);
  return ipa_dr_may_alias_p (ipa_dr1, ipa_dr2);
}

#if 0
/* classic tree ref version */

bool
symee_refs_may_alias_p (tree ref1, tree ref2)
{
  return ipa_dr_may_alias_p (ref1, ref2);
}


bool
symee_refs_must_alias_p (tree ref1, tree ref2)
{
  /* We still can not give any information about must alias */
  return false;
}
#endif

