/* Interface for the GNU C++ pretty-printer.
   Copyright (C) 2003, 2004, 2005, 2007, 2009, 2010
   Free Software Foundation, Inc.
   Contributed by Gabriel Dos Reis <gdr@integrable-solutions.net>

This file is part of GCC.

GCC is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 3, or (at your option) any later
version.

GCC is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#ifndef GCC_SENSORC_PRETTY_PRINT_H
#define GCC_SENSORC_PRETTY_PRINT_H

#include "c-family/c-pretty-print.h"

#undef pp_c_base
#define pp_c_base(PP) (&(PP)->c_base)

typedef enum
{
  /* Ask for a qualified-id.  */
  pp_sensorc_flag_default_argument = 1 << pp_c_flag_last_bit

} sensorc_pretty_printer_flags;

typedef struct
{
  c_pretty_printer c_base;
  /* This is the enclosing scope of the entity being pretty-printed.  */
  tree enclosing_scope;
} sensorc_pretty_printer;

#define pp_sensorc_cv_qualifier_seq(PP, T)   \
   pp_c_type_qualifier_list (pp_c_base (PP), T)

#define pp_sensorc_whitespace(PP)		pp_c_whitespace (pp_c_base (PP))
#define pp_sensorc_left_paren(PP)		pp_c_left_paren (pp_c_base (PP))
#define pp_sensorc_right_paren(PP)		pp_c_right_paren (pp_c_base (PP))
#define pp_sensorc_left_brace(PP)		pp_c_left_brace (pp_c_base (PP))
#define pp_sensorc_right_brace(PP)		pp_c_right_brace (pp_c_base (PP))
#define pp_sensorc_left_bracket(PP)		pp_c_left_bracket (pp_c_base (PP))
#define pp_sensorc_right_bracket(PP)	pp_c_right_bracket (pp_c_base (PP))
#define pp_sensorc_dot(PP)			pp_c_dot (pp_c_base (PP))
#define pp_sensorc_ampersand(PP)		pp_c_ampersand (pp_c_base (PP))
#define pp_sensorc_star(PP)			pp_c_star (pp_c_base (PP))
#define pp_sensorc_arrow(PP)		pp_c_arrow (pp_c_base (PP))
#define pp_sensorc_semicolon(PP)		pp_c_semicolon (pp_c_base (PP))
#define pp_sensorc_complement(PP)		pp_c_complement (pp_c_base (PP))

#define pp_sensorc_ws_string(PP, I)		pp_c_ws_string (pp_c_base (PP), I)
#define pp_sensorc_identifier(PP, I)	pp_c_identifier (pp_c_base (PP), I)
#define pp_sensorc_tree_identifier(PP, T) pp_c_tree_identifier (pp_c_base (PP), T)

void pp_sensorc_pretty_printer_init (sensorc_pretty_printer *);
void pp_sensorc_begin_template_argument_list (sensorc_pretty_printer *);
void pp_sensorc_end_template_argument_list (sensorc_pretty_printer *);
void pp_sensorc_colon_colon (sensorc_pretty_printer *);
void pp_sensorc_separate_with (sensorc_pretty_printer *, int);

void pp_sensorc_declaration (sensorc_pretty_printer *, tree);
void pp_sensorc_canonical_template_parameter (sensorc_pretty_printer *, tree);
void pp_sensorc_trait_expression (sensorc_pretty_printer *, tree);
void pp_sensorc_va_arg_expression (sensorc_pretty_printer *, tree);
void pp_sensorc_offsetof_expression (sensorc_pretty_printer *, tree);

#endif /* GCC_SENSORC_PRETTY_PRINT_H */
