/* GCALC scanner
   Copyright (C) 2010
   Free Software Foundation, Inc.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 3, or (at your option) any later
   version.

   GCC is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  
*/

%{ 

  #include "config.h"
  #include "system.h"
  #include "ansidecl.h"
  #include "coretypes.h"
  #include "opts.h"
  #include "tree.h"
  #include "gimple.h"
  #include "toplev.h"
  #include "debug.h"
  #include "options.h"
  #include "flags.h"
  #include "hashtab.h"
  #include "convert.h"
  #include "diagnostic.h"
  #include "langhooks.h"
  #include "langhooks-def.h"
  #include "target.h"

  #include "calc_parser.h"
  #include "calc_lang.h"

  int calc_column = 0;

#define SET_LOCATION()   \
    calc_lloc.first_line = calc_lineno;    \
    calc_lloc.first_column = calc_column;
%}

%pointer

%option yylineno

DIGIT    [0-9]
ID       [_a-zA-Z][a-zA_Z0-9_$]*

%%

#.*                     ; /* comment */

\(                      {  return '('; }
\)                      {  return ')'; }

";"                     {  return ';'; }
","                     {  return ','; }

"="                     { return '='; }
"+"                     { return '+'; }
"-"                     { return '-'; }
"*"                     { return '*'; }
"/"                     { return '/'; }

"print"                 { /*print as a keyword*/ return PRINT; }

{DIGIT}+                {
                          long val = strtol(yytext, (char**)NULL, 10);
                          calc_lval.token = build_int_cst(integer_type_node, val );
			  									SET_LOCATION();
                          return INTEGER;
                        }

{ID}                    {
                          calc_lval.token = get_identifier(xstrdup(yytext));
			  									SET_LOCATION();
                          return IDENTIFIER;
                        }

[\n]                    ;

%%

int calc_wrap (void)
{
  return 1;
}

int calc_error (const char *msg)
{
  error("%s", msg);
  exit(FATAL_EXIT_CODE);
}
