/* GCALC parser 
   Copyright (C) 2010
   Free Software Foundation, Inc.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 3, or (at your option) any later
   version.

   GCC is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  
*/

%{
  //#include "calc_location.h"
  /*
#if !defined(YYLTYPE)
typedef struct calc_location
{
  int line;
  int column;
} calc_location_t;

typedef calc_location_t YYLTYPE;

#define YYLTYPE YYLTYPE                                                                                                           

#endif
  */
#define INFORM(msg) if (flag_gcalc_debug == 1) inform(0,msg)

#include "config.h"
#include "system.h"
#include "ansidecl.h"
#include "coretypes.h"
#include "tm.h"
#include "opts.h"
#include "tree.h"
#include "tree-iterator.h"
#include "tree-pass.h"
#include "gimple.h"
#include "toplev.h"
#include "debug.h"
#include "options.h"
#include "flags.h"
#include "convert.h"
#include "diagnostic-core.h"
#include "langhooks.h"
#include "langhooks-def.h"
#include "target.h"
#include "cgraph.h"

#include <gmp.h>
#include <mpfr.h>

#include "vec.h"
#include "hashtab.h"

#include "calc1.h"
#include "calc_lang.h"

#include "calc_parser.h"
#include "calc_scanner.h"

#if !defined(YYLLOC_DEFAULT)
# define YYLLOC_DEFAULT(Current, Rhs, N)                           \
do                                                                 \
if (N)                                                             \
{                                                                  \
(Current).first_line = YYRHSLOC(Rhs, 1).first_line;                            \
(Current).first_column = YYRHSLOC(Rhs, 1).first_column;                        \
}                                                                  \
else                                                               \
{                                                                  \
(Current).first_line = YYRHSLOC(Rhs, 0).first_line;                            \
(Current).first_column = YYRHSLOC(Rhs, 0).first_column;                        \
}                                                                  \
while (0)
#endif

%}

/* The token passing union between scanner and parser is just
 * a tree node, containing either a VAR_DECL or an INTEGER_CST 
 * (integer constant)
 */
%union
{
  tree token;
  VEC(tree,gc) * vec;
}

%debug

/* Locations will be added later to add debugging information */
%locations

/* The non-terminal statements is the start element of the parser */
%start statements

%token PRINT "print"

%token <token> INTEGER 
%token <token> IDENTIFIER

%type <token> stmt
%type <token> expression
%type <token> print_call
%type <token> primary
%type <token> accessor

%type <vec> argument_list
%type <vec> arguments

/* Definition of the priority and associativity of the basic operators */
%right '='
%left '-' '+' 
%left '*' '/'

%%

statements: /* epsilon */ 
          | statements stmt
          {
	    TREE_USED($2) = true;
	    append_to_statement_list($2, &main_stmts);
	    INFORM("statements: statements stmt"); 
	  }
          ;

stmt: expression ';'
    | print_call ';'
    ;

argument_list: argument_list ',' expression
             {
	       INFORM("argument_list <argument_list , expression>!");
	       VEC_safe_push( tree,gc, $1, $3 );
	       $$ = $1;
	     }
             | expression
	     {
	       INFORM("argument_list <expression>");
	       VEC(tree,gc) * args_list = VEC_alloc( tree,gc,0 );
	       VEC_safe_push( tree,gc,args_list,$1 );
	       $$ = args_list;
	     }
             ;

arguments:
          { $$ = NULL; }
          | argument_list
	  ;

print_call: "print" '(' arguments ')'
          {
	    INFORM("call :IDENTIFIER");
	    $$ = build_print_expr( UNKNOWN_LOCATION, VEC_length(tree,$3), $3 );
	  }
          ;

accessor: IDENTIFIER
        ;

expression: accessor '=' expression
          {
	    $$ = build_assign_expr($1, &@1, $3, &@3);
	    INFORM("expression: expression '=' expression");
	  }
          | expression '+' expression
	  {
	    $$ = build_add_expr($1, &@1, $3, &@3);
	    INFORM("expression: expression '+' expression");
	  }
          | expression '-' expression
	  { 
	    $$ = build_sub_expr($1, &@1, $3, &@3);
	    INFORM("expression: expression '-' expression");
	  }
          | expression '*' expression
	  {
	    $$ = build_mult_expr($1, &@1, $3, &@3);
	    INFORM("expression: expression '*' expression");
	  }
          | expression '/' expression
	  {
	    $$ = build_div_expr($1, &@1, $3, &@3);
	    INFORM("expression: expression '*' expression");
	  }
          | primary
	  {
	    $$ = $1;
	    INFORM("expression: primary");
	  }
          ;

primary: INTEGER { $$ = $1; INFORM("primary: INTEGER"); }
       | IDENTIFIER { $$ = $1; INFORM("primary: IDENTIFIER"); }
       ;

